/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleByteProperty
extends AbstractBasicChangeableItem
implements Property<Byte> {
    private static final long serialVersionUID = -1678345547647882885L;
    private byte value;

    public SimpleByteProperty(@NotNull String string) {
        this(string, 0);
    }

    public SimpleByteProperty(@NotNull String string, int n) {
        this(string, (byte)n);
    }

    public SimpleByteProperty(@NotNull String string, byte by) {
        super(string);
        this.value = by;
    }

    @Override
    @NotNull
    public Byte getValue() {
        return this.value;
    }

    @Override
    public void setValue(Byte by) {
        if (by == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue((byte)by);
    }

    @Override
    public void setValue(byte by) {
        if (by != this.value) {
            byte by2 = this.value;
            this.value = by;
            this.fireValueChange(this.getPropertyName(), by2, by);
        }
    }

    @Override
    public void setValue(int n) {
        this.setValue((byte)n);
    }
}

