/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleBooleanProperty
extends AbstractBasicChangeableItem
implements Property<Boolean> {
    private static final long serialVersionUID = -1387146652421540976L;
    private boolean value;

    public SimpleBooleanProperty(@NotNull String string, boolean bl) {
        super(string);
        this.value = bl;
    }

    @Override
    @NotNull
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean bl) {
        if (bl == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue((boolean)bl);
    }

    @Override
    public void setValue(boolean bl) {
        if (this.value != bl) {
            this.value = bl;
            this.fireValueChange(this.getPropertyName(), !this.value, bl);
        }
    }
}

