/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.i18n.I18n;
import java.util.Locale;
import java.util.MissingResourceException;

public class SettingsTools {
    private static final double[] HUMAN_STEPS = new double[]{0.1, 0.2, 0.25, 0.5, 1.0};

    public static String getOptionalI18nString(String string, Locale locale) {
        try {
            return I18n.getString(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static double getHumanStepNear(double d) {
        double d2 = Math.ceil(Math.log10(d));
        double d3 = d * Math.pow(10.0, -d2);
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        for (double d6 : HUMAN_STEPS) {
            double d7 = Math.abs(d3 - d6);
            if (!(d7 < d5)) continue;
            d4 = d6;
            d5 = d7;
        }
        return d4 * Math.pow(10.0, d2);
    }
}

