/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.Nullable;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;

public class PrintRequestProperties
extends HashPrintRequestAttributeSet {
    public static final String PREF_KEY_EXT_CLASS = ".class";
    public static final String PREF_KEY_MEDIA = "print.media";
    public static final EnumAttributeFinder[] MEDIA_FINDER = new EnumAttributeFinder[]{new MediaSizeNameHelper(), new MediaNameHelper(), new MediaTrayHelper()};
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_X = "print.area.x";
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_Y = "print.area.y";
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH = "print.area.w";
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT = "print.area.h";
    public static final String PREF_KEY_JOB_SHEETS = "print.jobsheets";
    public static final EnumAttributeFinder JOB_SHEETS_FINDER = new JobSheetsHelper();
    public static final String PREF_KEY_CHROMATICITY = "print.chromaticity";
    public static final Chromaticity[] CHROMATICITY_VALUES = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
    public static final String PREF_KEY_ORIENTATION = "print.orientation";
    public static final OrientationRequested[] ORIENTATION_VALUES = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE, OrientationRequested.REVERSE_PORTRAIT};
    private static final long serialVersionUID = -4265003505356917022L;

    public PrintRequestProperties() {
    }

    public PrintRequestProperties(@Nullable Preferences preferences) {
        if (preferences != null) {
            this.loadFrom(preferences);
        }
    }

    public PrintRequestProperties(PrintRequestAttribute printRequestAttribute) {
        super(printRequestAttribute);
    }

    public PrintRequestProperties(PrintRequestAttribute[] printRequestAttributeArray) {
        super(printRequestAttributeArray);
    }

    public PrintRequestProperties(PrintRequestAttributeSet printRequestAttributeSet) {
        super(printRequestAttributeSet);
    }

    public void storeTo(Preferences preferences) {
        this.storeEnumValue(preferences, PREF_KEY_MEDIA, Media.class);
        this.storeEnumValue(preferences, PREF_KEY_JOB_SHEETS, JobSheets.class);
        this.storeEnumValue(preferences, PREF_KEY_ORIENTATION, OrientationRequested.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.get(MediaPrintableArea.class);
        if (mediaPrintableArea != null) {
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_X, mediaPrintableArea.getX(1000));
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_Y, mediaPrintableArea.getY(1000));
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH, mediaPrintableArea.getWidth(1000));
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT, mediaPrintableArea.getHeight(1000));
        } else {
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_X);
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_Y);
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH);
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT);
        }
        Chromaticity chromaticity = (Chromaticity)this.get(Chromaticity.class);
        if (chromaticity != null) {
            preferences.putInt(PREF_KEY_CHROMATICITY, chromaticity.getValue());
        } else {
            preferences.remove(PREF_KEY_CHROMATICITY);
        }
    }

    public void loadFrom(Preferences preferences) {
        this.loadEnumValue(preferences, PREF_KEY_MEDIA, MEDIA_FINDER);
        this.loadEnumValue(preferences, PREF_KEY_JOB_SHEETS, JOB_SHEETS_FINDER);
        this.loadFinalValue(preferences, PREF_KEY_ORIENTATION, ORIENTATION_VALUES, ORIENTATION_VALUES);
        this.loadFinalValue(preferences, PREF_KEY_CHROMATICITY, CHROMATICITY_VALUES, CHROMATICITY_VALUES);
        float f = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_X, Float.NEGATIVE_INFINITY);
        float f2 = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_Y, Float.NEGATIVE_INFINITY);
        float f3 = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH, Float.NEGATIVE_INFINITY);
        float f4 = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT, Float.NEGATIVE_INFINITY);
        if (f != Float.NEGATIVE_INFINITY && f2 != Float.NEGATIVE_INFINITY && f3 != Float.NEGATIVE_INFINITY && f4 != Float.NEGATIVE_INFINITY) {
            this.add(new MediaPrintableArea(f, f2, f3, f4, 1000));
        }
    }

    private void loadFinalValue(Preferences preferences, String string, EnumSyntax[] enumSyntaxArray, PrintRequestAttribute[] printRequestAttributeArray) {
        int n = preferences.getInt(string, Integer.MIN_VALUE);
        if (n != Integer.MIN_VALUE) {
            for (int i = 0; i < enumSyntaxArray.length; ++i) {
                if (enumSyntaxArray[i].getValue() != n) continue;
                this.add(printRequestAttributeArray[i]);
                break;
            }
        }
    }

    private void storeEnumValue(Preferences preferences, String string, Class<?> clazz) {
        EnumSyntax enumSyntax = (EnumSyntax)((Object)this.get(clazz));
        if (enumSyntax != null) {
            preferences.put(string + PREF_KEY_EXT_CLASS, enumSyntax.getClass().toString());
            preferences.putInt(string, enumSyntax.getValue());
        } else {
            preferences.remove(string + PREF_KEY_EXT_CLASS);
            preferences.remove(string);
        }
    }

    private boolean loadEnumValue(Preferences preferences, String string, EnumAttributeFinder enumAttributeFinder) {
        return this.loadEnumValue(preferences, string, new EnumAttributeFinder[]{enumAttributeFinder});
    }

    private boolean loadEnumValue(Preferences preferences, String string, EnumAttributeFinder[] enumAttributeFinderArray) {
        String string2 = preferences.get(string + PREF_KEY_EXT_CLASS, null);
        if (string2 != null) {
            for (EnumAttributeFinder enumAttributeFinder : enumAttributeFinderArray) {
                Attribute attribute;
                int n;
                if (!string2.equals(enumAttributeFinder.getBasicClassname()) || (n = preferences.getInt(string, Integer.MIN_VALUE)) == Integer.MIN_VALUE || (attribute = enumAttributeFinder.getEnumValue(n)) == null) continue;
                this.add(attribute);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Attribute[] attributeArray = this.toArray();
        Arrays.sort(attributeArray, (attribute, attribute2) -> {
            String string = attribute.getClass().getName();
            String string2 = attribute2.getClass().getName();
            return string.compareToIgnoreCase(string2);
        });
        stringBuilder.append("PrintRequestProperties:");
        for (Attribute attribute3 : attributeArray) {
            stringBuilder.append('\n').append(attribute3.getClass().getName()).append('=').append(attribute3);
        }
        return stringBuilder.toString();
    }

    private static class JobSheetsHelper
    extends JobSheets
    implements EnumAttributeFinder {
        private static final long serialVersionUID = -6314574980780646293L;

        public JobSheetsHelper() {
            super(Integer.MIN_VALUE);
        }

        @Override
        public String getBasicClassname() {
            return JobSheets.class.toString();
        }

        @Override
        public Attribute getEnumValue(int n) {
            EnumSyntax[] enumSyntaxArray;
            for (EnumSyntax enumSyntax : enumSyntaxArray = this.getEnumValueTable()) {
                if (enumSyntax.getValue() != n) continue;
                return (Attribute)((Object)enumSyntax);
            }
            return null;
        }

        @Override
        public Object clone() {
            return this;
        }
    }

    private static class MediaTrayHelper
    extends MediaTray
    implements EnumAttributeFinder {
        private static final long serialVersionUID = 4888508475083833344L;

        public MediaTrayHelper() {
            super(Integer.MIN_VALUE);
        }

        @Override
        public String getBasicClassname() {
            return MediaTray.class.toString();
        }

        @Override
        public Attribute getEnumValue(int n) {
            return this.getMedia(n);
        }

        public Media getMedia(int n) {
            EnumSyntax[] enumSyntaxArray;
            for (EnumSyntax enumSyntax : enumSyntaxArray = this.getEnumValueTable()) {
                if (enumSyntax.getValue() != n) continue;
                return (Media)enumSyntax;
            }
            return null;
        }

        @Override
        public Object clone() {
            return this;
        }
    }

    private static class MediaNameHelper
    extends MediaName
    implements EnumAttributeFinder {
        private static final long serialVersionUID = 7652030131968137614L;

        public MediaNameHelper() {
            super(Integer.MIN_VALUE);
        }

        @Override
        public String getBasicClassname() {
            return MediaName.class.toString();
        }

        @Override
        public Attribute getEnumValue(int n) {
            return this.getMedia(n);
        }

        public Media getMedia(int n) {
            EnumSyntax[] enumSyntaxArray;
            for (EnumSyntax enumSyntax : enumSyntaxArray = this.getEnumValueTable()) {
                if (enumSyntax.getValue() != n) continue;
                return (Media)enumSyntax;
            }
            return null;
        }

        @Override
        public Object clone() {
            return this;
        }
    }

    private static class MediaSizeNameHelper
    extends MediaSizeName
    implements EnumAttributeFinder {
        private static final long serialVersionUID = 7594641644422344107L;

        public MediaSizeNameHelper() {
            super(Integer.MIN_VALUE);
        }

        @Override
        public String getBasicClassname() {
            return MediaSizeName.class.toString();
        }

        @Override
        public Attribute getEnumValue(int n) {
            return this.getMedia(n);
        }

        public Media getMedia(int n) {
            EnumSyntax[] enumSyntaxArray;
            for (EnumSyntax enumSyntax : enumSyntaxArray = this.getEnumValueTable()) {
                if (enumSyntax.getValue() != n) continue;
                return (Media)enumSyntax;
            }
            return null;
        }

        @Override
        public Object clone() {
            return this;
        }
    }

    public static interface EnumAttributeFinder
    extends Attribute {
        public String getBasicClassname();

        public Attribute getEnumValue(int var1);
    }
}

