/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.util.settings.EnumValue;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.Icon;

public class LocaleEnumValue
implements EnumValue<Locale> {
    private final Locale locale;

    public LocaleEnumValue(Locale locale) {
        this.locale = locale;
    }

    @Override
    @NotNull
    public String getShortName(@Nullable Locale locale) {
        return this.locale == null ? I18n.getString("localeDefault", locale) : this.locale.getDisplayName(locale);
    }

    @Override
    public String getLongName(@Nullable Locale locale) {
        return null;
    }

    @Override
    public Icon getIcon(@Nullable Locale locale) {
        return null;
    }

    @Override
    public void storeTo(@NotNull Preferences preferences, @NotNull String string) {
        if (this.locale == null) {
            preferences.remove(string);
        } else {
            preferences.put(string, this.locale.toString());
        }
    }

    @Override
    public boolean isEqualTo(@NotNull Preferences preferences, @NotNull String string) {
        String string2 = preferences.get(string, null);
        return this.locale == null && string2 == null || this.locale != null && this.locale.toString().equals(string2);
    }

    @Override
    public Locale getRealValue() {
        return this.locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

