/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.PreferenceProperty;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.prefs.Preferences;

public class BoundsPreferenceProperty
extends AbstractBasicChangeableItem
implements PreferenceProperty {
    private static final String EXT_X = "-X";
    private static final String EXT_Y = "-Y";
    private static final String EXT_WIDTH = "-WIDTH";
    private static final String EXT_HEIGHT = "-HEIGHT";
    private static final long serialVersionUID = -6294165270594094306L;
    private Rectangle bounds;

    public BoundsPreferenceProperty(@NotNull String string) {
        super(string);
    }

    @Override
    public void readFrom(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        int n = preferences.getInt(string + EXT_WIDTH, 0);
        int n2 = preferences.getInt(string + EXT_HEIGHT, 0);
        if (n > 0 && n2 > 0) {
            int n3 = preferences.getInt(string + EXT_X, 0);
            int n4 = preferences.getInt(string + EXT_Y, 0);
            this.setBounds(new Rectangle(n3, n4, n, n2));
        } else {
            this.setBounds((Rectangle)null);
        }
    }

    @Override
    public void storeTo(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        if (this.bounds == null) {
            preferences.remove(string + EXT_X);
            preferences.remove(string + EXT_Y);
            preferences.remove(string + EXT_WIDTH);
            preferences.remove(string + EXT_HEIGHT);
        } else {
            preferences.putInt(string + EXT_X, this.bounds.x);
            preferences.putInt(string + EXT_Y, this.bounds.y);
            preferences.putInt(string + EXT_WIDTH, this.bounds.width);
            preferences.putInt(string + EXT_HEIGHT, this.bounds.height);
        }
    }

    public boolean setWindowBounds(@NotNull Window window) {
        if (this.bounds != null) {
            window.setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            return true;
        }
        return false;
    }

    public void storeWindowBounds(@NotNull Preferences preferences, @NotNull Window window) {
        this.bounds = window.getBounds();
        this.storeTo(preferences);
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle == null) {
            if (this.bounds != null) {
                Rectangle rectangle2 = this.bounds;
                this.bounds = null;
                this.fireValueChange(this.getBasicName(), rectangle2, rectangle);
            }
        } else if (!rectangle.equals(this.bounds)) {
            Rectangle rectangle3 = this.bounds;
            this.bounds = new Rectangle(rectangle);
            this.fireValueChange(this.getBasicName(), rectangle3, rectangle);
        }
    }

    public void setBounds(Window window) {
        this.setBounds(window.getBounds());
    }
}

