/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.debug.Debug;
import de.caff.util.measure.IllegalPhysicalLengthFormatException;
import de.caff.util.measure.PhysicalLength;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.PhysicalLengthPreferenceProperty;
import java.util.Locale;
import java.util.prefs.Preferences;

public class BasicPhysicalLengthPreferenceProperty
extends AbstractBasicChangeableItem
implements PhysicalLengthPreferenceProperty {
    private static final long serialVersionUID = 8587773466603751354L;
    private PhysicalLength physicalLength;

    public BasicPhysicalLengthPreferenceProperty(@NotNull String string) {
        super(string);
    }

    public BasicPhysicalLengthPreferenceProperty(@NotNull String string, @Nullable PhysicalLength physicalLength) {
        super(string);
        this.physicalLength = physicalLength;
    }

    @Override
    public void readFrom(@NotNull Preferences preferences) {
        String string = preferences.get(this.getBasicName(), null);
        if (string == null) {
            this.physicalLength = null;
        } else {
            try {
                this.physicalLength = PhysicalLength.fromString(string, Locale.US);
            }
            catch (IllegalPhysicalLengthFormatException illegalPhysicalLengthFormatException) {
                Debug.error(illegalPhysicalLengthFormatException);
                this.physicalLength = null;
            }
        }
    }

    @Override
    public void storeTo(@NotNull Preferences preferences) {
        if (this.physicalLength == null) {
            preferences.remove(this.getBasicName());
        } else {
            preferences.put(this.getBasicName(), this.physicalLength.toString(Locale.US));
        }
    }

    @Override
    public PhysicalLength getValue() {
        return this.physicalLength;
    }

    @Override
    public void setValue(PhysicalLength physicalLength) {
        if (physicalLength == null) {
            if (this.physicalLength != null) {
                PhysicalLength physicalLength2 = this.physicalLength;
                this.physicalLength = null;
                this.fireValueChange(this.getBasicName(), physicalLength2, null);
            }
        } else if (!physicalLength.equals(this.physicalLength)) {
            PhysicalLength physicalLength3 = this.physicalLength;
            this.physicalLength = physicalLength;
            this.fireValueChange(this.getBasicName(), physicalLength3, this.physicalLength);
        }
    }
}

