/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.generics.DoublePair;
import de.caff.util.settings.HorizontalAlignment;
import de.caff.util.settings.VerticalAlignment;
import java.awt.geom.Rectangle2D;

public enum Alignment2D {
    SouthWest(VerticalAlignment.South, HorizontalAlignment.West),
    South(VerticalAlignment.South, HorizontalAlignment.Center),
    SouthEast(VerticalAlignment.South, HorizontalAlignment.East),
    West(VerticalAlignment.Center, HorizontalAlignment.West),
    Center(VerticalAlignment.Center, HorizontalAlignment.Center),
    East(VerticalAlignment.Center, HorizontalAlignment.East),
    NorthWest(VerticalAlignment.North, HorizontalAlignment.West),
    North(VerticalAlignment.North, HorizontalAlignment.Center),
    NorthEast(VerticalAlignment.North, HorizontalAlignment.East);

    @NotNull
    private final VerticalAlignment verticalAlignment;
    @NotNull
    private final HorizontalAlignment horizontalAlignment;

    private Alignment2D(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
    }

    @NotNull
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @NotNull
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @NotNull
    public DoublePair getTextOffset(@NotNull Rectangle2D rectangle2D, boolean bl) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        double d3 = -rectangle2D.getMinX() - d * this.horizontalAlignment.getFactor();
        double d4 = bl ? -rectangle2D.getMaxY() + d2 * this.verticalAlignment.getFactor() : -rectangle2D.getMinY() - d2 * this.verticalAlignment.getFactor();
        return new DoublePair(d3, d4);
    }
}

