/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.util.Utility;
import de.caff.util.settings.EnumValue;
import de.caff.util.settings.SettingsTools;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;

abstract class AbstractBasicEnumValue<E>
extends Number
implements EnumValue<E> {
    private static final long serialVersionUID = -8099011124534435314L;
    private final String baseTag;

    protected AbstractBasicEnumValue(String string) {
        this.baseTag = string;
    }

    @Override
    @NotNull
    public String getShortName(@Nullable Locale locale) {
        return I18n.getString(this.baseTag + "-NAME[ACTION]", locale);
    }

    @Override
    public String getLongName(@Nullable Locale locale) {
        String string = SettingsTools.getOptionalI18nString(this.baseTag + "-DESCR[ACTION]", locale);
        return string == null ? this.getShortName(locale) : string;
    }

    @Override
    public Icon getIcon(@Nullable Locale locale) {
        String string = SettingsTools.getOptionalI18nString(this.baseTag + "-ICON[ACTION]", locale);
        return string == null ? null : new ImageIcon(Utility.loadImage(string));
    }

    public EnumValue<E> getBasicValue() {
        return this;
    }
}

