/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.i18n.I18n;
import de.caff.util.settings.ChangeableItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.ref.WeakReference;

public abstract class AbstractBasicChangeableItem
implements ChangeableItem,
Serializable {
    private static final long serialVersionUID = -3242256867586823510L;
    private final String basicName;
    private final PropertyChangeSupport propertyChangeSupport;

    protected AbstractBasicChangeableItem(@NotNull String string) {
        this.basicName = string;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @NotNull
    protected String getBasicName() {
        return this.basicName;
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void addValueChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addValueChangeListenerWeakly(@NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(new WeakPropertyChangeListenerProxy(propertyChangeListener));
    }

    @Override
    public void removeValueChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removeValueChangeListenerWeakly(@NotNull PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
        for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
            WeakPropertyChangeListenerProxy weakPropertyChangeListenerProxy;
            PropertyChangeListener propertyChangeListener2;
            if (!(propertyChangeListenerArray[i] instanceof WeakPropertyChangeListenerProxy) || (propertyChangeListener2 = (weakPropertyChangeListenerProxy = (WeakPropertyChangeListenerProxy)propertyChangeListenerArray[i]).getWrapped()) != null && !propertyChangeListener.equals(propertyChangeListener2)) continue;
            this.propertyChangeSupport.removePropertyChangeListener(weakPropertyChangeListenerProxy);
        }
    }

    protected void fireValueChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void fireValueChange(String string, boolean bl, boolean bl2) {
        this.propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void fireValueChange(String string, int n, int n2) {
        this.propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    public String getPropertyName() {
        return this.getBasicName();
    }

    static {
        I18n.addAppResourceBase("de.caff.util.settings.swing.SettingsResourceBundle");
    }

    private class WeakPropertyChangeListenerProxy
    implements PropertyChangeListener {
        private final WeakReference<PropertyChangeListener> wrapped;

        WeakPropertyChangeListenerProxy(PropertyChangeListener propertyChangeListener) {
            this.wrapped = new WeakReference<PropertyChangeListener>(propertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.wrapped.get();
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            } else {
                AbstractBasicChangeableItem.this.propertyChangeSupport.removePropertyChangeListener(this);
            }
        }

        PropertyChangeListener getWrapped() {
            return (PropertyChangeListener)this.wrapped.get();
        }
    }
}

