/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.print;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.measure.LengthUnit;
import de.caff.util.measure.PhysicalLength;
import de.caff.util.print.PaperFormat;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.Serializable;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;

public class BasicPaperFormat
implements PaperFormat,
Serializable {
    private static final long serialVersionUID = -6120534107108996084L;
    public static final Orientation ORIENTATION_PORTRAIT = Orientation.Portrait;
    public static final Orientation ORIENTATION_LANDSCAPE = Orientation.Landscape;
    public static final Orientation ORIENTATION_UPSIDE_DOWN = Orientation.UpsideDown;
    public static final Orientation ORIENTATION_SEASCAPE = Orientation.Seascape;
    public static final LengthUnit AWT_POINTS = new LengthUnit(3.5277777777777776E-4, "AWT point", "AWT pt");
    public static final PhysicalLength DEFAULT_MARGIN = new PhysicalLength(10.0, LengthUnit.MILLIMETER);
    public static final BasicPaperFormat A5_PAPER = new BasicPaperFormat("A5", "iso-a5", 148.0, 210.0);
    public static final BasicPaperFormat A4_PAPER = new BasicPaperFormat("A4", "iso-a4", 210.0, 297.0);
    public static final BasicPaperFormat A3_PAPER = new BasicPaperFormat("A3", "iso-a3", 297.0, 420.0);
    public static final BasicPaperFormat A2_PAPER = new BasicPaperFormat("A2", "iso-a2", 420.0, 595.0);
    public static final BasicPaperFormat A1_PAPER = new BasicPaperFormat("A1", "iso-a1", 595.0, 841.0);
    public static final BasicPaperFormat A0_PAPER = new BasicPaperFormat("A0", "iso-a0", 841.0, 1189.0);
    public static final BasicPaperFormat B5_PAPER = new BasicPaperFormat("B5", "iso-b5", 176.0, 250.0);
    public static final BasicPaperFormat B4_PAPER = new BasicPaperFormat("B4", "iso-b4", 250.0, 353.0);
    public static final BasicPaperFormat B3_PAPER = new BasicPaperFormat("B3", "iso-b3", 353.0, 500.0);
    public static final BasicPaperFormat B2_PAPER = new BasicPaperFormat("B2", "iso-b2", 500.0, 707.0);
    public static final BasicPaperFormat B1_PAPER = new BasicPaperFormat("B1", "iso-b1", 707.0, 1000.0);
    public static final BasicPaperFormat B0_PAPER = new BasicPaperFormat("B0", "iso-b0", 1000.0, 1414.0);
    public static final BasicPaperFormat LETTER_PAPER = new BasicPaperFormat("Letter", "na-letter", 216.0, 279.0);
    public static final BasicPaperFormat LEGAL_PAPER = new BasicPaperFormat("Legal", "na-legal", 216.0, 356.0);
    public static final BasicPaperFormat EXECUTIVE_PAPER = new BasicPaperFormat("Executive", "executive", 190.0, 254.0);
    public static final BasicPaperFormat TABLOID_PAPER = new BasicPaperFormat("Tabloid", null, 279.0, 432.0);
    public static final BasicPaperFormat[] PAPER_FORMATS = new BasicPaperFormat[]{A5_PAPER, A4_PAPER, A3_PAPER, A2_PAPER, A1_PAPER, A0_PAPER, B5_PAPER, B4_PAPER, B3_PAPER, B2_PAPER, B1_PAPER, B0_PAPER, LETTER_PAPER, LEGAL_PAPER, EXECUTIVE_PAPER, TABLOID_PAPER};
    @NotNull
    private final PhysicalLength width;
    @NotNull
    private final PhysicalLength height;
    @NotNull
    private final PhysicalLength leftMargin;
    @NotNull
    private final PhysicalLength rightMargin;
    @NotNull
    private final PhysicalLength topMargin;
    @NotNull
    private final PhysicalLength bottomMargin;
    @Nullable
    private String name;
    @Nullable
    private String isoName;

    protected BasicPaperFormat(@Nullable String string, @Nullable String string2, double d, double d2) {
        this(new PhysicalLength(d, LengthUnit.MILLIMETER), new PhysicalLength(d2, LengthUnit.MILLIMETER), DEFAULT_MARGIN);
        this.name = string;
        this.isoName = string2;
    }

    public BasicPaperFormat(@Nullable String string, @NotNull PaperFormat paperFormat, @NotNull Orientation orientation) {
        this(string, null, paperFormat, orientation);
    }

    public BasicPaperFormat(@Nullable String string, @Nullable String string2, @NotNull PaperFormat paperFormat, @NotNull Orientation orientation) {
        switch (orientation) {
            case Portrait: {
                this.width = paperFormat.getWidth();
                this.height = paperFormat.getHeight();
                this.leftMargin = paperFormat.getLeftMargin();
                this.rightMargin = paperFormat.getRightMargin();
                this.topMargin = paperFormat.getTopMargin();
                this.bottomMargin = paperFormat.getBottomMargin();
                break;
            }
            case Landscape: {
                this.width = paperFormat.getHeight();
                this.height = paperFormat.getWidth();
                this.leftMargin = paperFormat.getTopMargin();
                this.rightMargin = paperFormat.getBottomMargin();
                this.topMargin = paperFormat.getRightMargin();
                this.bottomMargin = paperFormat.getLeftMargin();
                break;
            }
            case Seascape: {
                this.width = paperFormat.getHeight();
                this.height = paperFormat.getWidth();
                this.leftMargin = paperFormat.getBottomMargin();
                this.rightMargin = paperFormat.getTopMargin();
                this.topMargin = paperFormat.getLeftMargin();
                this.bottomMargin = paperFormat.getRightMargin();
                break;
            }
            case UpsideDown: {
                this.width = paperFormat.getWidth();
                this.height = paperFormat.getHeight();
                this.leftMargin = paperFormat.getRightMargin();
                this.rightMargin = paperFormat.getLeftMargin();
                this.topMargin = paperFormat.getBottomMargin();
                this.bottomMargin = paperFormat.getTopMargin();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown orientation: " + (Object)((Object)orientation));
            }
        }
        this.name = string;
        this.isoName = string2;
    }

    public BasicPaperFormat(@NotNull PhysicalLength physicalLength, @NotNull PhysicalLength physicalLength2, @NotNull PhysicalLength physicalLength3) {
        this(physicalLength, physicalLength2, physicalLength3, physicalLength3, physicalLength3, physicalLength3);
    }

    public BasicPaperFormat(@NotNull PhysicalLength physicalLength, @NotNull PhysicalLength physicalLength2, @NotNull PhysicalLength physicalLength3, @NotNull PhysicalLength physicalLength4, @NotNull PhysicalLength physicalLength5, @NotNull PhysicalLength physicalLength6) {
        this.width = physicalLength;
        this.height = physicalLength2;
        this.leftMargin = physicalLength3;
        this.rightMargin = physicalLength4;
        this.topMargin = physicalLength5;
        this.bottomMargin = physicalLength6;
        this.isoName = null;
    }

    public BasicPaperFormat(@NotNull PaperFormat paperFormat, @NotNull PhysicalLength physicalLength, @NotNull PhysicalLength physicalLength2, @NotNull PhysicalLength physicalLength3, @NotNull PhysicalLength physicalLength4) {
        this(paperFormat.getWidth(), paperFormat.getHeight(), physicalLength, physicalLength2, physicalLength3, physicalLength4);
        if (paperFormat instanceof BasicPaperFormat) {
            this.name = ((BasicPaperFormat)paperFormat).name;
            this.isoName = ((BasicPaperFormat)paperFormat).isoName;
        }
    }

    @Override
    @NotNull
    public PhysicalLength getWidth() {
        return this.width;
    }

    @Override
    @NotNull
    public PhysicalLength getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public PhysicalLength getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    @NotNull
    public PhysicalLength getRightMargin() {
        return this.rightMargin;
    }

    @Override
    @NotNull
    public PhysicalLength getTopMargin() {
        return this.topMargin;
    }

    @Override
    @NotNull
    public PhysicalLength getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public static PhysicalLength getInnerWidth(PaperFormat paperFormat) {
        return paperFormat.getWidth().minus(paperFormat.getLeftMargin()).minus(paperFormat.getRightMargin());
    }

    @NotNull
    public static PhysicalLength getInnerHeight(PaperFormat paperFormat) {
        return paperFormat.getHeight().minus(paperFormat.getTopMargin()).minus(paperFormat.getBottomMargin());
    }

    @NotNull
    public BasicPaperFormat toLandScape() {
        return new BasicPaperFormat(this.name + " (" + (Object)((Object)ORIENTATION_LANDSCAPE) + ")", this, ORIENTATION_LANDSCAPE);
    }

    @NotNull
    public BasicPaperFormat toSeaScape() {
        return new BasicPaperFormat(this.name + " (" + (Object)((Object)ORIENTATION_SEASCAPE) + ")", this, ORIENTATION_SEASCAPE);
    }

    @NotNull
    public BasicPaperFormat toUpsideDown() {
        return new BasicPaperFormat(this.name + " (" + (Object)((Object)ORIENTATION_UPSIDE_DOWN) + ")", this, ORIENTATION_UPSIDE_DOWN);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicPaperFormat basicPaperFormat = (BasicPaperFormat)object;
        if (!this.bottomMargin.equals(basicPaperFormat.bottomMargin)) {
            return false;
        }
        if (!this.height.equals(basicPaperFormat.height)) {
            return false;
        }
        if (!this.leftMargin.equals(basicPaperFormat.leftMargin)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(basicPaperFormat.name) : basicPaperFormat.name != null) {
            return false;
        }
        if (!this.rightMargin.equals(basicPaperFormat.rightMargin)) {
            return false;
        }
        if (!this.topMargin.equals(basicPaperFormat.topMargin)) {
            return false;
        }
        return this.width.equals(basicPaperFormat.width);
    }

    public int hashCode() {
        int n = this.width.hashCode();
        n = 31 * n + this.height.hashCode();
        n = 31 * n + this.leftMargin.hashCode();
        n = 31 * n + this.rightMargin.hashCode();
        n = 31 * n + this.topMargin.hashCode();
        n = 31 * n + this.bottomMargin.hashCode();
        n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }

    public boolean equalSized(@NotNull PaperFormat paperFormat) {
        return this.width.equals(paperFormat.getWidth()) && this.height.equals(paperFormat.getHeight()) && this.leftMargin.equals(paperFormat.getLeftMargin()) && this.rightMargin.equals(paperFormat.getRightMargin()) && this.topMargin.equals(paperFormat.getTopMargin()) && this.bottomMargin.equals(paperFormat.getBottomMargin());
    }

    @NotNull
    public MediaSize getMediaSize() {
        return new MediaSize((float)this.width.getLength(LengthUnit.MILLIMETER), (float)this.height.getLength(LengthUnit.MILLIMETER), 1000);
    }

    @NotNull
    public MediaPrintableArea getMediaPrintableArea() {
        return new MediaPrintableArea((float)this.leftMargin.getLength(LengthUnit.MILLIMETER), (float)this.topMargin.getLength(LengthUnit.MILLIMETER), (float)this.width.minus(this.leftMargin).minus(this.rightMargin).getLength(LengthUnit.MILLIMETER), (float)this.height.minus(this.topMargin).minus(this.bottomMargin).getLength(LengthUnit.MILLIMETER), 1000);
    }

    @Nullable
    public static BasicPaperFormat getPaperFormat(@Nullable String string) {
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.startsWith("din")) {
                string = string.substring(3).trim();
            } else if (string2.startsWith("iso-")) {
                string = string.substring(4);
            } else if (string2.startsWith("na-")) {
                string = string.substring(3);
            }
            for (BasicPaperFormat basicPaperFormat : PAPER_FORMATS) {
                if (!string.equalsIgnoreCase(basicPaperFormat.getName())) continue;
                return basicPaperFormat;
            }
        }
        return null;
    }

    @NotNull
    public static Paper toPaper(@NotNull PaperFormat paperFormat) {
        Paper paper = new Paper();
        paper.setSize(paperFormat.getHeight().getLength(AWT_POINTS), paperFormat.getWidth().getLength(AWT_POINTS));
        paper.setImageableArea(paperFormat.getLeftMargin().getLength(AWT_POINTS), paperFormat.getTopMargin().getLength(AWT_POINTS), BasicPaperFormat.getInnerWidth(paperFormat).getLength(AWT_POINTS), BasicPaperFormat.getInnerHeight(paperFormat).getLength(AWT_POINTS));
        return paper;
    }

    @NotNull
    public static BasicPaperFormat fromPaper(@NotNull Paper paper) {
        return new BasicPaperFormat(new PhysicalLength(paper.getWidth(), AWT_POINTS), new PhysicalLength(paper.getHeight(), AWT_POINTS), new PhysicalLength(paper.getImageableX(), AWT_POINTS), new PhysicalLength(paper.getWidth() - paper.getImageableX() - paper.getImageableWidth(), AWT_POINTS), new PhysicalLength(paper.getImageableY(), AWT_POINTS), new PhysicalLength(paper.getHeight() - paper.getImageableY() - paper.getImageableHeight(), AWT_POINTS));
    }

    @NotNull
    public static BasicPaperFormat fromPageFormat(@NotNull PageFormat pageFormat) {
        return new BasicPaperFormat(new PhysicalLength(pageFormat.getWidth(), AWT_POINTS), new PhysicalLength(pageFormat.getHeight(), AWT_POINTS), new PhysicalLength(pageFormat.getImageableX(), AWT_POINTS), new PhysicalLength(pageFormat.getWidth() - pageFormat.getImageableX() - pageFormat.getImageableWidth(), AWT_POINTS), new PhysicalLength(pageFormat.getImageableY(), AWT_POINTS), new PhysicalLength(pageFormat.getHeight() - pageFormat.getImageableY() - pageFormat.getImageableHeight(), AWT_POINTS));
    }

    public String toString() {
        return this.getName();
    }

    public static enum Orientation {
        Portrait(0, "portrait"),
        Landscape(90, "landscape"),
        UpsideDown(180, "upside-down"),
        Seascape(270, "seascape");

        private final int degrees;
        @NotNull
        private final String name;

        private Orientation(int n2, String string2) {
            this.degrees = n2;
            this.name = string2;
        }

        public int getDegrees() {
            return this.degrees;
        }

        @NotNull
        public String toString() {
            return this.name;
        }
    }
}

