/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.measure;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.OrderedPair;
import de.caff.i18n.I18n;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public final class SIPrefix {
    static final String I18N_PREFIX = "SI_PREFIX_";
    public static final SIPrefix DECI;
    public static final SIPrefix CENTI;
    public static final SIPrefix MILLI;
    public static final SIPrefix MICRO;
    public static final SIPrefix NANO;
    public static final SIPrefix PICO;
    public static final SIPrefix FEMTO;
    public static final SIPrefix ATTO;
    public static final SIPrefix ZEPTO;
    public static final SIPrefix YOCTO;
    public static final SIPrefix RONTO;
    public static final SIPrefix QUECTO;
    public static final SIPrefix NO_PREFIX;
    public static final SIPrefix DECA;
    public static final SIPrefix HECTO;
    public static final SIPrefix KILO;
    public static final SIPrefix MEGA;
    public static final SIPrefix GIGA;
    public static final SIPrefix TERA;
    public static final SIPrefix PETA;
    public static final SIPrefix EXA;
    public static final SIPrefix ZETTA;
    public static final SIPrefix YOTTA;
    public static final SIPrefix RONNA;
    public static final SIPrefix QUETTA;
    public static final SIPrefix KIBI;
    public static final SIPrefix MEBI;
    public static final SIPrefix GIBI;
    public static final SIPrefix TEBI;
    public static final SIPrefix PEBI;
    public static final SIPrefix EXBI;
    public static final SIPrefix ZEBI;
    public static final SIPrefix YOBI;
    private static final Map<String, SIPrefix> STRING_PREFIX_LENGTH1_TO_SI_PREFIXES;
    private static final Map<String, SIPrefix> STRING_PREFIX_LENGTH2_TO_SI_PREFIXES;
    @NotNull
    private final String name;
    @NotNull
    private final String prefix;
    private final double factor;

    private SIPrefix(@NotNull String string, @NotNull String string2, double d) {
        this.name = string;
        this.prefix = string2;
        this.factor = d;
    }

    public double getFactor() {
        return this.factor;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public String getName() {
        try {
            return I18n.getString(I18N_PREFIX + this.name);
        }
        catch (MissingResourceException missingResourceException) {
            return this.name;
        }
    }

    @Nullable
    public static SIPrefix getPrefix(@Nullable String string) {
        SIPrefix sIPrefix;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.length() >= 2 && (sIPrefix = STRING_PREFIX_LENGTH2_TO_SI_PREFIXES.get(string.substring(0, 2))) != null) {
            return sIPrefix;
        }
        return STRING_PREFIX_LENGTH1_TO_SI_PREFIXES.get(string.substring(0, 1));
    }

    @Nullable
    public static OrderedPair<SIPrefix, String> extractPrefix(@Nullable String string) {
        SIPrefix sIPrefix;
        if (string == null || string.length() < 2) {
            return null;
        }
        if (string.length() > 2 && (sIPrefix = STRING_PREFIX_LENGTH2_TO_SI_PREFIXES.get(string.substring(0, 2))) != null) {
            return OrderedPair.create((Object)sIPrefix, (Object)string.substring(2));
        }
        sIPrefix = STRING_PREFIX_LENGTH1_TO_SI_PREFIXES.get(string.substring(0, 1));
        return sIPrefix != null ? OrderedPair.create((Object)sIPrefix, (Object)string.substring(1)) : null;
    }

    public String toString() {
        return this.name;
    }

    static {
        SIPrefix[] sIPrefixArray;
        I18n.addAppResourceBase("de.caff.util.measure.UtilMeasureResourceBundle");
        DECI = new SIPrefix("deci", "d", 0.1);
        CENTI = new SIPrefix("centi", "c", 0.01);
        MILLI = new SIPrefix("milli", "m", 0.001);
        MICRO = new SIPrefix("micro", "\u00b5", 1.0E-6);
        NANO = new SIPrefix("nano", "n", 1.0E-9);
        PICO = new SIPrefix("pico", "p", 1.0E-12);
        FEMTO = new SIPrefix("femto", "f", 1.0E-15);
        ATTO = new SIPrefix("atto", "a", 1.0E-18);
        ZEPTO = new SIPrefix("zepto", "z", 1.0E-21);
        YOCTO = new SIPrefix("yocto", "y", 1.0E-24);
        RONTO = new SIPrefix("ronto", "r", 1.2E-26);
        QUECTO = new SIPrefix("quecto", "q", 1.2E-29);
        NO_PREFIX = new SIPrefix("", "", 1.0);
        DECA = new SIPrefix("deca", "da", 10.0);
        HECTO = new SIPrefix("hecto", "h", 100.0);
        KILO = new SIPrefix("kilo", "k", 1000.0);
        MEGA = new SIPrefix("mega", "M", 1000000.0);
        GIGA = new SIPrefix("giga", "G", 1.0E9);
        TERA = new SIPrefix("tera", "T", 1.0E12);
        PETA = new SIPrefix("peta", "P", 1.0E15);
        EXA = new SIPrefix("exa", "E", 1.0E18);
        ZETTA = new SIPrefix("zetta", "Z", 1.0E21);
        YOTTA = new SIPrefix("yotta", "Y", 1.0E24);
        RONNA = new SIPrefix("yotta", "R", 1.0E27);
        QUETTA = new SIPrefix("quetta", "Q", 1.0E27);
        KIBI = new SIPrefix("kibi", "ki", 1024.0);
        MEBI = new SIPrefix("mebi", "Mi", 1048576.0);
        GIBI = new SIPrefix("gibi", "Gi", 1.073741824E9);
        TEBI = new SIPrefix("tebi", "Ti", 1.099511627776E12);
        PEBI = new SIPrefix("pebi", "Pi", 1.125899906842624E15);
        EXBI = new SIPrefix("exbi", "Pi", 1.152921504606847E18);
        ZEBI = new SIPrefix("zebi", "Pi", Math.pow(2.0, 70.0));
        YOBI = new SIPrefix("yobi", "Yi", Math.pow(2.0, 80.0));
        STRING_PREFIX_LENGTH1_TO_SI_PREFIXES = new HashMap<String, SIPrefix>();
        STRING_PREFIX_LENGTH2_TO_SI_PREFIXES = new HashMap<String, SIPrefix>();
        block4: for (SIPrefix sIPrefix : sIPrefixArray = new SIPrefix[]{DECA, HECTO, KILO, MEGA, GIGA, TERA, PETA, EXA, ZETTA, YOTTA, RONTO, QUECTO, DECI, CENTI, MILLI, MICRO, NANO, PICO, FEMTO, ATTO, ZEPTO, YOCTO, RONNA, QUETTA, KIBI, MEBI, GIBI, TEBI, PEBI, EXBI, ZEBI, YOBI}) {
            switch (sIPrefix.prefix.length()) {
                case 1: {
                    STRING_PREFIX_LENGTH1_TO_SI_PREFIXES.put(sIPrefix.prefix, sIPrefix);
                    continue block4;
                }
                case 2: {
                    STRING_PREFIX_LENGTH2_TO_SI_PREFIXES.put(sIPrefix.prefix, sIPrefix);
                    continue block4;
                }
                default: {
                    throw new RuntimeException(String.format("Broken enum %s: unexpected prefix length %d!", SIPrefix.class, sIPrefix.prefix.length()));
                }
            }
        }
    }
}

