/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.measure;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.measure.IllegalPhysicalLengthFormatException;
import de.caff.util.measure.LengthUnit;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public final class PhysicalLength
implements Serializable,
Comparable<PhysicalLength> {
    @NotNull
    public static final String UNIT_FORMAT = "%f %s";
    private static final long serialVersionUID = -2448161374948652225L;
    private final double length;
    private final LengthUnit unit;
    private final double lengthInMeter;
    @NotNull
    public static final PhysicalLength NULL = new PhysicalLength(0.0, LengthUnit.METER);

    public PhysicalLength(double d, @NotNull LengthUnit lengthUnit) {
        this.length = d;
        this.unit = lengthUnit;
        this.lengthInMeter = lengthUnit.unitToMeter(d);
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public double getLengthInMeter() {
        return this.lengthInMeter;
    }

    public double getLength() {
        return this.length;
    }

    public double getLength(@NotNull LengthUnit lengthUnit) {
        return lengthUnit.otherToUnit(this.length, this.unit);
    }

    public String toString() {
        return String.format(UNIT_FORMAT, this.length, this.unit);
    }

    public String toString(@NotNull LengthUnit lengthUnit) {
        return String.format(UNIT_FORMAT, this.getLength(lengthUnit), lengthUnit);
    }

    public String toString(@NotNull Locale locale) {
        return String.format(locale, UNIT_FORMAT, this.length, this.unit);
    }

    public String toString(@NotNull LengthUnit lengthUnit, @NotNull Locale locale) {
        return String.format(locale, UNIT_FORMAT, this.getLength(lengthUnit), lengthUnit);
    }

    public boolean equals(@NotNull PhysicalLength physicalLength, @NotNull PhysicalLength physicalLength2) {
        return Math.abs(physicalLength.lengthInMeter - this.lengthInMeter) <= physicalLength2.lengthInMeter;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PhysicalLength physicalLength = (PhysicalLength)object;
        return this.equals(physicalLength, NULL);
    }

    public int hashCode() {
        long l = this.lengthInMeter != 0.0 ? Double.doubleToLongBits(this.lengthInMeter) : 0L;
        return (int)(l ^ l >>> 32);
    }

    @NotNull
    public PhysicalLength times(double d) {
        return new PhysicalLength(this.length * d, this.unit);
    }

    @NotNull
    public PhysicalLength dividedBy(double d) {
        return new PhysicalLength(this.length / d, this.unit);
    }

    public double dividedBy(@NotNull PhysicalLength physicalLength) {
        return this.lengthInMeter / physicalLength.lengthInMeter;
    }

    @NotNull
    public PhysicalLength plus(@NotNull PhysicalLength physicalLength) {
        return new PhysicalLength(this.length + physicalLength.getLength(this.unit), this.unit);
    }

    @NotNull
    public PhysicalLength minus(@NotNull PhysicalLength physicalLength) {
        return new PhysicalLength(this.length - physicalLength.getLength(this.unit), this.unit);
    }

    @NotNull
    public PhysicalLength in(@NotNull LengthUnit lengthUnit) {
        return new PhysicalLength(lengthUnit.otherToUnit(this.length, this.unit), lengthUnit);
    }

    @Override
    public int compareTo(@NotNull PhysicalLength physicalLength) {
        return Double.compare(this.lengthInMeter, physicalLength.lengthInMeter);
    }

    @NotNull
    public static PhysicalLength fromString(@NotNull String string, @Nullable Locale locale) throws IllegalPhysicalLengthFormatException {
        if ((string = string.trim()).length() < 2) {
            throw new IllegalPhysicalLengthFormatException("String too short to contain valid physical length: " + string);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new IllegalPhysicalLengthFormatException("String does not start with a valid floating point number for locale " + locale + ": " + string);
        }
        String string2 = string.substring(parsePosition.getIndex()).trim();
        LengthUnit lengthUnit = LengthUnit.getLengthUnit(string2);
        if (lengthUnit == null) {
            throw new IllegalPhysicalLengthFormatException("Unknown length unit: " + string2);
        }
        return new PhysicalLength(number.doubleValue(), lengthUnit);
    }

    @NotNull
    public static PhysicalLength fromString(@NotNull String string) throws IllegalPhysicalLengthFormatException {
        return PhysicalLength.fromString(string, Locale.getDefault());
    }

    @NotNull
    public static PhysicalLength in(double d) {
        return new PhysicalLength(d, LengthUnit.INCH);
    }

    @NotNull
    public static PhysicalLength ft(double d) {
        return new PhysicalLength(d, LengthUnit.FOOT);
    }

    @NotNull
    public static PhysicalLength m(double d) {
        return new PhysicalLength(d, LengthUnit.METER);
    }

    @NotNull
    public static PhysicalLength mm(double d) {
        return new PhysicalLength(d, LengthUnit.MILLIMETER);
    }

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            try {
                PhysicalLength physicalLength = PhysicalLength.fromString(string);
                System.out.println("Read: " + physicalLength);
            }
            catch (IllegalPhysicalLengthFormatException illegalPhysicalLengthFormatException) {
                illegalPhysicalLengthFormatException.printStackTrace();
            }
        }
    }
}

