/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.measure;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Primitives;
import de.caff.util.measure.PhysicalLength;
import de.caff.util.measure.SIPrefix;
import java.io.Serializable;
import java.util.Objects;

public final class LengthUnit
implements Serializable {
    public static final LengthUnit METER = new LengthUnit(1.0, "meter", "m");
    public static final LengthUnit KILOMETER = new LengthUnit(SIPrefix.KILO, METER);
    public static final LengthUnit DECIMETER = new LengthUnit(SIPrefix.DECI, METER);
    public static final LengthUnit CENTIMETER = new LengthUnit(SIPrefix.CENTI, METER);
    public static final LengthUnit MILLIMETER = new LengthUnit(SIPrefix.MILLI, METER);
    public static final LengthUnit MICROMETER = new LengthUnit(SIPrefix.MICRO, METER);
    public static final LengthUnit NANOMETER = new LengthUnit(SIPrefix.NANO, METER);
    public static final LengthUnit PICOMETER = new LengthUnit(SIPrefix.PICO, METER);
    public static final LengthUnit ANGSTROM = new LengthUnit(1.0E-10, "\u00c5ngstr\u00f8m", "\u00c5");
    public static final LengthUnit ASTRONOMICAL_UNIT = new LengthUnit(1.495978707E11, "Astronomical Unit", "au");
    public static final LengthUnit LIGHTYEAR = new LengthUnit(9.4607304725808E15, "Lightyear", "Lj");
    public static final LengthUnit PARSEC = new LengthUnit(3.0856775777948584E16, "Parsec", "pc");
    public static final LengthUnit INCH = new LengthUnit(0.0254, "inch", "in");
    public static final LengthUnit FOOT = new LengthUnit(12.0 * LengthUnit.INCH.ratio, "foot", "ft");
    public static final LengthUnit YARD = new LengthUnit(36.0 * LengthUnit.INCH.ratio, "yard", "yd");
    public static final LengthUnit MILE = new LengthUnit(1760.0 * LengthUnit.YARD.ratio, "mile", "stat.mil.");
    public static final LengthUnit POINT = new LengthUnit(LengthUnit.INCH.ratio / 72.0, "point", "pt");
    public static final LengthUnit PICA_POINT = new LengthUnit(LengthUnit.INCH.ratio / 72.27000072, "Anglo-Saxon pica point", "pp");
    private static final LengthUnit[] UNITS = new LengthUnit[]{METER, KILOMETER, DECIMETER, CENTIMETER, MILLIMETER, MICROMETER, NANOMETER, PICOMETER, ANGSTROM, ASTRONOMICAL_UNIT, LIGHTYEAR, PARSEC, INCH, FOOT, YARD, MILE, POINT, PICA_POINT};
    private static final long serialVersionUID = -8998868857886200850L;
    private final double ratio;
    @NotNull
    private final String name;
    @NotNull
    private final String shortCut;

    public LengthUnit(double d, @NotNull String string, @NotNull String string2) {
        this.ratio = d;
        this.name = string;
        this.shortCut = string2;
    }

    private LengthUnit(@NotNull SIPrefix sIPrefix, @NotNull LengthUnit lengthUnit) {
        this.ratio = lengthUnit.ratio * sIPrefix.getFactor();
        this.name = sIPrefix.getName() + lengthUnit.name;
        this.shortCut = sIPrefix.getPrefix() + lengthUnit.shortCut;
    }

    @NotNull
    public String getShortCut() {
        return this.shortCut;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getShortCut();
    }

    public double meterToUnit(double d) {
        return d / this.ratio;
    }

    public double unitToMeter(double d) {
        return d * this.ratio;
    }

    public double otherToUnit(double d, @NotNull LengthUnit lengthUnit) {
        return lengthUnit.unitToMeter(d) / this.ratio;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LengthUnit lengthUnit = (LengthUnit)object;
        return Primitives.areEqual((double)lengthUnit.ratio, (double)this.ratio) && this.name.equals(lengthUnit.name) && this.shortCut.equals(lengthUnit.shortCut);
    }

    public int hashCode() {
        return Objects.hash(Primitives.boxed((double)this.ratio), this.name, this.shortCut);
    }

    @NotNull
    public PhysicalLength length(double d) {
        return new PhysicalLength(d, this);
    }

    @Nullable
    public static LengthUnit getLengthUnit(@Nullable String string) {
        for (LengthUnit lengthUnit : UNITS) {
            if (!lengthUnit.getShortCut().equalsIgnoreCase(string)) continue;
            return lengthUnit;
        }
        return null;
    }
}

