/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.annotation.NotNull;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ObjectInspector {
    static String getInfo(@NotNull Object object, boolean bl) {
        try {
            Class<?> clazz;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Object: ").append(clazz.getName()).append('@').append(Integer.toHexString(object.hashCode())).append('\n');
            for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                stringBuilder.append(ObjectInspector.getFields(clazz, object, bl));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    private static String getFields(Class<?> clazz, Object object, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("{ // ");
        stringBuilder.append(clazz.getName()).append('\n');
        Field[] fieldArray = clazz.getDeclaredFields();
        for (Field accessibleObject : fieldArray) {
            stringBuilder.append('\t').append(accessibleObject.toGenericString()).append(" = ").append(ObjectInspector.getValue(accessibleObject, object)).append(";\n");
        }
        if (bl) {
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (((Method)accessibleObject).getReturnType() == null || !Modifier.isPublic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterTypes().length > 0 || !((Method)accessibleObject).getName().startsWith("get")) continue;
                try {
                    Object invocationTargetException = ((Method)accessibleObject).invoke(object, new Object[0]);
                    stringBuilder.append('\t').append(((Method)accessibleObject).toGenericString()).append("()=").append(invocationTargetException).append(";\n");
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String getValue(Field field, Object object) {
        try {
            field.setAccessible(true);
            StringBuilder stringBuilder = new StringBuilder();
            Class<?> clazz = field.getType();
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    stringBuilder.append(field.getInt(object));
                } else if (clazz == Boolean.TYPE) {
                    stringBuilder.append(field.getBoolean(object));
                } else if (clazz == Byte.TYPE) {
                    stringBuilder.append(field.getByte(object));
                } else if (clazz == Short.TYPE) {
                    stringBuilder.append(field.getShort(object));
                } else if (clazz == Long.TYPE) {
                    stringBuilder.append(field.getLong(object));
                } else if (clazz == Float.TYPE) {
                    stringBuilder.append(field.getFloat(object));
                } else if (clazz == Double.TYPE) {
                    stringBuilder.append(field.getDouble(object));
                }
            } else {
                stringBuilder.append(field.get(object));
            }
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return "?";
        }
        catch (SecurityException securityException) {
            return "?";
        }
    }
}

