/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.MemFormat;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MemoryUsagePanel
extends JPanel {
    private static final int MEMORY_UPDATE_TIME = 2000;
    private static final long serialVersionUID = 4485568376466427703L;
    private final JLabel _usedMemLabel;
    private final JLabel _freeMemLabel;
    private final JLabel _totalMemLabel;
    private final JLabel _maxUsedMemLabel;
    private long _maxUsedMem;

    public MemoryUsagePanel() {
        this(2000);
    }

    public MemoryUsagePanel(int n) {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 1, 1));
        jPanel.add(new JLabel("used:  ", 4));
        this._usedMemLabel = new JLabel();
        jPanel.add(this._usedMemLabel);
        jPanel.add(new JLabel("free:  ", 4));
        this._freeMemLabel = new JLabel();
        jPanel.add(this._freeMemLabel);
        jPanel.add(new JLabel("TOTAL:  ", 4));
        this._totalMemLabel = new JLabel();
        jPanel.add(this._totalMemLabel);
        jPanel.add(new JLabel("max. used:  ", 4));
        this._maxUsedMemLabel = new JLabel();
        jPanel.add(this._maxUsedMemLabel);
        this.add("North", jPanel);
        JButton jButton = new JButton("Collect!");
        jButton.addActionListener(actionEvent -> {
            System.gc();
            this._maxUsedMem = 0L;
            this.updateMemoryDisplay();
        });
        jButton.setToolTipText("Invokes the garbage collector and resets max.used");
        this.add("South", jButton);
        if (n > 0) {
            new Timer(2000, actionEvent -> this.updateMemoryDisplay()).start();
        }
    }

    private static String getString(long l) {
        return MemFormat.Base10.toString(l);
    }

    private void updateMemoryDisplay() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        long l3 = l2 - l;
        this._usedMemLabel.setText(MemoryUsagePanel.getString(l3));
        this._freeMemLabel.setText(MemoryUsagePanel.getString(l));
        this._totalMemLabel.setText(MemoryUsagePanel.getString(l2));
        if (l3 > this._maxUsedMem) {
            this._maxUsedMem = l3;
            this._maxUsedMemLabel.setText(MemoryUsagePanel.getString(this._maxUsedMem));
        }
    }
}

