/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;

public class Format {
    private static final String NULL_STRING = "<null>";

    public static String format(@NotNull Object object, Object ... objectArray) {
        String string = object.toString();
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                if ('0' <= c && c <= '9') {
                    int n2 = c - 48;
                    if (n2 >= objectArray.length) {
                        stringBuilder.append("<%").append(c).append(" missing>");
                        continue;
                    }
                    stringBuilder.append(Format.toString(objectArray[n2]));
                    continue;
                }
                if (c == '%') {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append('%').append(c);
                continue;
            }
            if (c == '%') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toString(@Nullable Object object) {
        return Format.toString(object, "{", ",", "}", "");
    }

    private static String toString(@Nullable Object object, @NotNull String string, @NotNull String string2, @NotNull String string3, @NotNull String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object == null) {
            return NULL_STRING;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            stringBuilder.append(string);
            if (clazz.getComponentType().isPrimitive()) {
                Class<?> clazz2 = clazz.getComponentType();
                if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object;
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuilder.append(nArray[i]);
                        if (i == nArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object;
                    for (int i = 0; i < sArray.length; ++i) {
                        stringBuilder.append(sArray[i]);
                        if (i == sArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object;
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuilder.append(byArray[i]);
                        if (i == byArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object;
                    for (int i = 0; i < lArray.length; ++i) {
                        stringBuilder.append(lArray[i]);
                        if (i == lArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object;
                    for (int i = 0; i < cArray.length; ++i) {
                        stringBuilder.append(cArray[i]);
                        if (i == cArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Boolean.TYPE) {
                    boolean[] blArray = (boolean[])object;
                    for (int i = 0; i < blArray.length; ++i) {
                        stringBuilder.append(blArray[i]);
                        if (i == blArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object;
                    for (int i = 0; i < fArray.length; ++i) {
                        stringBuilder.append(fArray[i]);
                        if (i == fArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object;
                    for (int i = 0; i < dArray.length; ++i) {
                        stringBuilder.append(dArray[i]);
                        if (i == dArray.length - 1) continue;
                        stringBuilder.append(string2);
                    }
                }
            } else {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuilder.append(Format.toString(objectArray[i], string4 + string, string4 + string2, string4 + string3, string4));
                    if (i == objectArray.length - 1) continue;
                    stringBuilder.append(string2);
                }
            }
            stringBuilder.append(string3);
            return stringBuilder.toString();
        }
        return object.toString();
    }

    public static int getMaxStringLength(@NotNull String[] stringArray) {
        int n = 0;
        for (String string : stringArray) {
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }

    public static String rpad(@NotNull String string, int n, @NotNull String string2) {
        if (!string2.isEmpty() && string.length() < n) {
            StringBuilder stringBuilder = new StringBuilder(n + string2.length());
            stringBuilder.append(string);
            while (stringBuilder.length() < n) {
                stringBuilder.append(string2);
            }
            string = stringBuilder.toString();
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String lpad(@NotNull String string, int n, @NotNull String string2) {
        if (!string2.isEmpty() && string.length() < n) {
            int n2 = (n - string.length() - 1) / string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + string2.length());
            for (int i = n2; i >= 0; ++i) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        if (string.length() > n) {
            string = string.substring(string.length() - n, n + 1);
        }
        return string;
    }

    public static String center(@NotNull String string, int n, @NotNull String string2) {
        int n2 = (n - string.length()) / 2;
        return Format.lpad(string, string.length() + n2, string2);
    }

    public static String replace(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != "") {
            String[] stringArray = new String[string.length()];
            int n = 0;
            while (string.contains(string2)) {
                stringArray[n++] = string.substring(0, string.indexOf(string2));
                string = string.substring(string.indexOf(string2) + string2.length());
            }
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(stringArray[i]).append(string3);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String trimLeft(@Nullable String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && (Character.isWhitespace(c = string.charAt(n)) || Character.isISOControl(c)); ++n) {
        }
        return string.substring(n, n2);
    }

    public static String trimRight(@Nullable String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = n2 - 1; n >= 0 && (Character.isWhitespace(c = string.charAt(n)) || Character.isISOControl(c)); --n) {
        }
        return string.substring(0, n + 1);
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"eins1", "eins2", "eins3"}, {"zwei1", "zwei2", "zwei3"}, {"drei1", "drei2", "drei3"}, null};
        System.out.println(Format.format("Integer array: %1", 1, 2, 3));
        System.out.println(Format.toString(stringArrayArray, "{\n  ", ",\n  ", "\n}", "  "));
        if (!"abcxx".equals(Format.rpad("abc", 5, "x"))) {
            System.out.println("rpad has an error (1)");
        }
        if (!"abcxx".equals(Format.rpad("abc", 5, "xx"))) {
            System.out.println("rpad has an error (2)");
        }
        if (!"abcxx".equals(Format.rpad("abc", 5, "xxxx"))) {
            System.out.println("rpad has an error (3)");
        }
        if (!"ab".equals(Format.rpad("abc", 2, "x"))) {
            System.out.println("rpad has an error (4)");
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "x"))) {
            System.out.println("lpad has an error (1) " + Format.lpad("abc", 5, "x"));
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "xx"))) {
            System.out.println("lpad has an error (2) " + Format.lpad("abc", 5, "xx"));
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "xxx"))) {
            System.out.println("lpad has an error (3) " + Format.lpad("abc", 5, "xxx"));
        }
        if (!"bc".equals(Format.lpad("abc", 2, "x"))) {
            System.out.println("lpad has an error (4) " + Format.lpad("abc", 2, "x"));
        }
        if (!"xabc".equals(Format.center("abc", 5, "x"))) {
            System.out.println("center has an error (1) " + Format.center("abc", 5, "x"));
        }
        if (!"xabc".equals(Format.center("abc", 6, "xx"))) {
            System.out.println("center has an error (2) " + Format.center("abc", 6, "xx"));
        }
        if (!"xxabc".equals(Format.center("abc", 7, "x"))) {
            System.out.println("center has an error (3) " + Format.center("abc", 7, "x"));
        }
        if (!"xxx".equals(Format.replace("xxx", "y", "z"))) {
            System.out.println("replace error (1) :" + Format.replace("xxx", "y", "z"));
        }
        if (!"zzz".equals(Format.replace("xxx", "x", "z"))) {
            System.out.println("replace error (2) :" + Format.replace("xxx", "x", "z"));
        }
        if (!"zx".equals(Format.replace("xyx", "xy", "z"))) {
            System.out.println("replace error (3) :" + Format.replace("xyx", "xy", "z"));
        }
        if (!"zz".equals(Format.replace("xyxy", "xy", "z"))) {
            System.out.println("replace error (4) :" + Format.replace("xyxy", "xy", "z"));
        }
        if (!"z234".equals(Format.replace("1234", "1", "z"))) {
            System.out.println("replace error (5) :" + Format.replace("1234", "1", "z"));
        }
        if (!"123z".equals(Format.replace("1234", "4", "z"))) {
            System.out.println("replace error (6) :" + Format.replace("1234", "4", "z"));
        }
    }
}

