/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.annotation.NotNull;
import de.caff.util.debug.Debug;
import java.io.OutputStream;

public class DebuggingOutputStream
extends OutputStream {
    static final int STDOUT = 0;
    static final int STDERR = 1;
    private final int _direction;

    DebuggingOutputStream(int n) {
        this._direction = n;
    }

    private void write(String string) {
        switch (this._direction) {
            case 0: {
                Debug.writeStdoutMessage(string);
                break;
            }
            case 1: {
                Debug.writeStderrMessage(string);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(new String(byArray));
    }

    @Override
    public void write(@NotNull byte[] byArray) {
        this.write(new String(byArray));
    }

    @Override
    public void write(@NotNull byte[] byArray, int n, int n2) {
        this.write(new String(byArray, n, n2));
    }
}

