/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.annotation.NotNull;
import de.caff.generics.Types;
import de.caff.util.debug.AnyMessageDebugListener;
import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.DebugConstants;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

class DebugMessageCook
implements AnyMessageDebugListener,
DebugConstants {
    private static final boolean THROW_ASSERTION_EXCEPTION = true;
    private static final boolean STOP_ON_FATAL_ERRORS = true;
    private static final boolean EMPTY_THROW_ASSERTION = false;
    private static final int EMPTY_FATAL_RETURN = 0;
    private static final String HEAD_TRACE = "TRACE";
    private static final String HEAD_MESSAGE = "MESSAGE";
    private static final String HEAD_WARNING = "WARNING";
    private static final String HEAD_ERROR = "ERROR";
    private static final String HEAD_FATAL = "FATAL ERROR";
    private static final String HEAD_LOG = "LOGGING";
    private static final String HEAD_ASSERTION = "ASSERTION FAILED";
    private Collection<ListenerData> _list = Types.synchronizedCollection(new LinkedList());

    DebugMessageCook() {
    }

    public void addListener(@NotNull CookedMessageDebugListener cookedMessageDebugListener) {
        this.addListener(cookedMessageDebugListener, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addListener(@NotNull CookedMessageDebugListener cookedMessageDebugListener, boolean bl, boolean bl2) {
        DebugMessageCook debugMessageCook = this;
        synchronized (debugMessageCook) {
            LinkedList<ListenerData> linkedList = new LinkedList<ListenerData>(this._list);
            linkedList.add(new ListenerData(cookedMessageDebugListener, bl, bl2));
            this._list = linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(@NotNull CookedMessageDebugListener cookedMessageDebugListener) {
        DebugMessageCook debugMessageCook = this;
        synchronized (debugMessageCook) {
            LinkedList<ListenerData> linkedList = new LinkedList<ListenerData>(this._list);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                ListenerData listenerData = (ListenerData)iterator.next();
                if (listenerData.listener != cookedMessageDebugListener) continue;
                iterator.remove();
                break;
            }
            this._list = linkedList;
        }
    }

    private static String getFormatted(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DateFormat.getDateTimeInstance().format(new Date())).append('\t').append(string).append(":\n");
        if (string2 != null) {
            int n = 0;
            int n2 = string2.indexOf(10);
            while (n2 != -1) {
                stringBuilder.append('\t').append(string2.substring(n, n2 + 1));
                n = n2 + 1;
                n2 = string2.indexOf(10, n);
            }
            stringBuilder.append('\t').append(string2.substring(n)).append('\n');
        } else {
            stringBuilder.append("\r<null>\n");
        }
        return stringBuilder.toString();
    }

    private synchronized Collection<ListenerData> getListeners() {
        return this._list;
    }

    private void distribute(int n, String string, String string2) {
        for (ListenerData listenerData : this.getListeners()) {
            listenerData.listener.receiveCookedMessage(n, string, string2);
        }
    }

    private int distributeFatal(String string, String string2) {
        boolean bl = false;
        for (ListenerData listenerData : this.getListeners()) {
            listenerData.listener.receiveCookedMessage(4, string, string2);
            if (bl || !listenerData.stopOnFatalErrors) continue;
            bl = true;
        }
        return bl ? 1 : 0;
    }

    private boolean distributeFailedAssertion(String string, String string2) {
        boolean bl = false;
        for (ListenerData listenerData : this.getListeners()) {
            listenerData.listener.receiveCookedMessage(6, string, string2);
            if (bl || !listenerData.stopOnFatalErrors) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void receiveTraceMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            this.distribute(0, DebugMessageCook.getFormatted(HEAD_TRACE, string), string2);
        }
    }

    @Override
    public void receiveStandardMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            this.distribute(1, DebugMessageCook.getFormatted(HEAD_MESSAGE, string), string2);
        }
    }

    @Override
    public void receiveWarningMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            this.distribute(2, DebugMessageCook.getFormatted(HEAD_WARNING, string), string2);
        }
    }

    @Override
    public void receiveErrorMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            this.distribute(3, DebugMessageCook.getFormatted(HEAD_ERROR, string), string2);
        }
    }

    @Override
    public void receiveLogMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            this.distribute(5, DebugMessageCook.getFormatted(HEAD_LOG, string), string2);
        }
    }

    @Override
    public int receiveFatalMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            return this.distributeFatal(DebugMessageCook.getFormatted(HEAD_FATAL, string), string2);
        }
        return 0;
    }

    @Override
    public boolean receiveFailedAssertionMessage(@NotNull String string, @NotNull String string2) {
        if (!this.getListeners().isEmpty()) {
            return this.distributeFailedAssertion(DebugMessageCook.getFormatted(HEAD_ASSERTION, string), string2);
        }
        return false;
    }

    public static String cookedPosition(String string) {
        return "\t[at " + string + "]\n";
    }

    static class ListenerData {
        final CookedMessageDebugListener listener;
        final boolean stopOnFatalErrors;
        final boolean throwAssertionException;

        ListenerData(@NotNull CookedMessageDebugListener cookedMessageDebugListener, boolean bl, boolean bl2) {
            this.listener = cookedMessageDebugListener;
            this.stopOnFatalErrors = bl;
            this.throwAssertionException = bl2;
        }
    }
}

