/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.Debug;
import de.caff.util.debug.DebugConstants;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DebugLevelSwitchBoard
extends JPanel
implements Debug.ModeChangeListener,
DebugConstants {
    private static final long serialVersionUID = 6426942752115020936L;
    private final JCheckBox _traceCB;
    private final JCheckBox _messageCB;
    private final JCheckBox _warningCB;
    private final JCheckBox _errorCB;
    private final JCheckBox _fatalCB;
    private final JCheckBox _logCB;
    private final JCheckBox _assertCB;
    private final JCheckBox _stdoutCB;
    private final JCheckBox _stderrCB;

    public DebugLevelSwitchBoard() {
        this.setLayout(new BoxLayout(this, 1));
        this._traceCB = new JCheckBox("Capture trace messages", Debug.getTraceMode());
        this._traceCB.addItemListener(itemEvent -> Debug.setTraceMode(itemEvent.getStateChange() == 1));
        this._traceCB.setToolTipText("Toggles the global setting for trace debug messages.");
        this.add(this._traceCB);
        this._messageCB = new JCheckBox("Capture standard messages", Debug.getStandardMode());
        this._messageCB.addItemListener(itemEvent -> Debug.setStandardMode(itemEvent.getStateChange() == 1));
        this._messageCB.setToolTipText("Toggles the global setting for standard debug messages.");
        this.add(this._messageCB);
        this._warningCB = new JCheckBox("Capture warnings", Debug.getWarningMode());
        this._warningCB.addItemListener(itemEvent -> Debug.setWarningMode(itemEvent.getStateChange() == 1));
        this._warningCB.setToolTipText("Toggles the global setting for warning debug messages.");
        this.add(this._warningCB);
        this._errorCB = new JCheckBox("Capture error messages", Debug.getErrorMode());
        this._errorCB.addItemListener(itemEvent -> Debug.setErrorMode(itemEvent.getStateChange() == 1));
        this._errorCB.setToolTipText("Toggles the global setting for error debug messages.");
        this.add(this._errorCB);
        this._fatalCB = new JCheckBox("Capture fatal error messages", Debug.getFatalMode());
        this._fatalCB.addItemListener(itemEvent -> Debug.setFatalMode(itemEvent.getStateChange() == 1));
        this._fatalCB.setToolTipText("Toggles the global setting for fatal error debug messages.");
        this.add(this._fatalCB);
        this._logCB = new JCheckBox("Capture logging messages", Debug.getLogMode());
        this._logCB.addItemListener(itemEvent -> Debug.setLogMode(itemEvent.getStateChange() == 1));
        this._logCB.setToolTipText("Toggles the global setting for logging messages.");
        this.add(this._logCB);
        this._assertCB = new JCheckBox("Capture failed assertions", Debug.getAssertionMode());
        this._assertCB.addItemListener(itemEvent -> Debug.setAssertionMode(itemEvent.getStateChange() == 1));
        this._assertCB.setToolTipText("Toggles the global setting for failed assertion messages.");
        this.add(this._assertCB);
        this._stdoutCB = new JCheckBox("Capture stdout", Debug.getStdoutCaptureMode());
        this._stdoutCB.addItemListener(itemEvent -> Debug.setStdoutCaptureMode(itemEvent.getStateChange() == 1));
        this._stdoutCB.setToolTipText("If set, messages to stdout are shown as standard messages");
        this.add(this._stdoutCB);
        this._stderrCB = new JCheckBox("Capture stderr", Debug.getStderrCaptureMode());
        this._stderrCB.addItemListener(itemEvent -> Debug.setStderrCaptureMode(itemEvent.getStateChange() == 1));
        this._stderrCB.setToolTipText("If set, messages to stderr are shown as error messages");
        this.add(this._stderrCB);
        Debug.addModeChangeListener(this);
    }

    @Override
    public void modeChanged(int n, boolean bl) {
        int n2 = n;
        boolean bl2 = bl;
        SwingUtilities.invokeLater(() -> {
            switch (n2) {
                case 0: {
                    this._traceCB.setSelected(bl2);
                    break;
                }
                case 1: {
                    this._messageCB.setSelected(bl2);
                    break;
                }
                case 2: {
                    this._warningCB.setSelected(bl2);
                    break;
                }
                case 3: {
                    this._errorCB.setSelected(bl2);
                    break;
                }
                case 4: {
                    this._fatalCB.setSelected(bl2);
                    break;
                }
                case 5: {
                    this._logCB.setSelected(bl2);
                    break;
                }
                case 6: {
                    this._assertCB.setSelected(bl2);
                }
            }
        });
    }

    @Override
    public void stdoutCaptureChanged(boolean bl) {
        boolean bl2 = bl;
        SwingUtilities.invokeLater(() -> this._stdoutCB.setSelected(bl2));
    }

    @Override
    public void stderrCaptureChanged(boolean bl) {
        boolean bl2 = bl;
        SwingUtilities.invokeLater(() -> this._stderrCB.setSelected(bl2));
    }
}

