/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.util.Utility;
import de.caff.util.debug.AnyMessageDebugListener;
import de.caff.util.debug.AssertionFailedError;
import de.caff.util.debug.AssertionMessageDebugListener;
import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.DebugConstants;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.DebuggingOutputStream;
import de.caff.util.debug.ErrorMessageDebugListener;
import de.caff.util.debug.FatalMessageDebugListener;
import de.caff.util.debug.FilteringDebugMessageWindow;
import de.caff.util.debug.Format;
import de.caff.util.debug.LogMessageListener;
import de.caff.util.debug.ObjectInspector;
import de.caff.util.debug.SimpleOutputtingDebugListener;
import de.caff.util.debug.StandardMessageDebugListener;
import de.caff.util.debug.TraceMessageDebugListener;
import de.caff.util.debug.WarningMessageDebugListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Debug
implements DebugConstants {
    private static long _mask = 0L;
    private static final boolean _bufferStreams = false;
    @NotNull
    private static final DebugMessageCook _cook = new DebugMessageCook();
    @NotNull
    private static final Collection<TraceMessageDebugListener> _traceList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<StandardMessageDebugListener> _stdList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<WarningMessageDebugListener> _warnList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<ErrorMessageDebugListener> _errorList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<FatalMessageDebugListener> _fatalList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<AssertionMessageDebugListener> _assertList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<LogMessageListener> _logList = Types.synchronizedCollection(new LinkedList());
    @NotNull
    private static final Collection<ModeChangeListener> _modeList = Types.synchronizedCollection(new LinkedList());
    private static PrintStream _oldStdout = null;
    private static StringBuffer _collectedStdout = null;
    private static PrintStream _oldStderr = null;
    private static StringBuffer _collectedStderr = null;
    private static boolean _haveInitializedFromProperties = false;
    private static JFrame _debugWindow = null;
    @NotNull
    private static final Object _loggerConnectorSyncHelp = new Object();
    private static LoggerConnector _loggerConnector = null;
    @NotNull
    private static final Locale stringFormatLocale;
    private static final Package DEBUG_PACKAGE;
    private static final String DEBUG_PACKAGE_PREFIX;

    public static void addModeChangeListener(@NotNull ModeChangeListener modeChangeListener) {
        _modeList.add(modeChangeListener);
    }

    public static void removeModeChangeListener(@NotNull ModeChangeListener modeChangeListener) {
        _modeList.remove(modeChangeListener);
    }

    private static void informModeChangeListeners(int n, boolean bl) {
        for (ModeChangeListener modeChangeListener : _modeList) {
            modeChangeListener.modeChanged(n, bl);
        }
    }

    private static void informStdoutCaptureModeListeners(boolean bl) {
        for (ModeChangeListener modeChangeListener : _modeList) {
            modeChangeListener.stdoutCaptureChanged(bl);
        }
    }

    private static void informStderrCaptureModeListeners(boolean bl) {
        for (ModeChangeListener modeChangeListener : _modeList) {
            modeChangeListener.stderrCaptureChanged(bl);
        }
    }

    public static void addTraceMessageDebugListener(@NotNull TraceMessageDebugListener traceMessageDebugListener) {
        _traceList.add(traceMessageDebugListener);
    }

    public static void removeTraceMessageDebugListener(@NotNull TraceMessageDebugListener traceMessageDebugListener) {
        _traceList.remove(traceMessageDebugListener);
    }

    public static void addStandardMessageDebugListener(@NotNull StandardMessageDebugListener standardMessageDebugListener) {
        _stdList.add(standardMessageDebugListener);
    }

    public static void removeStandardMessageDebugListener(@NotNull StandardMessageDebugListener standardMessageDebugListener) {
        _stdList.remove(standardMessageDebugListener);
    }

    public static void addWarningMessageDebugListener(@NotNull WarningMessageDebugListener warningMessageDebugListener) {
        _warnList.add(warningMessageDebugListener);
    }

    public static void removeWarningMessageDebugListener(@NotNull WarningMessageDebugListener warningMessageDebugListener) {
        _warnList.remove(warningMessageDebugListener);
    }

    public static void addErrorMessageDebugListener(@NotNull ErrorMessageDebugListener errorMessageDebugListener) {
        _errorList.add(errorMessageDebugListener);
    }

    public static void removeErrorMessageDebugListener(@NotNull ErrorMessageDebugListener errorMessageDebugListener) {
        _errorList.remove(errorMessageDebugListener);
    }

    public static void addFatalMessageDebugListener(@NotNull FatalMessageDebugListener fatalMessageDebugListener) {
        _fatalList.add(fatalMessageDebugListener);
    }

    public static void removeFatalMessageDebugListener(@NotNull FatalMessageDebugListener fatalMessageDebugListener) {
        _fatalList.remove(fatalMessageDebugListener);
    }

    public static void addAssertionMessageDebugListener(@NotNull AssertionMessageDebugListener assertionMessageDebugListener) {
        _assertList.add(assertionMessageDebugListener);
    }

    public static void removeAssertionMessageDebugListener(@NotNull AssertionMessageDebugListener assertionMessageDebugListener) {
        _assertList.remove(assertionMessageDebugListener);
    }

    public static void addLogMessageListener(@NotNull LogMessageListener logMessageListener) {
        _logList.add(logMessageListener);
    }

    public static void removeLogMessageListener(@NotNull LogMessageListener logMessageListener) {
        _logList.remove(logMessageListener);
    }

    public static void addCookedMessageDebugListener(@NotNull CookedMessageDebugListener cookedMessageDebugListener) {
        _cook.addListener(cookedMessageDebugListener);
    }

    public static void removeCookedMessageDebugListener(@NotNull CookedMessageDebugListener cookedMessageDebugListener) {
        _cook.removeListener(cookedMessageDebugListener);
    }

    public static void addAnyMessageDebugListener(@NotNull AnyMessageDebugListener anyMessageDebugListener) {
        Debug.addTraceMessageDebugListener(anyMessageDebugListener);
        Debug.addStandardMessageDebugListener(anyMessageDebugListener);
        Debug.addWarningMessageDebugListener(anyMessageDebugListener);
        Debug.addErrorMessageDebugListener(anyMessageDebugListener);
        Debug.addFatalMessageDebugListener(anyMessageDebugListener);
        Debug.addAssertionMessageDebugListener(anyMessageDebugListener);
        Debug.addLogMessageListener(anyMessageDebugListener);
    }

    public static void removeAnyMessageDebugListener(@NotNull AnyMessageDebugListener anyMessageDebugListener) {
        Debug.removeTraceMessageDebugListener(anyMessageDebugListener);
        Debug.removeStandardMessageDebugListener(anyMessageDebugListener);
        Debug.removeWarningMessageDebugListener(anyMessageDebugListener);
        Debug.removeErrorMessageDebugListener(anyMessageDebugListener);
        Debug.removeFatalMessageDebugListener(anyMessageDebugListener);
        Debug.removeAssertionMessageDebugListener(anyMessageDebugListener);
        Debug.removeLogMessageListener(anyMessageDebugListener);
    }

    public static void setMask(long l) {
        if (l != _mask) {
            long l2 = _mask ^ l;
            for (int i = 0; i < 64; ++i) {
                if ((1L << i & l2) == 0L) continue;
                Debug.informModeChangeListeners(i, (l & 1L << i) != 0L);
            }
            _mask = l;
        }
    }

    public static long getMask() {
        return _mask;
    }

    public static void setTraceMode(boolean bl) {
        if (Debug.getTraceMode() != bl) {
            _mask = bl ? (_mask |= 1L) : (_mask &= 0xFFFFFFFFFFFFFFFEL);
            Debug.informModeChangeListeners(0, bl);
        }
    }

    public static boolean getTraceMode() {
        return (_mask & 1L) != 0L;
    }

    public static void setStandardMode(boolean bl) {
        if (Debug.getStandardMode() != bl) {
            _mask = bl ? (_mask |= 2L) : (_mask &= 0xFFFFFFFFFFFFFFFDL);
            Debug.informModeChangeListeners(1, bl);
        }
    }

    public static boolean getStandardMode() {
        return (_mask & 2L) != 0L;
    }

    public static void setWarningMode(boolean bl) {
        if (Debug.getWarningMode() != bl) {
            _mask = bl ? (_mask |= 4L) : (_mask &= 0xFFFFFFFFFFFFFFFBL);
            Debug.informModeChangeListeners(2, bl);
        }
    }

    public static boolean getWarningMode() {
        return (_mask & 4L) != 0L;
    }

    public static void setErrorMode(boolean bl) {
        if (Debug.getErrorMode() != bl) {
            _mask = bl ? (_mask |= 8L) : (_mask &= 0xFFFFFFFFFFFFFFF7L);
            Debug.informModeChangeListeners(3, bl);
        }
    }

    public static boolean getErrorMode() {
        return (_mask & 8L) != 0L;
    }

    public static void setLogMode(boolean bl) {
        if (Debug.getLogMode() != bl) {
            _mask = bl ? (_mask |= 0x20L) : (_mask &= 0xFFFFFFFFFFFFFFDFL);
            Debug.informModeChangeListeners(5, bl);
        }
    }

    public static boolean getLogMode() {
        return (_mask & 0x20L) != 0L;
    }

    public static void setFatalMode(boolean bl) {
        if (Debug.getFatalMode() != bl) {
            _mask = bl ? (_mask |= 0x10L) : (_mask &= 0xFFFFFFFFFFFFFFEFL);
            Debug.informModeChangeListeners(4, bl);
        }
    }

    public static boolean getFatalMode() {
        return (_mask & 0x10L) != 0L;
    }

    public static void setAssertionMode(boolean bl) {
        if (Debug.getAssertionMode() != bl) {
            _mask = bl ? (_mask |= 0x40L) : (_mask &= 0xFFFFFFFFFFFFFFBFL);
            Debug.informModeChangeListeners(6, bl);
        }
    }

    public static boolean getAssertionMode() {
        return (_mask & 0x40L) != 0L;
    }

    private static void distributeTraceMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        String string2 = Debug.getCallerPosition();
        for (TraceMessageDebugListener traceMessageDebugListener : _traceList) {
            traceMessageDebugListener.receiveTraceMessage(string, string2);
        }
    }

    private static void distributeStandardMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        String string2 = Debug.getCallerPosition();
        for (StandardMessageDebugListener standardMessageDebugListener : _stdList) {
            standardMessageDebugListener.receiveStandardMessage(string, string2);
        }
    }

    private static void distributeWarningMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        String string2 = Debug.getCallerPosition();
        for (WarningMessageDebugListener warningMessageDebugListener : _warnList) {
            warningMessageDebugListener.receiveWarningMessage(string, string2);
        }
    }

    private static void distributeErrorMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        String string2 = Debug.getCallerPosition();
        for (ErrorMessageDebugListener errorMessageDebugListener : _errorList) {
            errorMessageDebugListener.receiveErrorMessage(string, string2);
        }
    }

    private static void distributeLogMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        String string2 = Debug.getCallerPosition();
        for (LogMessageListener logMessageListener : _logList) {
            logMessageListener.receiveLogMessage(string, string2);
        }
    }

    private static void distributeFatalMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        int n = 0;
        String string2 = Debug.getCallerPosition();
        for (FatalMessageDebugListener fatalMessageDebugListener : _fatalList) {
            int n2 = fatalMessageDebugListener.receiveFatalMessage(string, string2);
            if (n != 0 || n2 == 0) continue;
            n = n2;
        }
        if (n != 0) {
            System.err.println(string);
            System.exit(n);
        }
    }

    private static boolean distributeAssertionMessage(@NotNull String string) {
        Debug.sendCollectedStreams();
        boolean bl = false;
        String string2 = Debug.getCallerPosition();
        for (AssertionMessageDebugListener assertionMessageDebugListener : _assertList) {
            boolean bl2 = assertionMessageDebugListener.receiveFailedAssertionMessage(string, string2);
            if (bl || !bl2) continue;
            bl = bl2;
        }
        return bl;
    }

    @NotNull
    public static String getStackDump(@NotNull Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    @NotNull
    public static String getErrorMessage(@NotNull Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.getClass().getCanonicalName();
        }
        return string;
    }

    public static void trace(@NotNull String string) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(string);
        }
    }

    public static void trace(@NotNull Throwable throwable) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Debug.getStackDump(throwable));
        }
    }

    public static void trace(@NotNull Object object) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.toString(object));
        }
    }

    public static void trace(@NotNull String string, Object ... objectArray) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format(string, objectArray));
        }
    }

    public static void tracef(@NotNull String string, Object ... objectArray) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(String.format(stringFormatLocale, string, objectArray));
        }
    }

    public static void message(@NotNull String string) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(string);
        }
    }

    public static void message(@NotNull Throwable throwable) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeStandardMessage(Debug.getStackDump(throwable));
        }
    }

    public static void message(@Nullable Object object) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.toString(object));
        }
    }

    public static void message(@NotNull String string, Object ... objectArray) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format(string, objectArray));
        }
    }

    public static void messagef(@NotNull String string, Object ... objectArray) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(String.format(stringFormatLocale, string, objectArray));
        }
    }

    public static void warn(@NotNull String string) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(string);
        }
    }

    public static void warn(@NotNull Throwable throwable) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Debug.getStackDump(throwable));
        }
    }

    public static void warn(@Nullable Object object) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.toString(object));
        }
    }

    public static void warn(@NotNull String string, Object ... objectArray) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format(string, objectArray));
        }
    }

    public static void warnf(@NotNull String string, Object ... objectArray) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(String.format(stringFormatLocale, string, objectArray));
        }
    }

    public static void error(@NotNull String string) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(string);
        }
    }

    public static void error(@NotNull Throwable throwable) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Debug.getStackDump(throwable));
        }
    }

    public static void error(@Nullable Object object) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.toString(object));
        }
    }

    public static void error(@NotNull String string, Object ... objectArray) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format(string, objectArray));
        }
    }

    public static void errorf(@NotNull String string, Object ... objectArray) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(String.format(stringFormatLocale, string, objectArray));
        }
    }

    public static void fatal(@NotNull String string) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(string);
        }
    }

    public static void fatal(@NotNull Throwable throwable) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Debug.getStackDump(throwable));
        }
    }

    public static void fatal(@Nullable Object object) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.toString(object));
        }
    }

    public static void fatal(@NotNull String string, Object ... objectArray) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format(string, objectArray));
        }
    }

    public static void fatalf(@NotNull String string, Object ... objectArray) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(String.format(stringFormatLocale, string, objectArray));
        }
    }

    public static void log(@NotNull String string) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(string);
        }
    }

    public static void log(@NotNull Throwable throwable) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Debug.getStackDump(throwable));
        }
    }

    public static void log(@Nullable Object object) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.toString(object));
        }
    }

    public static void log(@NotNull String string, Object ... objectArray) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format(string, objectArray));
        }
    }

    public static void logf(@NotNull String string, Object ... objectArray) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(String.format(stringFormatLocale, string, objectArray));
        }
    }

    public static void insist(boolean bl) {
        if (!bl && (_mask & 0x40L) != 0L && Debug.distributeAssertionMessage("Assertion Failure!")) {
            throw new AssertionFailedError();
        }
    }

    public static void insist(boolean bl, @NotNull String string) {
        if (!bl && (_mask & 0x40L) != 0L && Debug.distributeAssertionMessage(string)) {
            throw new AssertionFailedError(string);
        }
    }

    @NotNull
    private static String getCallerPosition() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 1; i < n; ++i) {
            if (stackTraceElementArray[i].getClassName().startsWith(DEBUG_PACKAGE_PREFIX)) continue;
            return stackTraceElementArray[i].toString();
        }
        return "???";
    }

    @NotNull
    public static JFrame createDebugWindow() {
        return Debug.createDebugWindow(false);
    }

    @NotNull
    public static JFrame createDebugWindow(boolean bl) {
        if (_debugWindow != null && _debugWindow.isVisible()) {
            _debugWindow.setVisible(false);
        }
        _debugWindow = new FilteringDebugMessageWindow();
        if (bl) {
            _debugWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        return _debugWindow;
    }

    private static void sendCollectedStdout() {
        if (_collectedStdout != null) {
            String string = _collectedStdout.toString();
            _collectedStdout = null;
            Debug.distributeStandardMessage(string);
        }
    }

    private static void sendCollectedStderr() {
        if (_collectedStderr != null) {
            String string = _collectedStderr.toString();
            _collectedStderr = null;
            Debug.distributeErrorMessage(string);
        }
    }

    private static void sendCollectedStreams() {
        Debug.sendCollectedStdout();
        Debug.sendCollectedStderr();
    }

    static void writeStdoutMessage(@NotNull String string) {
        Debug.sendCollectedStderr();
        int n = string.length();
        if (n > 0) {
            if (string.charAt(n - 1) == '\n') {
                string = string.substring(0, n - 1);
            }
            Debug.sendCollectedStdout();
            Debug.distributeStandardMessage("[STDERR>\n" + string);
        }
    }

    static void writeStderrMessage(@NotNull String string) {
        Debug.sendCollectedStdout();
        int n = string.length();
        if (n > 0) {
            if (string.charAt(n - 1) == '\n') {
                string = string.substring(0, n - 1);
            }
            Debug.sendCollectedStderr();
            Debug.distributeErrorMessage("[STDERR>\n" + string);
        }
    }

    public static void setStdoutCaptureMode(boolean bl) {
        if (bl != Debug.getStdoutCaptureMode()) {
            if (bl) {
                if (!Debug.getStdoutCaptureMode()) {
                    _oldStdout = System.out;
                    System.setOut(new PrintStream(new DebuggingOutputStream(0)));
                }
            } else if (Debug.getStdoutCaptureMode()) {
                Debug.sendCollectedStdout();
                System.setOut(_oldStdout);
                _oldStdout = null;
            }
            Debug.informStdoutCaptureModeListeners(bl);
        }
    }

    public static boolean getStdoutCaptureMode() {
        return _oldStdout != null;
    }

    public static PrintStream getConsoleStdout() {
        return Debug.getStdoutCaptureMode() ? _oldStdout : System.out;
    }

    public static void setStderrCaptureMode(boolean bl) {
        if (bl != Debug.getStderrCaptureMode()) {
            if (bl) {
                if (!Debug.getStderrCaptureMode()) {
                    _oldStderr = System.err;
                    System.setErr(new PrintStream(new DebuggingOutputStream(1)));
                }
            } else if (Debug.getStderrCaptureMode()) {
                Debug.sendCollectedStderr();
                System.setErr(_oldStderr);
                _oldStderr = null;
            }
            Debug.informStderrCaptureModeListeners(bl);
        }
    }

    public static boolean getStderrCaptureMode() {
        return _oldStderr != null;
    }

    public static PrintStream getConsoleStderr() {
        return Debug.getStderrCaptureMode() ? _oldStderr : System.err;
    }

    public static void installCookedOutput(@Nullable OutputStream outputStream) {
        if (outputStream != null) {
            Debug.addCookedMessageDebugListener(new SimpleOutputtingDebugListener(outputStream));
        }
    }

    public static void installCookedOutput() {
        Debug.installCookedOutput(Debug.getConsoleStdout());
    }

    public static String getObjectInfo(@NotNull Object object) {
        return ObjectInspector.getInfo(object, false);
    }

    public static String getObjectInfoIncludingGetters(@NotNull Object object) {
        return ObjectInspector.getInfo(object, true);
    }

    public static void initFromProperties(long l, boolean bl, boolean bl2) {
        boolean bl3 = Utility.getBooleanParameter("debug.show.window", bl);
        if (_haveInitializedFromProperties) {
            if (bl3) {
                Debug.createDebugWindow();
            }
            return;
        }
        _haveInitializedFromProperties = true;
        boolean bl4 = Utility.getBooleanParameter("debug.print.console", bl2);
        if (bl3 || bl4) {
            long l2 = 0L;
            String string = Utility.getStringParameter("debug.mask", null);
            if (string != null) {
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                while (stringCharacterIterator.current() != '\uffff') {
                    char c = stringCharacterIterator.current();
                    switch (Character.toUpperCase(c)) {
                        case 'T': {
                            l2 |= 1L;
                            break;
                        }
                        case 'S': {
                            l2 |= 2L;
                            break;
                        }
                        case 'W': {
                            l2 |= 4L;
                            break;
                        }
                        case 'E': {
                            l2 |= 8L;
                            break;
                        }
                        case 'F': {
                            l2 |= 0x10L;
                            break;
                        }
                        case 'L': {
                            l2 |= 0x20L;
                            break;
                        }
                        case 'A': {
                            l2 |= 0x40L;
                            break;
                        }
                        case '1': {
                            Debug.setStdoutCaptureMode(true);
                            break;
                        }
                        case '2': {
                            Debug.setStderrCaptureMode(true);
                        }
                    }
                    stringCharacterIterator.next();
                }
            } else {
                l2 = l & 0x7FL;
            }
            Debug.setMask(l2);
            if (bl3) {
                Debug.createDebugWindow();
            }
            if (bl4) {
                Debug.installCookedOutput();
            }
        } else {
            Debug.setMask(0L);
        }
    }

    public static void initFromProperties(long l) {
        Debug.initFromProperties(l, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger connectToLogging() {
        Object object = _loggerConnectorSyncHelp;
        synchronized (object) {
            if (_loggerConnector == null) {
                _loggerConnector = new LoggerConnector();
                Debug.addAnyMessageDebugListener(_loggerConnector);
            }
        }
        return _loggerConnector.getLogger();
    }

    static {
        Debug.addAnyMessageDebugListener(_cook);
        String string = System.getProperty("debug.locale");
        stringFormatLocale = string != null ? Locale.forLanguageTag(string) : Locale.getDefault();
        DEBUG_PACKAGE = Debug.class.getPackage();
        DEBUG_PACKAGE_PREFIX = DEBUG_PACKAGE.getName() + ".";
    }

    private static class LoggerConnector
    implements AnyMessageDebugListener {
        private final Logger logger = Logger.getLogger("de.caff.util.debug");

        private LoggerConnector() {
        }

        public Logger getLogger() {
            return this.logger;
        }

        private static String format(@NotNull String string, @NotNull String string2) {
            return string + " [" + string2 + "]";
        }

        @Override
        public boolean receiveFailedAssertionMessage(@NotNull String string, @NotNull String string2) {
            this.logger.severe("Failed assertion: " + LoggerConnector.format(string, string2));
            return true;
        }

        @Override
        public void receiveErrorMessage(@NotNull String string, @NotNull String string2) {
            this.logger.warning(LoggerConnector.format(string, string2));
        }

        @Override
        public int receiveFatalMessage(@NotNull String string, @NotNull String string2) {
            this.logger.severe(LoggerConnector.format(string, string2));
            return 1;
        }

        @Override
        public void receiveLogMessage(@NotNull String string, @NotNull String string2) {
            this.logger.log(Level.INFO, LoggerConnector.format(string, string2));
        }

        @Override
        public void receiveStandardMessage(@NotNull String string, @NotNull String string2) {
            this.logger.fine(LoggerConnector.format(string, string2));
        }

        @Override
        public void receiveTraceMessage(@NotNull String string, @NotNull String string2) {
            this.logger.finest(LoggerConnector.format(string, string2));
        }

        @Override
        public void receiveWarningMessage(@NotNull String string, @NotNull String string2) {
            this.logger.warning(LoggerConnector.format(string, string2));
        }
    }

    public static interface ModeChangeListener {
        public void modeChanged(int var1, boolean var2);

        public void stdoutCaptureChanged(boolean var1);

        public void stderrCaptureChanged(boolean var1);
    }
}

