/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.concurrent;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.concurrent.Priority;
import de.caff.util.concurrent.PriorityExecutor;
import de.caff.util.concurrent.TaskLifeCycleListener;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class PriorityThreadPoolExecutor
implements PriorityExecutor {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final AtomicLong sequence = new AtomicLong(Long.MIN_VALUE);
    private final PriorityBlockingQueue<PriorityTask> queue = new PriorityBlockingQueue();

    public PriorityThreadPoolExecutor(int n, int n2, long l, @NotNull TimeUnit timeUnit) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, this.queue);
    }

    public PriorityThreadPoolExecutor(int n, int n2, long l, @NotNull TimeUnit timeUnit, @NotNull ThreadFactory threadFactory) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, this.queue, threadFactory);
    }

    public PriorityThreadPoolExecutor(int n, int n2, long l, @NotNull TimeUnit timeUnit, @NotNull RejectedExecutionHandler rejectedExecutionHandler) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, this.queue, rejectedExecutionHandler);
    }

    public PriorityThreadPoolExecutor(int n, int n2, long l, @NotNull TimeUnit timeUnit, @NotNull ThreadFactory threadFactory, @NotNull RejectedExecutionHandler rejectedExecutionHandler) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, this.queue, threadFactory, rejectedExecutionHandler);
    }

    @Override
    public long execute(@NotNull Priority priority, @Nullable Object object, @NotNull Runnable runnable) {
        long l = this.sequence.getAndIncrement();
        this.threadPoolExecutor.execute(new PriorityTask(priority, object, null, l, runnable));
        return l;
    }

    @Override
    public long executeWithLifeCycle(@NotNull Priority priority, @NotNull TaskLifeCycleListener taskLifeCycleListener, @NotNull Runnable runnable) {
        long l = this.sequence.getAndIncrement();
        this.threadPoolExecutor.execute(new PriorityTask(priority, taskLifeCycleListener, taskLifeCycleListener, l, runnable));
        return l;
    }

    @Override
    public int removeTasksWithMark(@NotNull Object object) {
        int n = 0;
        Iterator<PriorityTask> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMarked(object)) continue;
            iterator.remove();
            ++n;
        }
        return n;
    }

    @Override
    public boolean removeTaskWithId(long l) {
        Iterator<PriorityTask> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().sequenceNumber != l) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private static final class PriorityTask
    implements Comparable<PriorityTask>,
    Runnable {
        @NotNull
        private final Priority priority;
        private final long sequenceNumber;
        @NotNull
        private final Runnable task;
        @Nullable
        private final Object mark;
        @Nullable
        private final TaskLifeCycleListener listener;

        PriorityTask(@NotNull Priority priority, @Nullable Object object, @Nullable TaskLifeCycleListener taskLifeCycleListener, long l, @NotNull Runnable runnable) {
            this.priority = priority;
            this.mark = object;
            this.listener = taskLifeCycleListener;
            this.sequenceNumber = l;
            this.task = runnable;
            if (taskLifeCycleListener != null) {
                taskLifeCycleListener.taskEnqueued();
            }
        }

        boolean isMarked(@NotNull Object object) {
            return object.equals(this.mark);
        }

        @Override
        public void run() {
            if (this.listener != null) {
                this.listener.taskStarting();
                try {
                    this.task.run();
                }
                finally {
                    this.listener.taskFinished();
                }
            } else {
                this.task.run();
            }
        }

        @Override
        public int compareTo(@NotNull PriorityTask priorityTask) {
            int n = priorityTask.priority.compareTo(this.priority);
            if (n != 0) {
                return n;
            }
            return Long.compare(this.sequenceNumber, priorityTask.sequenceNumber);
        }

        public String toString() {
            return "PriorityTask{priority=" + (Object)((Object)this.priority) + ", sequenceNumber=" + this.sequenceNumber + ", mark=" + this.mark + ", task=" + this.task + '}';
        }
    }
}

