/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.concurrent;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.concurrent.Priority;
import de.caff.util.concurrent.TaskLifeCycleListener;

public interface PriorityExecutor {
    public static final long NO_ID = -1L;
    public static final int CANT_REMOVE = -1;
    public static final PriorityExecutor DIRECT_EXECUTOR = new PriorityExecutor(){

        @Override
        public long execute(@NotNull Priority priority, @Nullable Object object, @NotNull Runnable runnable) {
            runnable.run();
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeWithLifeCycle(@NotNull Priority priority, @NotNull TaskLifeCycleListener taskLifeCycleListener, @NotNull Runnable runnable) {
            taskLifeCycleListener.taskEnqueued();
            taskLifeCycleListener.taskStarting();
            try {
                runnable.run();
            }
            finally {
                taskLifeCycleListener.taskFinished();
            }
            return 0L;
        }

        @Override
        public int removeTasksWithMark(@NotNull Object object) {
            return -1;
        }

        @Override
        public boolean removeTaskWithId(long l) {
            return false;
        }
    };

    public long execute(@NotNull Priority var1, @Nullable Object var2, @NotNull Runnable var3);

    public long executeWithLifeCycle(@NotNull Priority var1, @NotNull TaskLifeCycleListener var2, @NotNull Runnable var3);

    public int removeTasksWithMark(@NotNull Object var1);

    public boolean removeTaskWithId(long var1);
}

