/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.concurrent;

import de.caff.annotation.NotNull;

public enum Priority {
    Lowest,
    Lower,
    Low,
    MediumLow,
    Medium,
    MediumHigh,
    High,
    Higher,
    Highest;

    private static final Priority[] VALUES;

    @NotNull
    public Priority increase() {
        return Priority.increased(this);
    }

    @NotNull
    public Priority decrease() {
        return Priority.decreased(this);
    }

    @NotNull
    public static Priority increased(@NotNull Priority priority) {
        int n = priority.ordinal() + 1;
        if (n > VALUES.length) {
            return priority;
        }
        return VALUES[n];
    }

    @NotNull
    public static Priority decreased(@NotNull Priority priority) {
        int n = priority.ordinal() - 1;
        if (n < 0) {
            return priority;
        }
        return VALUES[n];
    }

    static {
        VALUES = Priority.values();
    }
}

