/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.concurrent;

import de.caff.annotation.NotNull;
import de.caff.generics.OrderedPair;
import de.caff.generics.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public class ParallelSort {
    public static <T extends Comparable<T>> void sort(@NotNull List<T> list, @NotNull ThreadPoolExecutor threadPoolExecutor, int n) throws ExecutionException, InterruptedException {
        ParallelSort.sort(list, threadPoolExecutor, threadPoolExecutor.getMaximumPoolSize(), n);
    }

    public static <T extends Comparable<T>> void sort(@NotNull List<T> list, @NotNull ThreadPoolExecutor threadPoolExecutor, int n, int n2) throws ExecutionException, InterruptedException {
        ParallelSort.sort(list, Types.naturalOrder(), threadPoolExecutor, n, n2);
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator, @NotNull ThreadPoolExecutor threadPoolExecutor, int n) throws ExecutionException, InterruptedException {
        ParallelSort.sort(list, comparator, threadPoolExecutor, threadPoolExecutor.getMaximumPoolSize(), n);
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator, @NotNull ThreadPoolExecutor threadPoolExecutor, int n, int n2) throws ExecutionException, InterruptedException {
        int n3 = list.size();
        if (n3 < 2 * n2) {
            Collections.sort(list, comparator);
            return;
        }
        if (n3 / n > n2) {
            ParallelSort.doSort(list, comparator, threadPoolExecutor, n3 / n);
        } else {
            ParallelSort.doSort(list, comparator, threadPoolExecutor, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> void doSort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator, @NotNull ThreadPoolExecutor threadPoolExecutor, int n) throws ExecutionException, InterruptedException {
        int n2 = list.size() / n;
        ArrayList<Future<List>> arrayList = new ArrayList<Future<List>>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            arrayList.add(threadPoolExecutor.submit(() -> {
                Object[] objectArray = list.subList(n3, Math.min(list.size(), n3 + n)).toArray();
                Arrays.sort(objectArray, comparator);
                return Types.asList((Object[])objectArray);
            }));
        }
        ArrayList<OrderedPair> arrayList2 = new ArrayList<OrderedPair>(n2);
        for (Future future2 : arrayList) {
            Iterator iterator = ((List)future2.get()).iterator();
            arrayList2.add(OrderedPair.create(iterator.next(), iterator));
        }
        Iterator<Object> iterator = list.listIterator();
        while (arrayList2.size() > 1) {
            void var8_13;
            Object var8_12 = null;
            for (OrderedPair orderedPair : arrayList2) {
                if (var8_13 == null) {
                    OrderedPair orderedPair2 = orderedPair;
                    continue;
                }
                if (comparator.compare(orderedPair.first, var8_13.first) >= 0) continue;
                OrderedPair orderedPair3 = orderedPair;
            }
            assert (var8_13 != null);
            iterator.next();
            iterator.set(var8_13.first);
            if (((Iterator)var8_13.second).hasNext()) {
                var8_13.first = ((Iterator)var8_13.second).next();
                continue;
            }
            arrayList2.remove(var8_13);
        }
        OrderedPair orderedPair = (OrderedPair)arrayList2.get(0);
        iterator.next();
        iterator.set(orderedPair.first);
        while (((Iterator)orderedPair.second).hasNext()) {
            iterator.next();
            iterator.set(((Iterator)orderedPair.second).next());
        }
    }
}

