/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.concurrent;

import de.caff.annotation.NotNull;
import de.caff.util.Utility;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class Exec {
    public static final int DEFAULT_MAX_THREADS = Math.max(1, Utility.getIntParameter("caff.exec.maxthreads", Integer.MAX_VALUE));
    public static final double DEFAULT_WAIT_TO_COMPUTE_RATIO = 0.1;
    public static final double DEFAULT_CPU_UTILIZATION_FACTOR = 0.95;

    private Exec() {
    }

    public static int calcNumThreads(double d, double d2, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("cpuUtilizationFactor has to be between 0.0 (no CPU usage) and 1.0 (exclusive CPU usage), but is " + d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("waitToComputeRatio has to be between 0.0 (no waiting, only computing) and 1.0 (no computing, only waiting), but is " + d2);
        }
        if (n < 1) {
            throw new IllegalArgumentException("maxThreads has to be at least 1 (although that does not make much sense), but is " + n);
        }
        int n2 = Runtime.getRuntime().availableProcessors();
        return Math.min(n, Math.max(1, (int)Math.round((double)n2 * d * (1.0 + d2))));
    }

    @NotNull
    public static ThreadPoolExecutor createDefaultExecutor(double d, double d2, int n) {
        int n2 = Exec.calcNumThreads(d, d2, n);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>());
        threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        return threadPoolExecutor;
    }

    @NotNull
    public static ThreadPoolExecutor createDefaultExecutor(int n) {
        return Exec.createDefaultExecutor(0.95, 0.1, n);
    }

    @NotNull
    public static ThreadPoolExecutor createDefaultExecutor() {
        return Exec.createDefaultExecutor(DEFAULT_MAX_THREADS);
    }

    @NotNull
    public static ThreadPoolExecutor createDefaultExecutor(@NotNull String string, double d, double d2, int n) {
        int n2 = Exec.calcNumThreads(d, d2, n);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(), Exec.defaultNamedThreadFactory(string));
        threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        return threadPoolExecutor;
    }

    @NotNull
    public static ThreadFactory defaultNamedThreadFactory(@NotNull String string) {
        return new DefaultThreadFactory(string);
    }

    @NotNull
    public static ThreadFactory privilegedNamedThreadFactory(@NotNull String string) {
        return new PrivilegedThreadFactory(string);
    }

    @NotNull
    public static ThreadFactory privilegedNamedThreadFactory(@NotNull String string, @NotNull ClassLoader classLoader) {
        return new PrivilegedThreadFactory(string, classLoader);
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final AccessControlContext accessControlContext;
        private final ClassLoader classLoader;

        public PrivilegedThreadFactory(@NotNull String string) {
            super(string);
            this.accessControlContext = AccessController.getContext();
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }

        public PrivilegedThreadFactory(@NotNull String string, @NotNull ClassLoader classLoader) {
            super(string);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
            }
            this.accessControlContext = AccessController.getContext();
            this.classLoader = classLoader;
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable runnable) {
            return super.newThread(() -> AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                runnable.run();
                return null;
            }, this.accessControlContext));
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        @NotNull
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        @NotNull
        private final ThreadGroup threadGroup;
        @NotNull
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        @NotNull
        private final String namePrefix;

        DefaultThreadFactory(@NotNull String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread = new Thread(this.threadGroup, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    public static class FinishingThreadPoolExecutor
    implements ExecutorService {
        @NotNull
        private final ThreadPoolExecutor executor;
        @NotNull
        private final Deque<Future<?>> queue = new ConcurrentLinkedDeque();

        public FinishingThreadPoolExecutor(@NotNull ThreadPoolExecutor threadPoolExecutor) {
            this.executor = threadPoolExecutor;
        }

        @Override
        public void execute(@NotNull Runnable runnable) {
            this.submit(runnable);
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long l, @NotNull TimeUnit timeUnit) throws InterruptedException {
            return this.executor.awaitTermination(l, timeUnit);
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable runnable) {
            Future<?> future = this.executor.submit(runnable);
            this.queue.add(future);
            return future;
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> callable) {
            Future<T> future = this.executor.submit(callable);
            this.queue.add(future);
            return future;
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable runnable, T t) {
            Future<T> future = this.executor.submit(runnable, t);
            this.queue.add(future);
            return future;
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> collection) throws InterruptedException {
            List list = this.executor.invokeAll(collection);
            this.queue.addAll(list);
            return list;
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> collection, long l, @NotNull TimeUnit timeUnit) throws InterruptedException {
            List list = this.executor.invokeAll(collection, l, timeUnit);
            this.queue.addAll(list);
            return list;
        }

        @Override
        @NotNull
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
            return this.executor.invokeAny(collection);
        }

        @Override
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> collection, long l, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.executor.invokeAny(collection, l, timeUnit);
        }

        public void waitUntilFinished() throws ExecutionException, InterruptedException {
            while (!this.queue.isEmpty()) {
                this.queue.removeFirst().get();
            }
        }
    }
}

