/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.args;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.util.args.AbstractMultipleSwitch;
import java.util.Collection;
import java.util.LinkedList;

public class StringArgMultipleSwitch
extends AbstractMultipleSwitch {
    private final String argName;
    @NotNull
    private final Collection<String> parameters = new LinkedList<String>();

    public StringArgMultipleSwitch(@NotNull Character c, @NotNull String string, @NotNull String string2, @NotNull String string3, int n) {
        this(c, string, string2, string3, n, Integer.MAX_VALUE);
    }

    public StringArgMultipleSwitch(@NotNull Character c, @NotNull String string, @NotNull String string2, @NotNull String string3, int n, int n2) {
        super(c, string, string3, n, n2);
        this.argName = string2;
    }

    @Override
    public boolean isVarLength() {
        return false;
    }

    @Override
    public boolean needsArguments() {
        return true;
    }

    @Override
    public boolean consumeArgument(@NotNull String string) {
        this.parameters.add(string);
        return false;
    }

    @Override
    public void found(char c) {
    }

    @Override
    public void found(@NotNull String string) {
    }

    @Override
    @NotNull
    public String getAppearance() {
        String string = String.format("-%s\u00a0<%s>|--%s=<%s>", this.shortForm, this.argName, this.longForm, this.argName);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.minCount; ++i) {
            stringBuilder.append(string);
        }
        stringBuilder.append("[").append(string).append("]*");
        return stringBuilder.toString();
    }

    @NotNull
    public Indexable<String> getParameters() {
        return Indexable.fromCollection(this.parameters);
    }
}

