/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.args;

import de.caff.annotation.NotNull;
import de.caff.generics.Types;
import de.caff.util.args.AbstractSwitch;
import de.caff.util.args.Switch;
import java.util.Collection;
import java.util.Collections;

public class SimpleOnOffSwitch
extends AbstractSwitch {
    public static final String LONG_PREFIX_WITH = "with-";
    public static final String LONG_PREFIX_WITHOUT = "without-";
    public static final String LONG_PREFIX_NO = "no-";
    @NotNull
    private final Character shortOff;
    @NotNull
    private final String longOff;
    private boolean value;

    public SimpleOnOffSwitch(@NotNull Character c, @NotNull String string, boolean bl, @NotNull String string2) {
        super(c, string, string2);
        if (Character.isLowerCase(c.charValue())) {
            this.shortOff = Character.valueOf(Character.toUpperCase(c.charValue()));
        } else if (Character.isUpperCase(c.charValue())) {
            this.shortOff = Character.valueOf(Character.toLowerCase(c.charValue()));
        } else {
            throw new IllegalArgumentException("Character '" + c + "' does not have a case!");
        }
        if (this.shortOff.equals(this.shortForm)) {
            throw new IllegalArgumentException("Character '" + c + "' is the same in upper and lower case!");
        }
        this.longOff = string.startsWith(LONG_PREFIX_WITH) ? LONG_PREFIX_WITHOUT + string.substring(LONG_PREFIX_WITH.length()) : LONG_PREFIX_NO + string;
        this.value = bl;
    }

    @NotNull
    private static Switch view(final @NotNull Switch switch_, final @NotNull Character c, final @NotNull String string, final @NotNull String string2) {
        return new Switch(){

            @Override
            @NotNull
            public Collection<Character> getShortForms() {
                return Collections.singleton(c);
            }

            @Override
            @NotNull
            public Collection<String> getLongForms() {
                return Collections.singleton(string);
            }

            @Override
            public boolean isVarLength() {
                return false;
            }

            @Override
            public void found(char c2) {
                switch_.found(c2);
            }

            @Override
            public void found(@NotNull String string3) {
                switch_.found(string3);
            }

            @Override
            @NotNull
            public String getAppearance() {
                return String.format("-%s|--%s", c, string);
            }

            @Override
            @NotNull
            public String getDescription() {
                return string2;
            }
        };
    }

    @Override
    public boolean isVarLength() {
        return false;
    }

    @NotNull
    public Switch viewOn(@NotNull String string) {
        return SimpleOnOffSwitch.view(this, this.shortForm, this.longForm, string);
    }

    @NotNull
    public Switch viewOff(@NotNull String string) {
        return SimpleOnOffSwitch.view(this, this.shortOff, this.longOff, string);
    }

    @Override
    @NotNull
    public Collection<Character> getShortForms() {
        return Types.asList((Object[])new Character[]{this.shortForm, this.shortOff});
    }

    @Override
    @NotNull
    public Collection<String> getLongForms() {
        return Types.asList((Object[])new String[]{this.longForm, this.longOff});
    }

    @Override
    @NotNull
    public String getAppearance() {
        return String.format("-%s|-%s|--%s|--%s", this.shortForm, this.shortOff, this.longForm, this.longOff);
    }

    @Override
    public void found(char c) {
        this.value = c == this.shortForm.charValue();
    }

    @Override
    public void found(@NotNull String string) {
        this.value = string.equals(this.longForm);
    }

    public boolean isSwitchedOn() {
        return this.value;
    }
}

