/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.args;

import de.caff.annotation.NotNull;
import de.caff.generics.Pair;
import de.caff.generics.Types;
import de.caff.util.Utility;
import de.caff.util.args.Argument;
import de.caff.util.args.MissingSwitchArgumentException;
import de.caff.util.args.Switch;
import de.caff.util.args.SwitchOrArgument;
import de.caff.util.args.TooManyArgumentsException;
import de.caff.util.args.UnexpectedArgumentException;
import de.caff.util.args.UnknownSwitchException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommandLine {
    private static final boolean DEBUG = Utility.getBooleanParameter("cmdline.debug", false);
    public static final String PREFIX_SHORT = "-";
    public static final String PREFIX_LONG = "--";
    public static final String LONG_ARG_SEP = "=";
    public static final char NON_BREAKING_SPACE = '\u00a0';
    @NotNull
    private final Map<Character, Switch> shortForms = new HashMap<Character, Switch>();
    @NotNull
    private final Map<String, Switch> longForms = new HashMap<String, Switch>();
    @NotNull
    private final List<Argument> arguments = new LinkedList<Argument>();
    @NotNull
    private final String line;
    @NotNull
    private final List<Pair<String>> descriptions = new LinkedList<Pair<String>>();

    public CommandLine(SwitchOrArgument ... switchOrArgumentArray) {
        this(Types.asList((Object[])switchOrArgumentArray));
    }

    public CommandLine(@NotNull Iterable<SwitchOrArgument> iterable) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (SwitchOrArgument switchOrArgument : iterable) {
            SwitchOrArgument switchOrArgument2;
            if (bl2) {
                throw new IllegalArgumentException("There is only one var-arg argument or switch allowed, and it has to appear as last item!");
            }
            bl2 = switchOrArgument.isVarLength();
            if (switchOrArgument.isSwitch()) {
                Switch switch_;
                switchOrArgument2 = (Switch)switchOrArgument;
                for (Character c : switchOrArgument2.getShortForms()) {
                    switch_ = this.shortForms.get(c);
                    if (switch_ != null) {
                        throw new IllegalArgumentException(String.format("Duplicate usage of short switch '%s%s'!", PREFIX_SHORT, c));
                    }
                    this.shortForms.put(c, (Switch)switchOrArgument2);
                }
                for (String string : switchOrArgument2.getLongForms()) {
                    CommandLine.checkLongForm(string);
                    switch_ = this.longForms.get(string);
                    if (switch_ != null) {
                        throw new IllegalArgumentException(String.format("Duplicate usage of long switch '%s%s'!", PREFIX_LONG, string));
                    }
                    this.longForms.put(string, (Switch)switchOrArgument2);
                }
                stringBuilder.append(CommandLine.forCommandLine(switchOrArgument2));
            } else {
                switchOrArgument2 = (Argument)switchOrArgument;
                if (switchOrArgument2.getMinimalCount() < 0) {
                    throw new IllegalArgumentException(String.format("Invalid minimal count %d for argument %s!", switchOrArgument2.getMinimalCount(), switchOrArgument2.getAppearance()));
                }
                if (switchOrArgument2.getMaximalCount() <= 0) {
                    throw new IllegalArgumentException(String.format("Invalid maximal count %d for argument %s!", switchOrArgument2.getMaximalCount(), switchOrArgument2.getAppearance()));
                }
                if (switchOrArgument2.isOptional()) {
                    bl = true;
                } else if (bl) {
                    throw new IllegalArgumentException(String.format("Optional arguments followed by non-optional argument %s is not supported!", switchOrArgument2.getAppearance()));
                }
                stringBuilder.append(CommandLine.forCommandLine(switchOrArgument2));
                this.arguments.add((Argument)switchOrArgument2);
            }
            stringBuilder.append(' ');
            this.descriptions.add((Pair<String>)Pair.createPair((Object)switchOrArgument.getAppearance(), (Object)switchOrArgument.getDescription()));
        }
        this.line = stringBuilder.toString();
    }

    @NotNull
    private static String forCommandLine(@NotNull SwitchOrArgument switchOrArgument) {
        String string = switchOrArgument.getAppearance();
        if (!switchOrArgument.isSwitch()) {
            int n = ((Argument)switchOrArgument).getMaximalCount();
            if (n > 3) {
                string = string + "...";
            } else {
                while (--n > 1) {
                    string = string + " " + switchOrArgument.getAppearance();
                }
            }
        }
        if (switchOrArgument.isOptional()) {
            string = "[" + string + "]";
        }
        return string;
    }

    public void evaluate(@NotNull String[] stringArray) throws UnknownSwitchException, UnexpectedArgumentException, TooManyArgumentsException, MissingSwitchArgumentException {
        this.evaluate(new LinkedList<String>(Types.asList((Object[])stringArray)));
    }

    public void evaluate(@NotNull List<String> list) throws UnknownSwitchException, UnexpectedArgumentException, TooManyArgumentsException, MissingSwitchArgumentException {
        boolean bl = false;
        Iterator<Argument> iterator = this.arguments.iterator();
        block0: while (!list.isEmpty()) {
            String string;
            Object object;
            String string2 = list.remove(0);
            if (bl) continue;
            if (string2.startsWith(PREFIX_LONG)) {
                Switch switch_;
                if (string2.equals(PREFIX_LONG)) {
                    if (DEBUG) {
                        System.out.println("CMD: <no-more-switches>");
                    }
                    bl = true;
                    continue;
                }
                object = string2.substring(2);
                string = null;
                int n = ((String)object).indexOf(LONG_ARG_SEP);
                if (n > 0) {
                    string = ((String)object).substring(n + 1);
                    object = ((String)object).substring(0, n);
                }
                if ((switch_ = this.longForms.get(object)) == null) {
                    throw new UnknownSwitchException(PREFIX_LONG + (String)object);
                }
                if (DEBUG) {
                    System.out.println("Long switch: --" + (String)object);
                }
                switch_.found((String)object);
                if (string != null) {
                    if (!switch_.needsArguments()) {
                        throw new UnexpectedArgumentException(PREFIX_LONG + (String)object, string);
                    }
                    list.add(0, string);
                }
                if (!switch_.needsArguments()) continue;
                while (!list.isEmpty() && switch_.consumeArgument(list.remove(0))) {
                }
                continue;
            }
            if (string2.startsWith(PREFIX_SHORT)) {
                object = string2.substring(1);
                if (((String)object).isEmpty()) {
                    throw new UnknownSwitchException(PREFIX_SHORT);
                }
                while (!((String)object).isEmpty()) {
                    char c = ((String)object).charAt(0);
                    object = ((String)object).substring(1);
                    Switch switch_ = this.shortForms.get(Character.valueOf(c));
                    if (switch_ == null) {
                        throw new UnknownSwitchException(PREFIX_SHORT + c);
                    }
                    if (DEBUG) {
                        System.out.print("CMD: Short switch: -" + c);
                    }
                    switch_.found(c);
                    if (switch_.needsArguments()) {
                        if (list.isEmpty()) {
                            throw new MissingSwitchArgumentException((String)object);
                        }
                        string2 = list.remove(0);
                        if (DEBUG) {
                            System.out.print(" " + string2);
                        }
                        while (switch_.consumeArgument(string2) && !list.isEmpty()) {
                            string2 = list.remove(0);
                            if (!DEBUG) continue;
                            System.out.print(" " + string2);
                        }
                    }
                    if (!DEBUG) continue;
                    System.out.println();
                }
                continue;
            }
            if (!iterator.hasNext()) {
                throw new TooManyArgumentsException(string2, list);
            }
            object = iterator.next();
            if (!object.consumeArgument(string2)) continue;
            while (!list.isEmpty()) {
                string = list.remove(0);
                if (DEBUG) {
                    System.out.println("CMD: Argument: " + string);
                }
                if (object.consumeArgument(string)) continue;
                continue block0;
            }
        }
    }

    public static void checkLongForm(@NotNull String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty long form not allowed!");
        }
        for (char c : string.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '-') continue;
            throw new IllegalArgumentException("Illegal character '" + c + "' in long form!");
        }
    }

    @NotNull
    private static String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        while (n-- > 0) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    @NotNull
    private static Pair<String> splitBefore(@NotNull String string, int n) {
        for (int i = n; i >= 0; --i) {
            char c = string.charAt(i);
            if (!Character.isSpaceChar(c) || c == '\u00a0') continue;
            return Pair.createPair((Object)string.substring(0, i), (Object)string.substring(i + 1));
        }
        return Pair.createPair((Object)string.substring(0, n), (Object)string.substring(n));
    }

    @NotNull
    public String getUsage(int n, int n2) {
        int n3 = n - n2;
        int n4 = n3 - n2;
        String string = CommandLine.spaces(n2);
        String string2 = string + string;
        StringBuilder stringBuilder = new StringBuilder("Command Line:\n");
        String string3 = this.line;
        if (string3.length() > n) {
            Object object = CommandLine.splitBefore(string3, n);
            stringBuilder.append((String)((Pair)object).first).append('\n');
            string3 = (String)((Pair)object).second;
            while (string3.length() > n3) {
                object = CommandLine.splitBefore(string3, n3);
                stringBuilder.append(string).append((String)((Pair)object).first).append('\n');
                string3 = (String)((Pair)object).second;
            }
            if (!string3.isEmpty()) {
                stringBuilder.append(string).append(string3).append('\n');
            }
        }
        stringBuilder.append("\nSwitches and Arguments:");
        for (Pair pair : this.descriptions) {
            stringBuilder.append('\n');
            stringBuilder.append(string).append((String)pair.first).append('\n');
            for (String string4 : ((String)pair.second).split("\n")) {
                while (string4.length() > n4) {
                    Pair<String> pair2 = CommandLine.splitBefore(string4, n4);
                    stringBuilder.append(string2).append((String)pair2.first).append('\n');
                    string4 = (String)pair2.second;
                }
                stringBuilder.append(string2).append(string4).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void printUsageAndExit(@NotNull PrintStream printStream, int n) {
        printStream.print(this.getUsage(80, 4));
        System.exit(n);
    }

    public void printUsageAndExit(int n) {
        this.printUsageAndExit(System.out, n);
    }
}

