/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.KnockOffListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class Worker
implements Runnable {
    private static final ThreadGroup WORKER_THREAD_GROUP = new ThreadGroup("de.caff.util.Worker"){};
    private Throwable catched;
    private final List<KnockOffListener> knockOffListeners = new LinkedList<KnockOffListener>();
    private boolean stopped = false;

    public Worker() {
    }

    public Worker(@NotNull KnockOffListener knockOffListener) {
        this.addKnockOffListener(knockOffListener);
    }

    @Override
    public synchronized void run() {
        try {
            this.execute();
        }
        catch (Throwable throwable) {
            this.catched = throwable;
        }
        finally {
            this.informKnockOffListeners();
        }
    }

    protected abstract void execute() throws Throwable;

    @Nullable
    public Throwable getCaughtThrowable() {
        return this.catched;
    }

    public void rethrow() throws Throwable {
        if (this.catched != null) {
            throw this.catched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnockOffListener(@NotNull KnockOffListener knockOffListener) {
        List<KnockOffListener> list = this.knockOffListeners;
        synchronized (list) {
            this.knockOffListeners.add(knockOffListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKnockOffListener(@NotNull KnockOffListener knockOffListener) {
        List<KnockOffListener> list = this.knockOffListeners;
        synchronized (list) {
            this.knockOffListeners.remove(knockOffListener);
        }
    }

    protected void informKnockOffListeners() {
        Worker.invokeInEventDispatchThread(() -> {
            ArrayList<KnockOffListener> arrayList;
            List<KnockOffListener> list = this.knockOffListeners;
            synchronized (list) {
                arrayList = new ArrayList<KnockOffListener>(this.knockOffListeners);
            }
            for (KnockOffListener knockOffListener : arrayList) {
                knockOffListener.knockedOff(this);
            }
        });
    }

    public void stop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) {
        Object object;
        if (bl) {
            object = this.knockOffListeners;
            synchronized (object) {
                this.knockOffListeners.clear();
            }
        }
        object = this;
        synchronized (object) {
            this.stopped = true;
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public static void invokeInEventDispatchThread(@NotNull Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

