/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Dict;
import de.caff.generics.Empty;
import de.caff.generics.Pair;
import de.caff.generics.Types;
import de.caff.generics.function.Function1;
import de.caff.util.ColorDecoder;
import de.caff.util.EventQueueExceptionListener;
import de.caff.util.EventQueueExceptionWrapper;
import de.caff.util.ModuleVersion;
import de.caff.util.ParameterTypes;
import de.caff.util.debug.Debug;
import de.caff.util.measure.IllegalPhysicalLengthFormatException;
import de.caff.util.measure.PhysicalLength;
import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;

public final class Utility {
    public static final String RELEASE_DATE = ModuleVersion.getReleaseDate();
    public static final float PHYS_RED_SCALE = 0.3f;
    public static final float PHYS_GREEN_SCALE = 0.53f;
    public static final float PHYS_BLUE_SCALE = 0.17000002f;
    public static final ImageObserver NULL_OBSERVER = (image, n, n2, n3, n4, n5) -> (n & 0xA0) == 0;
    public static final String DEFAULT_RESOURCE_PATH = "de.caff.gimmicks.resources.IconConstants|/de/caff/gimmicks/resources/";
    public static final String BUILT_DATE = Utility.getBuildDate("???");
    private static final Component preparer = new Canvas();
    private static final boolean weAreOnWindows = File.separatorChar == '\\';
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static String resourceDir = "de.caff.gimmicks.resources.IconConstants|/de/caff/gimmicks/resources/";
    private static EventQueueExceptionWrapper exceptionWrapper = null;
    @NotNull
    private static ClassLoader extensionClassLoader = Utility.class.getClassLoader();
    @NotNull
    private static final ConcurrentMap<String, ParameterTypes> requestedParameters = new ConcurrentHashMap<String, ParameterTypes>();
    @NotNull
    public static final Comparator<String> CASE_IGNORING_STRING_COMPARATOR = String::compareToIgnoreCase;
    private static boolean debugging = false;
    private static final String[] FALLBACK_PROPERTIES = new String[]{"file.encoding", "file.encoding.pkg", "file.separator", "java.awt.graphicsenv", "java.awt.printerjob", "java.class.path", "java.class.version", "java.endorsed.dirs", "java.ext.dirs", "java.home", "java.io.tmpdir", "java.library.path", "java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.url", "java.vendor.url.bug", "java.version", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version", "os.arch", "os.name", "os.version", "path.separator", "sun.arch.data.model", "sun.boot.class.path", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level", "user.country", "user.dir", "user.home", "user.language", "user.name", "user.timezone"};
    private static final String SPACES = "                                                                ";

    public static void setDebug(boolean bl) {
        debugging = bl;
    }

    public static boolean isDebug() {
        return debugging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ClassLoader getExtensionClassLoader() {
        Component component = preparer;
        synchronized (component) {
            return extensionClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateExtensionClassLoader(@NotNull Function1<ClassLoader, ClassLoader> function1) {
        Component component = preparer;
        synchronized (component) {
            ClassLoader classLoader = (ClassLoader)function1.apply((Object)extensionClassLoader);
            if (classLoader == null) {
                throw new IllegalArgumentException("updater returns null although it is not allowed to do so!");
            }
            extensionClassLoader = classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addToSystemClassLoader(URL ... uRLArray) {
        if (uRLArray.length == 0) {
            return true;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        try {
            method.setAccessible(true);
            for (URL uRL : Utility.expandLinkedJars(uRLArray)) {
                method.invoke((Object)uRLClassLoader, uRL);
            }
            boolean bl = true;
            method.setAccessible(false);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                method.setAccessible(false);
                throw throwable;
            }
            catch (Throwable throwable2) {
                Debug.error(throwable2);
                return false;
            }
        }
    }

    public static void setExtensionClassLoadUrls(URL ... uRLArray) {
        if (uRLArray.length == 0) {
            return;
        }
        Set<URL> set = Utility.expandLinkedJars(uRLArray);
        Debug.message("Added URLs: %0", set);
        Utility.updateExtensionClassLoader((Function1<ClassLoader, ClassLoader>)((Function1)classLoader -> URLClassLoader.newInstance(set.toArray(EMPTY_URL_ARRAY), classLoader)));
    }

    @NotNull
    private static Set<URL> expandLinkedJars(@NotNull URL[] uRLArray) {
        HashSet<URL> hashSet = new HashSet<URL>(Types.asList((Object[])uRLArray));
        for (URL uRL : new ArrayList(hashSet)) {
            if (!uRL.getFile().toLowerCase().endsWith(".jar")) continue;
            Debug.message("Checking %0 with protocol %1", uRL, uRL.getProtocol());
            if (!"file".equals(uRL.getProtocol())) continue;
            try {
                File file = new File(uRL.getPath());
                File file2 = file.getParentFile();
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                String string = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                Debug.message("linkedPaths=%0", string);
                if (string == null || string.isEmpty()) continue;
                for (String string2 : string.split(" ")) {
                    String[] stringArray = string2.split("/");
                    File file3 = file2;
                    for (String string3 : stringArray) {
                        file3 = new File(file3, string3);
                    }
                    Debug.message("linked=%0", file3);
                    if (!file3.exists()) continue;
                    Debug.message("Adding linked JAR %0 to extension classes.", file3);
                    hashSet.add(file3.toURI().toURL());
                }
            }
            catch (IOException iOException) {
                Debug.error(iOException);
            }
        }
        return hashSet;
    }

    @Nullable
    public static Image loadImage(@NotNull String string) {
        return Utility.loadImage(string, preparer);
    }

    @Nullable
    public static Image loadImage(@NotNull String string, @Nullable ImageObserver imageObserver) {
        return Utility.loadImage(string, preparer, imageObserver);
    }

    @Nullable
    public static Image loadImage(@NotNull String string, @NotNull Component component) {
        return Utility.loadImage(string, component, null);
    }

    @Nullable
    public static Image loadImage(@NotNull String string, @NotNull Component component, @Nullable ImageObserver imageObserver) {
        if (resourceDir != null && string.indexOf(124) < 0 && !string.startsWith("/")) {
            string = resourceDir + string;
        }
        return Utility.loadAnImage(string, component, imageObserver);
    }

    @Deprecated
    @NotNull
    public static String getStackDump(@NotNull Throwable throwable) {
        return Debug.getStackDump(throwable);
    }

    @Deprecated
    @NotNull
    public static String getErrorMessage(@NotNull Throwable throwable) {
        return Debug.getErrorMessage(throwable);
    }

    @Nullable
    private static Image loadAnImage(@NotNull String string, @NotNull Component component, @Nullable ImageObserver imageObserver) {
        Image image = null;
        try {
            URL uRL = Utility.openResourceViaClass(string);
            if (uRL == null) {
                return null;
            }
            image = Toolkit.getDefaultToolkit().createImage(uRL);
        }
        catch (Exception exception) {
            Utility.debug(exception);
        }
        if (image != null) {
            component.prepareImage(image, imageObserver);
        } else {
            Debug.error("Failed to load image %0!", string);
        }
        return image;
    }

    @NotNull
    public static String loadText(@NotNull String string) {
        if (resourceDir != null && !string.startsWith("/")) {
            string = resourceDir + string;
        }
        return Utility.loadAText(string);
    }

    @NotNull
    private static String loadAText(@NotNull String string) {
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Utility.class.getResourceAsStream(string), StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder(65536);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3).append('\n');
            }
            string2 = stringBuilder.toString();
            bufferedReader.close();
        }
        catch (Exception exception) {
            Utility.debug(exception);
        }
        return string2;
    }

    @Deprecated
    public static boolean areWeOnDOS() {
        return weAreOnWindows;
    }

    public static boolean areWeOnWindows() {
        return weAreOnWindows;
    }

    public static void setResourceDir(@Nullable String string) {
        resourceDir = string;
    }

    @NotNull
    public static String compileString(@NotNull String string, @NotNull Object[] objectArray, @NotNull ResourceBundle resourceBundle) {
        String string2 = resourceBundle.getString(string);
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '%' || c == '@') {
                int n = -1;
                if (i < string2.length() - 1) {
                    switch (string2.charAt(i + 1)) {
                        case '%': {
                            if (c != '%') break;
                            stringBuilder.append('%');
                            ++i;
                            break;
                        }
                        case '@': {
                            if (c != '@') break;
                            stringBuilder.append("@");
                            ++i;
                            break;
                        }
                        case '0': {
                            n = 0;
                            break;
                        }
                        case '1': {
                            n = 1;
                            break;
                        }
                        case '2': {
                            n = 2;
                            break;
                        }
                        case '3': {
                            n = 3;
                            break;
                        }
                        case '4': {
                            n = 4;
                            break;
                        }
                        case '5': {
                            n = 5;
                            break;
                        }
                        case '6': {
                            n = 6;
                            break;
                        }
                        case '7': {
                            n = 7;
                            break;
                        }
                        case '8': {
                            n = 8;
                            break;
                        }
                        case '9': {
                            n = 9;
                            break;
                        }
                    }
                }
                if (n < 0 || n >= objectArray.length) continue;
                if (c == '%') {
                    stringBuilder.append(objectArray[n]);
                } else {
                    stringBuilder.append(resourceBundle.getString(objectArray[n].toString()));
                }
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String compileString(@NotNull String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                int n = -1;
                if (i < string.length() - 1) {
                    switch (string.charAt(i + 1)) {
                        case '%': {
                            if (c != '%') break;
                            stringBuilder.append('%');
                            ++i;
                            break;
                        }
                        case '0': {
                            n = 0;
                            break;
                        }
                        case '1': {
                            n = 1;
                            break;
                        }
                        case '2': {
                            n = 2;
                            break;
                        }
                        case '3': {
                            n = 3;
                            break;
                        }
                        case '4': {
                            n = 4;
                            break;
                        }
                        case '5': {
                            n = 5;
                            break;
                        }
                        case '6': {
                            n = 6;
                            break;
                        }
                        case '7': {
                            n = 7;
                            break;
                        }
                        case '8': {
                            n = 8;
                            break;
                        }
                        case '9': {
                            n = 9;
                            break;
                        }
                    }
                }
                if (n < 0 || n >= objectArray.length) continue;
                stringBuilder.append(objectArray[n]);
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return new String(stringBuilder);
    }

    @NotNull
    public static Frame getFrame(@Nullable Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return new Frame();
    }

    public static boolean equalBytes(@NotNull byte[] byArray, int n, @NotNull byte[] byArray2, int n2, int n3) {
        while (n3-- > 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public static boolean getBooleanParameter(@NotNull String string, boolean bl) {
        return Utility.getBooleanParameter(string, bl, "true");
    }

    public static boolean getBooleanParameter(@NotNull String string, boolean bl, String ... stringArray) {
        String string2 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.Bool);
        if (string2 != null) {
            for (String string3 : stringArray) {
                if (!string2.equalsIgnoreCase(string3)) continue;
                return true;
            }
            return false;
        }
        return bl;
    }

    @NotNull
    public static <T extends Enum<?>> T getEnumParameter(@NotNull String string, @NotNull T t) {
        Enum[] enumArray;
        String string2 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.Enum);
        if (string2 != null && (enumArray = (Enum[])t.getClass().getEnumConstants()) != null) {
            for (Enum enum_ : enumArray) {
                if (!string2.equalsIgnoreCase(enum_.name())) continue;
                return (T)enum_;
            }
        }
        return t;
    }

    @Nullable
    private static String getParameter(@NotNull String string) {
        try {
            String string2 = System.getProperty(string);
            if (Debug.getTraceMode()) {
                Debug.trace("getParameter(\"%0\")=%1", string, string2);
            }
            return string2;
        }
        catch (Exception exception) {
            Utility.debug(exception);
            return null;
        }
    }

    public static String getStringParameter(@NotNull String string, @Nullable String string2) {
        String string3 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.String);
        return string3 != null ? string3 : string2;
    }

    @NotNull
    private static String formatString(@Nullable String string) {
        return string != null ? String.format("\"%s\"", string) : "<null>";
    }

    @Nullable
    public static Color getColorParameter(@NotNull String string, @Nullable Color color) {
        requestedParameters.put(string, ParameterTypes.Color);
        String string2 = Utility.getParameter(string);
        if (string2 != null) {
            try {
                return ColorDecoder.decode(string2);
            }
            catch (Exception exception) {
                Utility.debug(exception);
            }
        }
        return color;
    }

    public static int getIntParameter(@NotNull String string, int n) {
        return Utility.getIntParameter(string, n, 10);
    }

    public static int getIntParameter(@NotNull String string, int n, int n2) {
        requestedParameters.put(string, ParameterTypes.Int);
        String string2 = Utility.getParameter(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2, n2);
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return n;
    }

    public static long getLongParameter(@NotNull String string, long l) {
        return Utility.getLongParameter(string, l, 10);
    }

    public static long getLongParameter(@NotNull String string, long l, int n) {
        String string2 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.Long);
        if (string2 != null) {
            try {
                return Long.parseLong(string2, n);
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return l;
    }

    public static double getDoubleParameter(@NotNull String string, double d) {
        String string2 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.Double);
        if (string2 != null) {
            string2 = string2.trim();
            try {
                double d2 = 1.0;
                if (string2.endsWith("%")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    d2 = 0.01;
                }
                return Double.parseDouble(string2) * d2;
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return d;
    }

    public static float getFloatParameter(@NotNull String string, float f) {
        String string2 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.Float);
        if (string2 != null) {
            string2 = string2.trim();
            try {
                float f2 = 1.0f;
                if (string2.endsWith("%")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    f2 = 0.01f;
                }
                return Float.parseFloat(string2) * f2;
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return f;
    }

    public static PhysicalLength getLengthParameter(@NotNull String string, PhysicalLength physicalLength) {
        String string2 = Utility.getParameter(string);
        requestedParameters.put(string, ParameterTypes.Length);
        if (string2 != null) {
            string2 = string2.trim();
            try {
                return PhysicalLength.fromString(string2, Locale.US);
            }
            catch (IllegalPhysicalLengthFormatException illegalPhysicalLengthFormatException) {
                Utility.debug(illegalPhysicalLengthFormatException);
            }
        }
        return physicalLength;
    }

    public static void debug(@Nullable Object object) {
        if (debugging) {
            System.out.println(object == null ? "<null>" : object.toString());
        }
    }

    public static void debug(@NotNull Throwable throwable) {
        if (debugging) {
            throwable.printStackTrace();
        }
    }

    public static void printProperty(@NotNull String string) {
        try {
            Utility.debug(string + "=" + System.getProperty(string));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void printProperties() {
        if (Utility.isDebug()) {
            String[] stringArray;
            for (String string : stringArray = new String[]{"java.version", "java.vendor", "os.name", "os.arch", "os.version"}) {
                Utility.printProperty(string);
            }
        }
    }

    public static boolean globEquals(@NotNull String string, @NotNull String string2) {
        int n = string.length();
        int n2 = string2.length();
        if (n > 0) {
            char c = string.charAt(0);
            switch (c) {
                case '*': {
                    return Utility.globEquals(string.substring(1), string2) || n2 > 0 && Utility.globEquals(string, string2.substring(1));
                }
                case '?': {
                    return n2 > 0 && Utility.globEquals(string.substring(1), string2.substring(1));
                }
            }
            return n2 > 0 && c == string2.charAt(0) && Utility.globEquals(string.substring(1), string2.substring(1));
        }
        return n == n2;
    }

    public static void addEventQueueExceptionListener(@NotNull EventQueueExceptionListener eventQueueExceptionListener) {
        if (exceptionWrapper == null) {
            exceptionWrapper = new EventQueueExceptionWrapper();
        }
        exceptionWrapper.addEventQueueExceptionListener(eventQueueExceptionListener);
    }

    public static void removeEventQueueExceptionListener(@NotNull EventQueueExceptionListener eventQueueExceptionListener) {
        if (exceptionWrapper != null) {
            exceptionWrapper.removeEventQueueExceptionListener(eventQueueExceptionListener);
        }
    }

    @NotNull
    public static Cursor createCustomCursor(@NotNull Icon icon, @NotNull Color color, @NotNull String string, @NotNull Cursor cursor) {
        return Utility.createCustomCursor(icon, color, null, string, cursor);
    }

    @NotNull
    public static Cursor createCustomCursor(@NotNull Icon icon, @NotNull Color color, @Nullable Point point, @NotNull String string, @NotNull Cursor cursor) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
        if (dimension.width >= icon.getIconWidth() && dimension.height >= icon.getIconHeight()) {
            Cursor cursor2;
            int n = (dimension.width - icon.getIconWidth()) / 2;
            int n2 = (dimension.height - icon.getIconHeight()) / 2;
            BufferedImage bufferedImage = Utility.createPlatformImage(dimension.width, dimension.height, 3);
            preparer.setBackground(color);
            icon.paintIcon(preparer, bufferedImage.getGraphics(), n, n2);
            if (point == null) {
                point = new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2);
            }
            if ((cursor2 = toolkit.createCustomCursor(bufferedImage, new Point(point.x + n, point.y + n2), string)) != null) {
                return cursor2;
            }
        }
        return cursor;
    }

    public static FontMetrics getFontMetrics(@NotNull Font font) {
        return preparer.getFontMetrics(font);
    }

    @NotNull
    public static BufferedImage createPlatformImage(int n, int n2) {
        return Utility.createPlatformImage(n, n2, 1);
    }

    @NotNull
    public static BufferedImage createPlatformImage(int n, int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment.isHeadlessInstance()) {
            return new BufferedImage(n, n2, n3 == 1 ? 1 : 2);
        }
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(n, n2, n3);
    }

    @Nullable
    public static BufferedImage createFastImage(int n, int n2) {
        try {
            Class<?> clazz = Class.forName("ch.randelshofer.awt.graphics.PerfBufferedImage");
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
            return (BufferedImage)constructor.newInstance(n, n2);
        }
        catch (Throwable throwable) {
            Debug.trace(throwable);
            return null;
        }
    }

    @NotNull
    public static VolatileImage createFastVolatileImage(@NotNull Component component, int n, int n2) {
        VolatileImage volatileImage = component.createVolatileImage(n, n2);
        try {
            Method method = volatileImage.getClass().getMethod("setAccelerationPriority", Float.TYPE);
            method.invoke((Object)volatileImage, Float.valueOf(1.0f));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            Debug.trace(throwable);
        }
        return volatileImage;
    }

    public static float getPhysiologicalBrightness(@NotNull Color color) {
        return Utility.getPhysiologicalBrightness(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static float getPhysiologicalBrightness(int n, int n2, int n3) {
        return 0.3f * (float)n / 255.0f + 0.53f * (float)n2 / 255.0f + 0.17000002f * (float)n3 / 255.0f;
    }

    @NotNull
    public static Color getPhysiologicalGray(@NotNull Color color) {
        float f = Utility.getPhysiologicalBrightness(color);
        return new Color(f, f, f);
    }

    public static float getColorBrightnessDistance(@NotNull Color color, @NotNull Color color2) {
        return Math.abs(Utility.getPhysiologicalBrightness(color) - Utility.getPhysiologicalBrightness(color2));
    }

    @NotNull
    public static List<Pair<String>> getSortedSystemProperties() {
        LinkedList<Pair<String>> linkedList = new LinkedList<Pair<String>>();
        try {
            Properties properties = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                linkedList.add((Pair<String>)new Pair((Object)string, (Object)properties.getProperty(string)));
            }
        }
        catch (AccessControlException accessControlException) {
            for (String string : FALLBACK_PROPERTIES) {
                try {
                    String string2 = System.getProperty(string);
                    if (string2 == null) continue;
                    linkedList.add((Pair<String>)new Pair((Object)string, (Object)string2));
                }
                catch (AccessControlException accessControlException2) {
                    // empty catch block
                }
            }
        }
        linkedList.sort(Pair.getFirstEntryPairComparator((Comparator)String.CASE_INSENSITIVE_ORDER));
        return linkedList;
    }

    @NotNull
    public static String toASCII(@NotNull String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c >= ' ' && c < '\u007f') {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(String.format("\\U+%04x", c));
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static void copyImageToClipboard(final @NotNull Image image) {
        Transferable transferable = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            @NotNull
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return image;
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    public static void copyTextToClipboard(final @NotNull String string) {
        Transferable transferable = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            @NotNull
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!DataFlavor.stringFlavor.equals(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return string;
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    @Deprecated
    @SafeVarargs
    @NotNull
    public static <T> List<T> asList(T ... TArray) {
        return Types.asList((Object[])TArray);
    }

    @Deprecated
    @NotNull
    public static <T> List<T> asList(@NotNull T[] TArray, int n) {
        return Types.asList((Object[])TArray, (int)n);
    }

    @Deprecated
    @NotNull
    public static <T> List<T> asList(@NotNull T[] TArray, int n, int n2) {
        return Types.asList((Object[])TArray, (int)n, (int)n2);
    }

    @Nullable
    public static BufferedImage getRootComponentImage(@NotNull Component component) {
        Container container = component.getParent();
        if (container != null) {
            return Utility.getRootComponentImage(container);
        }
        GraphicsDevice graphicsDevice = component.getGraphicsConfiguration().getDevice();
        try {
            Robot robot = new Robot(graphicsDevice);
            return robot.createScreenCapture(component.getBounds());
        }
        catch (AWTException aWTException) {
            Debug.error(aWTException);
            return null;
        }
    }

    @Nullable
    public static String getBuildDate(@NotNull Class<?> clazz) {
        Package package_ = clazz.getPackage();
        return package_ != null ? package_.getImplementationVersion() : null;
    }

    @NotNull
    public static String getBuildDate(@NotNull Class<?> clazz, @NotNull String string) {
        String string2 = Utility.getBuildDate(clazz);
        return string2 != null ? string2 : string;
    }

    @Nullable
    public static String getBuildDate() {
        return Utility.getBuildDate(Utility.class);
    }

    @NotNull
    public static String getBuildDate(@NotNull String string) {
        return Utility.getBuildDate(Utility.class, string);
    }

    @NotNull
    public static OutputStream createOptionalZip(@NotNull String string, @NotNull String string2) throws IOException {
        OutputStream outputStream = Files.newOutputStream(Paths.get(string, new String[0]), new OpenOption[0]);
        if (string.toLowerCase().endsWith(".zip")) {
            String string3;
            int n;
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            if (!string2.startsWith(".")) {
                string2 = "." + string2;
            }
            if ((n = (string3 = string.substring(0, string.length() - 4) + string2).lastIndexOf(File.separator)) >= 0) {
                string3 = string3.substring(n + 1);
            }
            zipOutputStream.setMethod(8);
            zipOutputStream.setLevel(9);
            zipOutputStream.putNextEntry(new ZipEntry(string3));
            outputStream = zipOutputStream;
        }
        return outputStream;
    }

    @NotNull
    public static String toHexDump(@NotNull byte[] byArray) {
        int n;
        int n2;
        int n3;
        String string = byArray.length <= 256 ? "%02X" : (byArray.length <= 65536 ? "%04X" : (byArray.length <= 0x1000000 ? "%06X" : "%08X"));
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = byArray.length / 16;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 16 * n3;
            stringBuilder.append(String.format(string, n2)).append(": ");
            for (n = 0; n < 16; ++n) {
                stringBuilder.append(String.format("%02X ", byArray[n2 + n]));
            }
            stringBuilder.append(" ");
            for (n = 0; n < 16; ++n) {
                stringBuilder.append(Utility.toChar(byArray[n2 + n]));
            }
            stringBuilder.append('\n');
        }
        n3 = byArray.length % 16;
        if (n3 > 0) {
            n2 = 16 * n4;
            stringBuilder.append(String.format(string, n2)).append(": ");
            for (n = 0; n < 16; ++n) {
                stringBuilder.append(n < n3 ? String.format("%02X ", byArray[n2 + n]) : "   ");
            }
            for (n = 0; n < n3; ++n) {
                stringBuilder.append(Utility.toChar(byArray[n2 + n]));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static char toChar(byte by) {
        int n = by & 0xFF;
        if (n < 32 || n >= 127 && n < 160) {
            return '.';
        }
        return (char)n;
    }

    @NotNull
    public static byte[] fromHexData(@NotNull String string) {
        int n;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block3: for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (Character.isWhitespace((char)n)) continue;
            switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    stringBuilder.append((char)n);
                    continue block3;
                }
                default: {
                    throw new NumberFormatException("Not a hexadecimal digit: '" + (char)n + "'!");
                }
            }
        }
        if (stringBuilder.length() == 0) {
            return Empty.BYTE_ARRAY;
        }
        if (stringBuilder.length() % 2 == 1) {
            throw new NumberFormatException("Uneven number of hexadecimal digits!");
        }
        String string2 = stringBuilder.toString();
        n = stringBuilder.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string2.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    @Nullable
    public static URL openResourceViaClass(@NotNull String string) {
        int n = string.indexOf(124);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            try {
                Class<?> clazz = Class.forName(string2);
                return clazz.getResource(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.error(classNotFoundException);
            }
        }
        return Utility.class.getResource(string);
    }

    @NotNull
    public static String spaces(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("num has to be non-negative, but is " + n + "!");
        }
        if (n == 0) {
            return "";
        }
        if (n > SPACES.length()) {
            String string = SPACES;
            int n2 = (n + 1) / 2;
            while (string.length() < n2) {
                string = string + string;
            }
            return string + string.substring(0, n - string.length());
        }
        return SPACES.substring(0, n);
    }

    @NotNull
    public static Dict<String, ParameterTypes> getRequestedParameters() {
        return Dict.viewMap(requestedParameters);
    }

    public static void main(@NotNull String[] stringArray) {
        System.out.println("Jar Build Date: " + Utility.getBuildDate("No build date!"));
        System.out.println("Release Date:   " + RELEASE_DATE);
        for (String string : stringArray) {
            try {
                Class<?> clazz = Class.forName(string);
                String string2 = (String)clazz.getDeclaredField("RELEASE_DATE").get(null);
                System.out.println("--");
                System.out.println("Class:          " + clazz.getName());
                System.out.println("Release Date:   " + string2);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
    }
}

