/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.OrderedPair;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextTemplateHandler<T> {
    @NotNull
    private final List<OrderedPair<Pattern, CtxExpander<T>>> registeredExpanders = new CopyOnWriteArrayList<OrderedPair<Pattern, CtxExpander<T>>>();

    public void register(@NotNull Pattern pattern, @NotNull CtxExpander<T> ctxExpander) {
        this.registeredExpanders.add(OrderedPair.create((Object)pattern, ctxExpander));
    }

    public void register(@NotNull String string, @NotNull CtxExpander<T> ctxExpander) {
        this.register(Pattern.compile(Pattern.quote(string)), ctxExpander);
    }

    @NotNull
    public String expand(@NotNull String string, @NotNull T t) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (OrderedPair<Pattern, CtxExpander<T>> orderedPair : this.registeredExpanders) {
            Matcher matcher = ((Pattern)orderedPair.first).matcher(string);
            int n = 0;
            stringBuilder.setLength(0);
            while (matcher.find()) {
                stringBuilder.append(string.substring(n, matcher.start()));
                stringBuilder.append(((CtxExpander)orderedPair.second).expand(matcher.toMatchResult(), this, t));
                n = matcher.end();
            }
            if (n <= 0) continue;
            stringBuilder.append(string.substring(n));
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public static WithoutContext withoutContext() {
        return new WithoutContext();
    }

    public static class WithoutContext
    extends TextTemplateHandler<WithoutContext> {
        public void register(@NotNull Pattern pattern, @NotNull Expander expander) {
            this.register(pattern, new ToCtxExpander(expander));
        }

        public void register(@NotNull String string, @NotNull Expander expander) {
            this.register(string, new ToCtxExpander(expander));
        }

        @NotNull
        public String expand(@NotNull String string) throws IOException {
            return this.expand(string, this);
        }

        private static class ToCtxExpander
        implements CtxExpander<WithoutContext> {
            @NotNull
            private final Expander expander;

            ToCtxExpander(@NotNull Expander expander) {
                this.expander = expander;
            }

            @Override
            @NotNull
            public String expand(@NotNull MatchResult matchResult, @NotNull TextTemplateHandler<WithoutContext> textTemplateHandler, @NotNull WithoutContext withoutContext) throws IOException {
                return this.expander.expand(matchResult, withoutContext);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ToCtxExpander toCtxExpander = (ToCtxExpander)object;
                return this.expander.equals(toCtxExpander.expander);
            }

            public int hashCode() {
                return Objects.hash(this.expander);
            }
        }
    }

    @FunctionalInterface
    public static interface CtxExpander<T> {
        @NotNull
        public String expand(@NotNull MatchResult var1, @NotNull TextTemplateHandler<T> var2, @NotNull T var3) throws IOException;
    }

    @FunctionalInterface
    public static interface Expander {
        @NotNull
        public String expand(@NotNull MatchResult var1, @NotNull WithoutContext var2) throws IOException;
    }
}

