/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import de.caff.util.ByteCollector;
import de.caff.util.RingBuffer;
import de.caff.util.debug.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

public class TextLineRingBuffer
implements ByteCollector {
    private static final String EOL = String.format("%n", new Object[0]);
    static final int INITIAL_LIMIT = 4096;
    private static final int PIPE_SIZE = 4096;
    @NotNull
    private final RingBuffer<String> ringBuffer;
    private final byte[] tmp = new byte[1];
    @NotNull
    private final CharBuffer pendingCharBuffer = CharBuffer.allocate(4096);
    @NotNull
    private final PipedOutputStream pos;
    @NotNull
    private final BufferedReader textReader;
    private boolean lastWasCR;
    private long totalNumberOfBytes;

    public TextLineRingBuffer(int n, @NotNull Charset charset) {
        this(n, charset, 4096);
    }

    TextLineRingBuffer(int n, @NotNull Charset charset, int n2) {
        this.ringBuffer = new RingBuffer(n, n2);
        PipedInputStream pipedInputStream = new PipedInputStream(4096);
        try {
            this.pos = new PipedOutputStream(pipedInputStream);
            this.textReader = new BufferedReader(new InputStreamReader((InputStream)pipedInputStream, charset));
        }
        catch (IOException iOException) {
            Debug.error(iOException);
            throw new RuntimeException("Unexpected!", iOException);
        }
    }

    public int getLimit() {
        return this.ringBuffer.getLimit();
    }

    public synchronized int size() {
        return this.pendingCharBuffer.position() > 0 ? this.ringBuffer.size() + 1 : this.ringBuffer.size();
    }

    public boolean isEmpty() {
        return this.ringBuffer.isEmpty() && this.pendingCharBuffer.position() == 0;
    }

    @Override
    public synchronized void append(int n) {
        this.tmp[0] = (byte)n;
        this.append(this.tmp, 0, 1);
    }

    @Override
    public synchronized void append(@NotNull byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 - byArray.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, 4096);
                this.pos.write(byArray, n, n3);
                block7: while (this.textReader.ready()) {
                    int n4 = this.textReader.read();
                    switch (n4) {
                        case 13: {
                            this.addPendingLine();
                            this.lastWasCR = true;
                            continue block7;
                        }
                        case 10: {
                            if (this.lastWasCR) {
                                this.lastWasCR = false;
                                continue block7;
                            }
                            this.addPendingLine();
                            continue block7;
                        }
                    }
                    this.pendingCharBuffer.append((char)n4);
                    this.lastWasCR = false;
                }
                n += n3;
                n2 -= n3;
            }
            this.totalNumberOfBytes += (long)n2;
        }
        catch (IOException iOException) {
            Debug.error(iOException);
            throw new RuntimeException("Unexpected!", iOException);
        }
    }

    private void addPendingLine() {
        this.pendingCharBuffer.flip();
        this.ringBuffer.append(this.pendingCharBuffer.toString());
        this.pendingCharBuffer.clear();
    }

    @Override
    public synchronized void clear() {
        this.ringBuffer.clear();
        this.pendingCharBuffer.clear();
        try {
            this.pos.flush();
            while (this.textReader.ready()) {
                this.textReader.read();
            }
        }
        catch (IOException iOException) {
            Debug.error(iOException);
            throw new RuntimeException("Unexpected!", iOException);
        }
    }

    @NotNull
    public synchronized Indexable<String> viewLines() {
        if (this.pendingCharBuffer.position() > 0) {
            int n = this.pendingCharBuffer.position();
            try {
                this.pendingCharBuffer.flip();
                Indexable indexable = Indexable.combine((Indexable[])new Indexable[]{this.ringBuffer.view(), Indexable.singleton((Object)this.pendingCharBuffer.toString())});
                return indexable;
            }
            finally {
                this.pendingCharBuffer.limit(this.pendingCharBuffer.capacity());
                this.pendingCharBuffer.position(n);
            }
        }
        return this.ringBuffer.view();
    }

    @NotNull
    public synchronized Indexable<String> toLineIndexable() {
        return this.viewLines().frozen();
    }

    @NotNull
    public synchronized List<String> toLineList() {
        return this.viewLines().toList();
    }

    @NotNull
    public synchronized String[] toLineArray() {
        return (String[])this.viewLines().toArray(String.class);
    }

    @NotNull
    public synchronized String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String string = Types.join((String)EOL, this.viewLines());
        return this.pendingCharBuffer.position() == 0 ? string + EOL : string;
    }

    @Override
    public synchronized long getNumberOfCollectedBytes() {
        return this.totalNumberOfBytes;
    }
}

