/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.util.BitFlag;
import de.caff.util.BitMask;
import de.caff.util.BitMask16;
import de.caff.util.BitMask32;
import de.caff.util.BitMask64;
import de.caff.util.BitSetBitMask;

public final class SimpleBitFlag
implements BitFlag {
    private static final SimpleBitFlag[] STANDARD_FLAGS = new SimpleBitFlag[64];
    private final int bitPosition;

    private SimpleBitFlag(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos has to be non-negative!");
        }
        this.bitPosition = n;
    }

    @Override
    public boolean isSetIn(@NotNull BitMask bitMask) {
        return bitMask.isSet(this.bitPosition);
    }

    @Override
    @NotNull
    public BitMask setIn(@NotNull BitMask bitMask) {
        return bitMask.set(this.bitPosition);
    }

    @Override
    @NotNull
    public BitMask clearIn(@NotNull BitMask bitMask) {
        return bitMask.clear(this.bitPosition);
    }

    @NotNull
    public BitMask toBitMask() {
        if (this.bitPosition < 16) {
            return this.setIn(BitMask16.ZERO);
        }
        if (this.bitPosition < 32) {
            return this.setIn(BitMask32.ZERO);
        }
        if (this.bitPosition < 64) {
            return this.setIn(BitMask64.ZERO);
        }
        return this.setIn(new BitSetBitMask(this.bitPosition + 1));
    }

    public int toInt() {
        if (this.bitPosition < 32) {
            return 1 << this.bitPosition;
        }
        return 0;
    }

    public long toLong() {
        if (this.bitPosition < 64) {
            return 1L << this.bitPosition;
        }
        return 0L;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    @NotNull
    public static SimpleBitFlag get(int n) {
        if (n < 0 || n >= STANDARD_FLAGS.length) {
            return new SimpleBitFlag(n);
        }
        return STANDARD_FLAGS[n];
    }

    static {
        for (int i = 0; i < STANDARD_FLAGS.length; ++i) {
            SimpleBitFlag.STANDARD_FLAGS[i] = new SimpleBitFlag(i);
        }
    }
}

