/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Empty;
import de.caff.generics.Pair;
import de.caff.generics.Types;
import de.caff.io.InputStreamSink;
import de.caff.util.KnockOffListener;
import de.caff.util.Worker;
import de.caff.util.debug.Debug;
import de.caff.version.SemVer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SemanticVersionChecker
implements KnockOffListener {
    public static final String TAG_SEPARATOR = ":";
    public static final String TAG_COMMENT = "#";
    public static final String TAG_VERSION = "VERSION";
    public static final String TAG_MINJVM = "MINJVM";
    public static final String TAG_NOUPDATE = "NOUPDATE";
    private static final Pattern ZIP_FILE_SEPARATOR_PATTERN = Pattern.compile("/");
    @NotNull
    private final ProgramAccess programAccess;

    private SemanticVersionChecker(@NotNull ProgramAccess programAccess) {
        this.programAccess = programAccess;
    }

    @Override
    public void knockedOff(@NotNull Worker worker) {
        try {
            worker.rethrow();
            SemVer semVer = ((VersionLoader)worker).getVersion();
            String string = ((VersionLoader)worker).getMinJVM();
            if (semVer != null) {
                if (!this.programAccess.getCurrentVersion().equals((Object)semVer)) {
                    if (this.programAccess.isNewerVersion(semVer)) {
                        File file;
                        File file2;
                        Debug.message("New version %0 available (current: %1)", semVer, this.programAccess.getCurrentVersion());
                        URL uRL = ((VersionLoader)worker).getNoUpdateReasonUrl();
                        if (uRL != null) {
                            Debug.message("Have no-update URL: " + uRL);
                            this.programAccess.showInfoNoUpdatePossible(uRL, this.programAccess.getCurrentVersion(), semVer);
                            return;
                        }
                        if (string != null) {
                            if (new Version(string).compareTo(new Version(System.getProperty("java.version"))) > 0) {
                                Debug.error("Update not possible: JVM is too old :%0 (needed: %1)!", System.getProperty("java.version"), string);
                                return;
                            }
                            Debug.message("Current JVM %0 is good enough (min: %1)", System.getProperty("java.version"), string);
                        }
                        File file3 = file2 = (file = this.getJarFile()) != null ? file.getParentFile() : null;
                        if (file != null && (file.exists() ? file.canWrite() : file2 != null && file2.canWrite())) {
                            File file4;
                            boolean bl = this.programAccess.isUserOkayDownload(this.programAccess.getCurrentVersion(), semVer);
                            if (bl && (file4 = this.downloadAndInstall(this.programAccess.getCurrentVersion(), semVer, file)) != null) {
                                List<String> list = SemanticVersionChecker.getStartCommand(file);
                                if (list == null) {
                                    this.programAccess.showInfoNeedRestart(this.programAccess.getCurrentVersion(), semVer);
                                } else {
                                    boolean bl2 = this.programAccess.isUserOkayRestart(this.programAccess.getCurrentVersion(), semVer);
                                    if (bl2 && SemanticVersionChecker.writeStreamToFile(Files.newInputStream(file4.toPath(), new OpenOption[0]), file)) {
                                        file4.deleteOnExit();
                                        Object[] objectArray = this.programAccess.endWithoutExit();
                                        if (objectArray != null) {
                                            list.addAll(Types.asList((Object[])objectArray));
                                            String[] stringArray = list.toArray(Empty.STRING_ARRAY);
                                            Process process = new ProcessBuilder(stringArray).start();
                                            InputStreamSink.startOn(process.getInputStream());
                                            InputStreamSink.startOn(process.getErrorStream());
                                            process.waitFor();
                                            System.exit(0);
                                        }
                                        return;
                                    }
                                }
                                if (this.programAccess.registerRenameShutdownHook(file4)) {
                                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                        try {
                                            SemanticVersionChecker.writeStreamToFile(Files.newInputStream(file4.toPath(), new OpenOption[0]), file);
                                        }
                                        catch (IOException iOException) {
                                            Debug.error(iOException);
                                        }
                                        file4.delete();
                                    }));
                                }
                            }
                        } else {
                            Debug.warn("No jar file access, cannot update!");
                        }
                    } else {
                        Debug.message("No newer version available (current: %0)", this.programAccess.getCurrentVersion());
                        this.programAccess.versionIsCurrent();
                    }
                } else {
                    this.programAccess.versionIsCurrent();
                }
            }
        }
        catch (Throwable throwable) {
            Debug.warn(throwable);
        }
    }

    private static List<String> getStartCommand(File file) {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            String string = System.getProperty("java.home");
            if (string != null) {
                linkedList.add(string + File.separator + "bin" + File.separator + "java");
                linkedList.add("-mx" + Runtime.getRuntime().maxMemory());
                linkedList.add("-jar");
                linkedList.add(file.toString());
                return linkedList;
            }
        }
        catch (Throwable throwable) {
            Debug.error(throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStreamToFile(@NotNull InputStream inputStream, @NotNull File file) throws IOException {
        Debug.trace("writeStreamToFile(???, " + file + ")");
        if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
            byte[] byArray = new byte[4096];
            int n = 0;
            try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                int n2;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n2);
                    n += n2;
                }
            }
            finally {
                inputStream.close();
            }
            return n > 0;
        }
        return false;
    }

    private static void unpackZip(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file, 1);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String[] stringArray;
                ZipEntry zipEntry = enumeration.nextElement();
                File file3 = file2;
                for (String string : stringArray = ZIP_FILE_SEPARATOR_PATTERN.split(zipEntry.getName())) {
                    file3 = new File(file3, string);
                }
                if (zipEntry.isDirectory()) {
                    if (file3.mkdirs()) continue;
                    Debug.error("Failed to create dir: %0", file3);
                    continue;
                }
                SemanticVersionChecker.writeStreamToFile(zipFile.getInputStream(zipEntry), file3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJar(File file) {
        try (JarFile jarFile = new JarFile(file);){
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            Debug.warn("Not a jar: " + file);
            return false;
        }
    }

    private File downloadAndInstall(@NotNull SemVer semVer, @NotNull SemVer semVer2, @NotNull File file) {
        String string = this.programAccess.getUpdateUrl(semVer2, semVer);
        Debug.message("updateUrl=" + string);
        try {
            File file2;
            InputStream inputStream;
            URL uRL;
            if (string != null) {
                uRL = new URL(string);
                Debug.message("Trying update of jar file " + file + "...");
                inputStream = uRL.openStream();
                file2 = File.createTempFile(file.getName(), "jar");
                Debug.message("tmp=" + file2);
                if (SemanticVersionChecker.writeStreamToFile(inputStream, file2) && SemanticVersionChecker.isJar(file2)) {
                    return file2;
                }
            }
            Debug.message("Trying complete download...");
            string = this.programAccess.getPackageUrl(semVer2, this.programAccess.getCurrentVersion());
            Debug.message("packageUrl=" + string);
            if (string != null && SemanticVersionChecker.writeStreamToFile(inputStream = (uRL = new URL(string)).openStream(), file2 = File.createTempFile("kroak", "zip"))) {
                Debug.message("Download complete, unpacking ZIP...");
                SemanticVersionChecker.unpackZip(file2, file.getParentFile().getParentFile());
                Debug.message("Ready.");
                return file2;
            }
        }
        catch (FileNotFoundException | MalformedURLException iOException) {
            this.programAccess.showErrorDownloadFailureNotFound(this.programAccess.getCurrentVersion(), semVer2, string, iOException);
        }
        catch (IOException iOException) {
            this.programAccess.showErrorDownloadFailureIO(this.programAccess.getCurrentVersion(), semVer2, string, iOException);
        }
        return null;
    }

    private File getJarFile() {
        File file = this.programAccess.getOutputJar();
        if (file != null) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException iOException) {
                Debug.error("Cannot canonize file %0: %1", file, iOException);
                return null;
            }
        }
        try {
            String string = System.getProperty("java.class.path");
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(Pattern.quote(File.pathSeparator))) {
                    File file2;
                    if (!string2.endsWith(this.programAccess.getProgramJarName()) || !(file2 = new File(string2)).exists()) continue;
                    return file2.getCanonicalFile();
                }
            }
        }
        catch (Throwable throwable) {
            Debug.error(throwable);
        }
        return null;
    }

    public static void checkForNewVersion(@NotNull ProgramAccess programAccess) {
        VersionLoader versionLoader = new VersionLoader(programAccess);
        versionLoader.addKnockOffListener(new SemanticVersionChecker(programAccess));
        new Thread(versionLoader).start();
    }

    public static class Version
    implements Comparable<Version> {
        private static final Pattern VERSION_SEPARATOR_PATTERN = Pattern.compile("[._]");
        private final int[] parts;

        public Version(String string) {
            String[] stringArray = VERSION_SEPARATOR_PATTERN.split(string);
            this.parts = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.parts[i] = Integer.parseInt(stringArray[i]);
            }
        }

        @Override
        public int compareTo(@NotNull Version version) {
            int n = Math.min(this.parts.length, version.parts.length);
            for (int i = 0; i < n; ++i) {
                int n2 = this.parts[i] - version.parts[i];
                if (n2 == 0) continue;
                return n2;
            }
            return this.parts.length - version.parts.length;
        }
    }

    private static class VersionLoader
    extends Worker {
        private static final Pattern TAG_SEPARATOR_PATTERN = Pattern.compile(":");
        private SemVer version;
        private String minJVM;
        @NotNull
        private final ProgramAccess programAccess;
        private final List<Pair<String>> noUpdateInfo = new LinkedList<Pair<String>>();

        private VersionLoader(@NotNull ProgramAccess programAccess) {
            this.programAccess = programAccess;
        }

        @Override
        protected void execute() throws Exception {
            URL uRL = new URL(this.programAccess.getInfoFileUrl());
            try (InputStream inputStream = uRL.openStream();){
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).isEmpty()) continue;
                    if (string.startsWith(SemanticVersionChecker.TAG_COMMENT)) {
                        Debug.message("Comment: " + string.substring(1));
                        continue;
                    }
                    String[] stringArray = TAG_SEPARATOR_PATTERN.split(string, 2);
                    String string2 = stringArray[0].trim().toUpperCase();
                    if (stringArray.length == 2) {
                        if (SemanticVersionChecker.TAG_VERSION.equalsIgnoreCase(string2)) {
                            this.version = SemVer.parse((String)stringArray[1].trim());
                            if (this.version != null) continue;
                            Debug.error("Not a semantic version: %1", stringArray[1].trim());
                            continue;
                        }
                        if (SemanticVersionChecker.TAG_MINJVM.equalsIgnoreCase(string2)) {
                            this.minJVM = stringArray[1].trim();
                            continue;
                        }
                        if (string2.startsWith(SemanticVersionChecker.TAG_NOUPDATE) && string2.charAt(SemanticVersionChecker.TAG_NOUPDATE.length()) == '[' && string2.endsWith("]")) {
                            String string3 = string2.substring(SemanticVersionChecker.TAG_NOUPDATE.length() + 1, string2.length() - 1);
                            this.noUpdateInfo.add((Pair<String>)Pair.createPair((Object)string3, (Object)stringArray[1].trim()));
                            continue;
                        }
                        throw new IOException("Unknown tag in version description in " + uRL + ":\n" + string);
                    }
                    throw new IOException("Format error in version description in " + uRL + ":\n" + string);
                }
                bufferedReader.close();
                if (this.version == null) {
                    throw new IOException("No version number found in " + uRL);
                }
                Debug.message("Current version:   " + this.programAccess.getCurrentVersion() + "\nPublished version: " + this.version);
            }
        }

        @Nullable
        public SemVer getVersion() {
            return this.version;
        }

        @Nullable
        public String getMinJVM() {
            return this.minJVM;
        }

        @Nullable
        public URL getNoUpdateReasonUrl() {
            for (Pair<String> pair : this.noUpdateInfo) {
                String string = (String)pair.first;
                if (!(string.startsWith("<") ? this.programAccess.isNewerVersion(string.substring(1)) : string.equals(this.programAccess.getCurrentVersion()))) continue;
                return this.getRelativeUrl((String)pair.second);
            }
            return null;
        }

        private URL getRelativeUrl(String string) {
            try {
                URL uRL = new URL(this.programAccess.getInfoFileUrl());
                return new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                Debug.error(malformedURLException);
                return null;
            }
        }
    }

    public static interface ProgramAccess {
        @NotNull
        public SemVer getCurrentVersion();

        public boolean isNewerVersion(@NotNull SemVer var1);

        default public boolean isNewerVersion(@NotNull String string) {
            SemVer semVer = SemVer.parse((String)string);
            if (semVer == null) {
                Debug.error("Not a semantic version: %1", string);
                return false;
            }
            return this.isNewerVersion(semVer);
        }

        @NotNull
        public String getInfoFileUrl();

        @Nullable
        public String getPackageUrl(@NotNull SemVer var1, @NotNull SemVer var2);

        @Nullable
        public String getUpdateUrl(@NotNull SemVer var1, @NotNull SemVer var2);

        @NotNull
        public String getProgramJarName();

        @Nullable
        default public File getOutputJar() {
            return null;
        }

        public void showInfoNoUpdatePossible(@NotNull URL var1, @NotNull SemVer var2, @NotNull SemVer var3);

        default public void versionIsCurrent() {
        }

        public boolean isUserOkayDownload(@NotNull SemVer var1, @NotNull SemVer var2);

        public boolean isUserOkayRestart(@NotNull SemVer var1, @NotNull SemVer var2);

        public void showInfoNeedRestart(@NotNull SemVer var1, @NotNull SemVer var2);

        public void showErrorDownloadFailureNotFound(@NotNull SemVer var1, @NotNull SemVer var2, @NotNull String var3, @NotNull Exception var4);

        public void showErrorDownloadFailureIO(@NotNull SemVer var1, @NotNull SemVer var2, @NotNull String var3, @NotNull IOException var4);

        @Nullable
        public String[] endWithoutExit();

        default public boolean registerRenameShutdownHook(@NotNull File file) {
            return true;
        }
    }
}

