/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RingBuffer<T> {
    static final int INITIAL_LIMIT = 0x100000;
    private final int limit;
    private T[] ringBuffer;
    private int bufferOffset;
    private int itemsCached;
    private long totalNumberOfItems;

    public RingBuffer(int n) {
        this(n, 0x100000);
    }

    RingBuffer(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("limit has to be positive, but is " + n);
        }
        this.ringBuffer = n < n2 ? new Object[n] : new Object[n2];
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    public synchronized int size() {
        return this.itemsCached;
    }

    public synchronized boolean isEmpty() {
        return this.itemsCached == 0;
    }

    public synchronized void append(T t) {
        if (this.bufferOffset < this.ringBuffer.length) {
            this.ringBuffer[this.bufferOffset++] = t;
            if (this.itemsCached < this.limit) {
                ++this.itemsCached;
            }
            ++this.totalNumberOfItems;
        } else if (this.ringBuffer.length == this.limit) {
            this.ringBuffer[0] = t;
            this.bufferOffset = 1;
            ++this.totalNumberOfItems;
        } else {
            this.append(new Object[]{t});
        }
    }

    @SafeVarargs
    public final synchronized void append(T ... TArray) {
        this.append(TArray, 0, TArray.length);
    }

    public synchronized void append(@NotNull T[] TArray, int n, int n2) {
        if (n < 0 || n > TArray.length || n2 < 0 || n + n2 - TArray.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.appendInternally(TArray, n, n2);
    }

    private void appendInternally(@NotNull T[] TArray, int n, int n2) {
        if (n2 > this.ringBuffer.length - this.bufferOffset) {
            if (this.ringBuffer.length < this.limit) {
                int n3 = this.ringBuffer.length > 0x3FFFFFFF ? this.limit : Math.min(this.limit, 2 * this.ringBuffer.length);
                this.ringBuffer = Arrays.copyOf(this.ringBuffer, n3);
                this.appendInternally(TArray, n, n2);
                return;
            }
            if (n2 > this.limit) {
                this.clear();
                int n4 = n2 - this.limit;
                this.appendInternally(TArray, n + n4, this.limit);
                return;
            }
            assert (this.ringBuffer.length == this.limit);
            int n5 = this.limit - this.bufferOffset;
            if (n5 > 0) {
                System.arraycopy(TArray, n, this.ringBuffer, this.bufferOffset, n5);
                n += n5;
                n2 -= n5;
                this.totalNumberOfItems += (long)n5;
            }
            this.bufferOffset = 0;
            this.itemsCached = this.limit;
        }
        System.arraycopy(TArray, n, this.ringBuffer, this.bufferOffset, n2);
        this.bufferOffset += n2;
        if (this.itemsCached < this.limit) {
            this.itemsCached += Math.min(n2, this.limit - this.itemsCached);
        }
        this.totalNumberOfItems += (long)n2;
    }

    @NotNull
    public synchronized List<T> toList() {
        if (this.itemsCached == 0) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(this.itemsCached);
        if (this.bufferOffset < this.itemsCached) {
            int n = this.itemsCached - this.bufferOffset;
            this.copyTo(this.limit - n, n, arrayList);
            this.copyTo(0, this.bufferOffset, arrayList);
        } else {
            this.copyTo(this.bufferOffset - this.itemsCached, this.itemsCached, arrayList);
        }
        return arrayList;
    }

    private void copyTo(int n, int n2, @NotNull Collection<T> collection) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            collection.add(this.ringBuffer[i]);
        }
    }

    @NotNull
    public synchronized Indexable<T> view() {
        if (this.itemsCached == 0) {
            return Indexable.emptyIndexable();
        }
        if (this.bufferOffset >= this.itemsCached) {
            return Indexable.viewArray((Object[])this.ringBuffer).subSet(this.bufferOffset - this.itemsCached, this.bufferOffset);
        }
        final int n = this.itemsCached;
        final int n2 = this.bufferOffset;
        final int n3 = this.ringBuffer.length - n2;
        return new Indexable.Base<T>(){

            public T get(int n4) {
                if (n4 < n3) {
                    return RingBuffer.this.ringBuffer[n2 + n4];
                }
                return RingBuffer.this.ringBuffer[n4 - n3];
            }

            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public synchronized Indexable<T> toIndexable() {
        return this.view().frozen();
    }

    public synchronized void clear() {
        this.bufferOffset = 0;
        this.itemsCached = 0;
    }

    public synchronized long getNumberOfCollectedItems() {
        return this.totalNumberOfItems;
    }
}

