/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import java.math.BigInteger;

public enum MemFormat {
    Base10(1000, "k", "M", "G", "T", "P", "E", "Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q"),
    Base2(1024, "ki", "Mi", "Gi", "Ti", "Pi", "Ei", "Zi", "Yi", "Xi", "Wi", "Vi", "Ui", "Ti", "Si", "Ri", "Qi");

    @NotNull
    private static final BigInteger HUNDRED;
    public final int kiloSize;
    public final BigInteger bigKiloSize;
    @NotNull
    public final Indexable<String> prefixes;

    private MemFormat(int n2, String ... stringArray) {
        this.kiloSize = n2;
        this.bigKiloSize = BigInteger.valueOf(n2);
        this.prefixes = Indexable.viewArray((Object[])stringArray);
    }

    @NotNull
    public String toString(long l) {
        return this.toString(BigInteger.valueOf(l));
    }

    @NotNull
    public String toString(@NotNull BigInteger bigInteger) {
        return this.toString(bigInteger, null, null);
    }

    @NotNull
    public String toString(long l, @Nullable String string, @Nullable String string2) {
        return this.toString(BigInteger.valueOf(l), string, string2);
    }

    @NotNull
    public String toString(@NotNull BigInteger bigInteger, @Nullable String string, @Nullable String string2) {
        string = Types.notNull((String)string);
        string2 = Types.notNull((String)string2);
        if (bigInteger.signum() == -1) {
            return "-" + this.toString(bigInteger.negate());
        }
        if (bigInteger.compareTo(this.bigKiloSize) < 0) {
            return bigInteger.toString();
        }
        long l = 0L;
        for (String string3 : this.prefixes) {
            l = bigInteger.mod(this.bigKiloSize).longValue();
            if ((bigInteger = bigInteger.divide(this.bigKiloSize)).compareTo(this.bigKiloSize) >= 0) continue;
            StringBuilder stringBuilder = new StringBuilder(16);
            if (l > 0L) {
                double d = (double)l / (double)this.kiloSize;
                if (bigInteger.compareTo(BigInteger.TEN) < 0) {
                    int n = (int)Math.round(100.0 * d);
                    if (n == 100) {
                        stringBuilder.append(bigInteger.add(BigInteger.ONE));
                    } else {
                        stringBuilder.append(bigInteger);
                        if (n != 0) {
                            stringBuilder.append(String.format(".%d", n));
                        }
                    }
                } else if (bigInteger.compareTo(HUNDRED) < 0) {
                    int n = (int)Math.round(10.0 * d);
                    if (n == 10) {
                        stringBuilder.append(bigInteger.add(BigInteger.ONE));
                    } else {
                        stringBuilder.append(bigInteger);
                        if (n != 0) {
                            stringBuilder.append(String.format(".%d", n));
                        }
                    }
                } else {
                    stringBuilder.append(bigInteger);
                }
            } else {
                stringBuilder.append(bigInteger);
            }
            stringBuilder.append(string).append(string3).append(string2);
            return stringBuilder.toString();
        }
        if (BigInteger.valueOf(2L * l).compareTo(this.bigKiloSize) >= 0) {
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
        return String.format("%s%s%s%s", bigInteger, string, this.prefixes.gyt(-1), string2);
    }

    static {
        HUNDRED = BigInteger.valueOf(100L);
    }
}

