/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import java.io.IOException;
import java.io.Writer;

public class ImprovedStringWriter
extends Writer {
    private final StringBuilder buffer;

    public ImprovedStringWriter() {
        this.buffer = new StringBuilder();
        this.lock = this.buffer;
    }

    public ImprovedStringWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buffer = new StringBuilder(n);
        this.lock = this.buffer;
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer.append((char)n);
    }

    @Override
    public void write(@NotNull char[] cArray, int n, int n2) throws IOException {
        this.buffer.append(cArray, n, n2);
    }

    @Override
    public void write(@NotNull String string) throws IOException {
        this.buffer.append(string);
    }

    @Override
    public void write(@NotNull String string, int n, int n2) throws IOException {
        this.buffer.append(string, n, n2);
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.buffer.append("null");
        } else {
            this.buffer.append(charSequence);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        this.buffer.append(charSequence, n, n2);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.buffer.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

