/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageToImageDrawer
implements ImageObserver {
    @NotNull
    private final Image sourceImage;
    @NotNull
    private final BufferedImage targetImage;
    private final boolean doScale;

    public ImageToImageDrawer(@NotNull Image image, @NotNull BufferedImage bufferedImage, boolean bl) {
        this.sourceImage = image;
        this.targetImage = bufferedImage;
        this.doScale = bl;
        this.doDraw();
    }

    @NotNull
    public Image getSourceImage() {
        return this.sourceImage;
    }

    @NotNull
    public BufferedImage getTargetImage() {
        return this.targetImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDraw() {
        Graphics2D graphics2D = this.targetImage.createGraphics();
        try {
            if (this.doScale) {
                double d = (double)this.targetImage.getWidth() / (double)this.sourceImage.getWidth(this);
                double d2 = (double)this.targetImage.getHeight() / (double)this.sourceImage.getHeight(this);
                double d3 = Math.min(d, d2);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-0.5 * (double)this.sourceImage.getWidth(this), -0.5 * (double)this.sourceImage.getHeight(this));
                affineTransform.preConcatenate(AffineTransform.getScaleInstance(d3, d3));
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(0.5 * (double)this.targetImage.getWidth(), 0.5 * (double)this.targetImage.getHeight()));
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawImage(this.sourceImage, affineTransform, this);
            } else {
                graphics2D.drawImage(this.sourceImage, (this.targetImage.getWidth() - this.sourceImage.getWidth(this)) / 2, (this.targetImage.getHeight() - this.sourceImage.getHeight(this)) / 2, this);
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xC0) == 0) {
            this.doDraw();
        }
        return (n & 0xA0) == 0;
    }
}

