/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class IOUtil {
    private IOUtil() {
    }

    public static void readFully(@NotNull InputStream inputStream, @NotNull byte[] byArray, int n, int n2) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid negative offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid negative length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Requested bytes will not fit into array!");
        }
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 <= 0) {
                throw new EOFException(String.format("Cannot read %s (more) bytes!", n2));
            }
            n2 -= n3;
            n += n3;
        }
    }

    public static void readFully(@NotNull InputStream inputStream, @NotNull byte[] byArray, int n) throws IOException {
        IOUtil.readFully(inputStream, byArray, 0, n);
    }

    public static void readFully(@NotNull InputStream inputStream, @NotNull byte[] byArray) throws IOException {
        IOUtil.readFully(inputStream, byArray, byArray.length);
    }

    @NotNull
    public static byte[] readAllBytes(@NotNull InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @NotNull
    public static String readAllText(@NotNull InputStream inputStream, @NotNull Charset charset) throws IOException {
        return new String(IOUtil.readAllBytes(inputStream), charset);
    }

    @NotNull
    public static String readAllText(@NotNull InputStream inputStream) throws IOException {
        return IOUtil.readAllText(inputStream, Charset.defaultCharset());
    }

    @NotNull
    public static String readAllTextUtf8(@NotNull InputStream inputStream) throws IOException {
        return IOUtil.readAllText(inputStream, StandardCharsets.UTF_8);
    }

    public static void discardInput(@NotNull InputStream inputStream) throws IOException {
        byte[] byArray = new byte[512];
        try {
            while (inputStream.read(byArray) != 0) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

