/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.function.Predicate1;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public class GlobMatcher {
    private static final Matcher[] EMPTY_MATCHER_ARRAY = new Matcher[0];
    @NotNull
    private final String pattern;
    @NotNull
    private final Matcher[] matchers;
    private static final Matcher ASTERISK_MATCHER = new Matcher(){

        @Override
        public String[] getMatches(@NotNull String string) {
            String[] stringArray = new String[string.length() + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = string.substring(i);
            }
            return stringArray;
        }
    };
    private static final Matcher QUESTIONMARK_MATCHER = new Matcher(){

        @Override
        @Nullable
        public String[] getMatches(@NotNull String string) {
            if (!string.isEmpty()) {
                return new String[]{string.substring(1)};
            }
            return NO_MATCH;
        }
    };

    public GlobMatcher(@NotNull String string) {
        this(string, false);
    }

    public GlobMatcher(@NotNull String string, boolean bl) {
        this(string, GlobMatcher.extractMatchers(string, bl));
    }

    private GlobMatcher(@NotNull String string, @NotNull Matcher[] matcherArray) {
        this.pattern = string;
        this.matchers = matcherArray;
    }

    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    public int getCardinality() {
        return this.matchers.length;
    }

    public boolean hasWildCards() {
        for (Matcher matcher : this.matchers) {
            if (matcher.isPlain()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Predicate1<String> asPredicate() {
        return this::isMatching;
    }

    @Nullable
    public static GlobMatcher whenUsingGlobbing(@NotNull String string, boolean bl) {
        Matcher[] matcherArray = GlobMatcher.extractMatchers(string, bl);
        if (matcherArray.length == 0) {
            return null;
        }
        for (Matcher matcher : matcherArray) {
            if (matcher.isPlain()) continue;
            return new GlobMatcher(string, matcherArray);
        }
        return null;
    }

    @NotNull
    private static Matcher[] extractMatchers(@NotNull String string, boolean bl) {
        int n = 0;
        LinkedList<Matcher> linkedList = new LinkedList<Matcher>();
        boolean bl2 = false;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl2) {
                bl2 = false;
                linkedList.add(bl ? new CaseInsensitiveCharMatcher(c) : new CharMatcher(c));
                continue;
            }
            switch (c) {
                case '\\': {
                    bl2 = true;
                    break;
                }
                case '*': {
                    linkedList.add(ASTERISK_MATCHER);
                    break;
                }
                case '?': {
                    linkedList.add(QUESTIONMARK_MATCHER);
                    break;
                }
                case '[': {
                    int n2 = string.indexOf(93, n + 1);
                    if (n2 == -1) {
                        linkedList.add(new CharMatcher(c));
                        break;
                    }
                    if (n2 == n + 1 ? (n2 = string.indexOf(93, n2 + 1)) == -1 : n2 == n + 2 && string.charAt(n + 1) == '^' && (n2 = string.indexOf(93, n2 + 1)) == -1) break;
                    String string2 = string.substring(n + 1, n2);
                    n = n2;
                    linkedList.add(string2.startsWith("^") ? new InvertedSetMatcher(string2.substring(1), bl) : new SetMatcher(string2, bl));
                    break;
                }
                default: {
                    linkedList.add(bl ? new CaseInsensitiveCharMatcher(c) : new CharMatcher(c));
                }
            }
            ++n;
        }
        return linkedList.toArray(EMPTY_MATCHER_ARRAY);
    }

    public boolean isMatching(@NotNull String string) {
        return this.isMatching(string, 0);
    }

    private boolean isMatching(@NotNull String string, int n) {
        if (n == this.matchers.length) {
            return string.isEmpty();
        }
        String[] stringArray = this.matchers[n].getMatches(string);
        if (stringArray == null) {
            return false;
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!this.isMatching(stringArray[i], n + 1)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GlobMatcher)) {
            return false;
        }
        return Objects.equals(this.pattern, ((GlobMatcher)object).pattern);
    }

    public int hashCode() {
        return Objects.hashCode(this.pattern);
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.pattern + ")";
    }

    public static void main(@NotNull String[] stringArray) {
        if (stringArray.length > 2) {
            GlobMatcher globMatcher = new GlobMatcher(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                System.out.println(stringArray[i] + "\t" + (globMatcher.isMatching(stringArray[i]) ? "MATCH" : "MISS"));
            }
        } else {
            Tester[] testerArray;
            for (Tester tester : testerArray = new Tester[]{new Tester("A*A", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AA", true), new Tester.Test("ABA", true), new Tester.Test("AAB", false), new Tester.Test("BAA", false), new Tester.Test("AAA", true), new Tester.Test("AAABBBBBBBBBBBBBBBBBBBBBBBBB", false), new Tester.Test("AAABBBBBBBBBBBBBBBBBBBBBBBBBA", true)}), new Tester("A?C", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("AC", false), new Tester.Test("ABC", true), new Tester.Test("AABC", false), new Tester.Test("ABCC", false), new Tester.Test("ABBC", false)}), new Tester("A[BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", true), new Tester.Test("ACD", true)}), new Tester("A[^BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", false), new Tester.Test("ACD", false), new Tester.Test("AED", true)}), new Tester("A[B^C]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", true), new Tester.Test("ACD", true), new Tester.Test("AED", false), new Tester.Test("A^D", true)}), new Tester("A[]BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", true), new Tester.Test("ACD", true), new Tester.Test("AED", false), new Tester.Test("A]D", true), new Tester.Test("A[D", false)}), new Tester("A[^]BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", false), new Tester.Test("ACD", false), new Tester.Test("AED", true), new Tester.Test("A]D", false), new Tester.Test("A[D", true), new Tester.Test("A^D", true)}), new Tester("A[^]^BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", false), new Tester.Test("ACD", false), new Tester.Test("AED", true), new Tester.Test("A]D", false), new Tester.Test("A[D", true), new Tester.Test("A^D", false)}), new Tester("A[^^BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", false), new Tester.Test("ACD", false), new Tester.Test("AED", true), new Tester.Test("A]D", true), new Tester.Test("A^D", false)}), new Tester("A[?*BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", true), new Tester.Test("ACD", true), new Tester.Test("AED", false), new Tester.Test("A?D", true), new Tester.Test("A*D", true), new Tester.Test("A^D", false)}), new Tester("A[^?*BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", false), new Tester.Test("ACD", false), new Tester.Test("AED", true), new Tester.Test("A?D", false), new Tester.Test("A*D", false), new Tester.Test("A^D", true)}), new Tester("A[-?*BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", true), new Tester.Test("ACD", true), new Tester.Test("AED", false), new Tester.Test("A?D", true), new Tester.Test("A*D", true), new Tester.Test("A^D", false), new Tester.Test("A-D", true)}), new Tester("A[^-?*BC]D", new Tester.Test[]{new Tester.Test("", false), new Tester.Test("A", false), new Tester.Test("AB", false), new Tester.Test("ABC", false), new Tester.Test("ABCD", false), new Tester.Test("ABD", false), new Tester.Test("ACD", false), new Tester.Test("AED", true), new Tester.Test("A?D", false), new Tester.Test("A*D", false), new Tester.Test("A^D", true), new Tester.Test("A-D", false)})}) {
                tester.runTests();
            }
        }
    }

    private static class Tester {
        private final GlobMatcher matcher;
        private final Test[] tests;

        private Tester(@NotNull String string, @NotNull Test[] testArray) {
            this.matcher = new GlobMatcher(string);
            this.tests = testArray;
        }

        public void runTests() {
            for (Test test : this.tests) {
                test.check(this.matcher);
            }
        }

        private static class Test {
            @NotNull
            private final String testString;
            private final boolean result;

            private Test(@NotNull String string, boolean bl) {
                this.testString = string;
                this.result = bl;
            }

            @NotNull
            public String getTestString() {
                return this.testString;
            }

            public boolean getResult() {
                return this.result;
            }

            public void check(@NotNull GlobMatcher globMatcher) {
                if (globMatcher.isMatching(this.testString) != this.result) {
                    System.out.println("FAILED:\t" + globMatcher + "\t'" + this.testString + '\'' + "\tExpected: " + this.result);
                }
            }
        }
    }

    private static class InvertedSetMatcher
    extends SetMatcher {
        private InvertedSetMatcher(@NotNull String string, boolean bl) {
            super(string, bl);
        }

        @Override
        @Nullable
        public String[] getMatches(@NotNull String string) {
            String[] stringArray;
            if (!string.isEmpty() && !this.isMatching(string.charAt(0))) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string.substring(1);
            } else {
                stringArray = NO_MATCH;
            }
            return stringArray;
        }
    }

    private static class SetMatcher
    implements Matcher {
        @NotNull
        private final Set<Character> matching = new HashSet<Character>();

        private SetMatcher(@NotNull String string, boolean bl) {
            char c = '\u0000';
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == '-') {
                    char c3;
                    if (this.matching.isEmpty()) {
                        if (bl) {
                            this.addCaseInsensitive(c2);
                            continue;
                        }
                        this.matching.add(Character.valueOf(c2));
                        continue;
                    }
                    if (++i == string.length()) {
                        throw new IllegalArgumentException("Not a valid glob set: " + string);
                    }
                    char c4 = c;
                    c2 = string.charAt(i);
                    if (c2 <= c) {
                        throw new IllegalArgumentException("Not a valid glob set: " + string);
                    }
                    if (bl) {
                        for (c3 = (char)(c4 + '\u0001'); c3 <= c2; c3 = (char)(c3 + '\u0001')) {
                            this.addCaseInsensitive(c3);
                        }
                    } else {
                        for (c3 = (char)(c4 + '\u0001'); c3 <= c2; c3 = (char)(c3 + '\u0001')) {
                            this.matching.add(Character.valueOf(c3));
                        }
                    }
                    c = c2;
                    continue;
                }
                if (bl) {
                    this.addCaseInsensitive(c2);
                } else {
                    this.matching.add(Character.valueOf(c2));
                }
                c = c2;
            }
        }

        private void addCaseInsensitive(char c) {
            this.matching.add(Character.valueOf(c));
            this.matching.add(Character.valueOf(Character.toUpperCase(c)));
            this.matching.add(Character.valueOf(Character.toLowerCase(c)));
            this.matching.add(Character.valueOf(Character.toTitleCase(c)));
        }

        @Override
        @Nullable
        public String[] getMatches(@NotNull String string) {
            String[] stringArray;
            if (!string.isEmpty() && this.isMatching(string.charAt(0))) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string.substring(1);
            } else {
                stringArray = NO_MATCH;
            }
            return stringArray;
        }

        public boolean isMatching(char c) {
            return this.matching.contains(Character.valueOf(c));
        }
    }

    private static class CaseInsensitiveCharMatcher
    implements Matcher {
        private final String ch;

        private CaseInsensitiveCharMatcher(char c) {
            this.ch = Character.toString(c);
        }

        @Override
        @Nullable
        public String[] getMatches(@NotNull String string) {
            String[] stringArray;
            if (!string.isEmpty() && this.ch.equalsIgnoreCase(string.substring(0, 1))) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string.substring(1);
            } else {
                stringArray = NO_MATCH;
            }
            return stringArray;
        }

        @Override
        public boolean isPlain() {
            return true;
        }
    }

    private static class CharMatcher
    implements Matcher {
        private final char ch;

        private CharMatcher(char c) {
            this.ch = c;
        }

        @Override
        @Nullable
        public String[] getMatches(@NotNull String string) {
            String[] stringArray;
            if (!string.isEmpty() && string.charAt(0) == this.ch) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string.substring(1);
            } else {
                stringArray = NO_MATCH;
            }
            return stringArray;
        }

        @Override
        public boolean isPlain() {
            return true;
        }
    }

    private static interface Matcher {
        public static final String[] NO_MATCH = null;

        @Nullable
        public String[] getMatches(@NotNull String var1);

        default public boolean isPlain() {
            return false;
        }
    }
}

