/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileProcedure1;
import de.caff.generics.function.Predicate1;
import de.caff.util.GlobMatcher;
import de.caff.util.IOUtil;
import de.caff.util.Utility;
import de.caff.util.debug.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class FileTool {
    public static final Comparator<File> DIRECTORIES_FIRST = (file, file2) -> file.isDirectory() ^ file2.isDirectory() ? (file.isDirectory() ? -1 : 1) : 0;
    public static final Comparator<File> BY_NAME_CASE_INSENSITIVE = (file, file2) -> {
        int n = file.getName().compareToIgnoreCase(file2.getName());
        return n == 0 ? file.getName().compareTo(file2.getName()) : n;
    };
    public static final Comparator<File> BY_NAME_CASE_SENSITIVE = Comparator.comparing(File::getName);
    private static final int FILE_COMPARE_BUFFER_SIZE = 65536;
    public static final long NO_DIFFERENCE = -1L;

    private FileTool() {
    }

    public static void walkTree(@NotNull File file, @NotNull Predicate<? super File> predicate, @NotNull Consumer<? super File> consumer) {
        if (!file.exists()) {
            Debug.error("walkTree() called w/ non-existent file: %0", file);
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            if (predicate.test(file) && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    FileTool.walkTree(file2, predicate, consumer);
                }
            }
        } else {
            consumer.accept(file);
        }
    }

    public static void walkTree(@NotNull File file, @NotNull Consumer<? super File> consumer) {
        FileTool.walkTree(file, (Predicate<? super File>)Predicate1.alwaysTrue(), consumer);
    }

    public static void walkTreeOrdered(@NotNull File file, @NotNull Predicate<? super File> predicate, @NotNull Consumer<? super File> consumer, @NotNull Comparator<? super File> comparator) {
        if (!file.exists()) {
            Debug.error("walkTree() called w/ non-existent file: %0", file);
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            if (predicate.test(file) && (fileArray = file.listFiles()) != null) {
                Arrays.sort(fileArray, comparator);
                for (File file2 : fileArray) {
                    FileTool.walkTree(file2, predicate, consumer);
                }
            }
        } else {
            consumer.accept(file);
        }
    }

    public static void walkTreeOrdered(@NotNull File file, @NotNull Consumer<? super File> consumer, @NotNull Comparator<? super File> comparator) {
        FileTool.walkTreeOrdered(file, (Predicate<? super File>)Predicate1.alwaysTrue(), consumer, comparator);
    }

    public static <E extends Exception> void walkTreeFragile(@NotNull File file, @NotNull Predicate<File> predicate, @NotNull FragileProcedure1<E, ? super File> fragileProcedure1) throws E {
        if (!file.exists()) {
            Debug.error("walkTreeFragile() called w/ non-existent file: %0", file);
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            if (predicate.test(file) && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    FileTool.walkTreeFragile(file2, predicate, fragileProcedure1);
                }
            }
        } else {
            fragileProcedure1.apply((Object)file);
        }
    }

    public static <E extends Exception> void walkTreeFragile(@NotNull File file, @NotNull FragileProcedure1<E, ? super File> fragileProcedure1) throws E {
        FileTool.walkTreeFragile(file, (Predicate<File>)Predicate1.alwaysTrue(), fragileProcedure1);
    }

    @Nullable
    public static String getExtension(@NotNull File file) {
        return FileTool.getExtension(file.getName());
    }

    @Nullable
    public static String getExtension(@NotNull String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : null;
    }

    public static boolean contentEquals(@NotNull File file, @NotNull File file2) throws IOException {
        if (file.length() != file2.length()) {
            return false;
        }
        return FileTool.firstDiff(file, file2) == -1L;
    }

    public static boolean contentEquals(@NotNull Path path, @NotNull Path path2) throws IOException {
        return FileTool.contentEquals(path.toFile(), path2.toFile());
    }

    public static boolean contentEquals(@NotNull String string, @NotNull String string2) throws IOException {
        return FileTool.contentEquals(new File(string), new File(string2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long firstDiff(@NotNull File var0, @NotNull File var1_1) throws IOException {
        if (var0.equals(var1_1)) {
            return -1L;
        }
        var2_2 = Files.newInputStream(var0.toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            var4_4 = Files.newInputStream(var1_1.toPath(), new OpenOption[0]);
            var5_6 = null;
            var6_7 = new byte[65536];
            var7_9 = new byte[65536];
            var8_10 = 0L;
lbl12:
            // 2 sources

            while (true) {
                var10_11 = Math.max(var2_2.read(var6_7), 0);
                var12_13 = Math.min(var10_11, var11_12 = Math.max(var4_4.read(var7_9), 0));
                var13_14 = FileTool.firstDiff(var6_7, var7_9, var12_13);
                if (var13_14 < 0) ** GOTO lbl-1000
                var14_15 = var8_10 + (long)var13_14;
                if (var4_4 == null) return var14_15;
                if (var5_6 != null) {
                }
                ** GOTO lbl42
                break;
            }
            {
                block39: {
                    block40: {
                        block38: {
                            catch (Throwable var6_8) {
                                var5_6 = var6_8;
                                throw var6_8;
                            }
                            catch (Throwable var17_24) {
                                if (var4_4 == null) throw var17_24;
                                if (var5_6 == null) {
                                    var4_4.close();
                                    throw var17_24;
                                }
                                try {
                                    var4_4.close();
                                    throw var17_24;
                                }
                                catch (Throwable var18_25) {
                                    var5_6.addSuppressed(var18_25);
                                    throw var17_24;
                                }
                            }
                            try {
                                var4_4.close();
                                return var14_15;
                            }
                            catch (Throwable var16_18) {
                                var5_6.addSuppressed(var16_18);
                                return var14_15;
                            }
lbl42:
                            // 1 sources

                            var4_4.close();
                            return var14_15;
lbl-1000:
                            // 1 sources

                            {
                                var8_10 += (long)var12_13;
                                if (var10_11 == var11_12) ** GOTO lbl-1000
                                var14_16 = var8_10;
                                if (var4_4 == null) return var14_16;
                                if (var5_6 == null) break block38;
                            }
                            try {
                                var4_4.close();
                                return var14_16;
                            }
                            catch (Throwable var16_20) {
                                var5_6.addSuppressed(var16_20);
                                return var14_16;
                            }
                        }
                        var4_4.close();
                        return var14_16;
lbl-1000:
                        // 1 sources

                        {
                            if (var12_13 != 0) break block39;
                            var14_17 = -1L;
                            if (var4_4 == null) return var14_17;
                            if (var5_6 == null) break block40;
                        }
                        try {
                            var4_4.close();
                            return var14_17;
                        }
                        catch (Throwable var16_22) {
                            var5_6.addSuppressed(var16_22);
                            return var14_17;
                        }
                    }
                    var4_4.close();
                    return var14_17;
                }
                ** try [egrp 13[TRYBLOCK] [18 : 348->400)] { 
lbl-1000:
                // 1 sources

                {
                    ** continue;
                }
            }
        }
lbl74:
        // 2 sources

        catch (Throwable var4_5) {
            var3_3 = var4_5;
            throw var4_5;
        }
        finally {
            if (var2_2 != null) {
                if (var3_3 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (Throwable var16_19) {
                        var3_3.addSuppressed(var16_19);
                    }
                } else {
                    var2_2.close();
                }
            }
        }
    }

    public static long firstDiff(@NotNull String string, @NotNull String string2) throws IOException {
        return FileTool.firstDiff(new File(string), new File(string2));
    }

    private static int firstDiff(@NotNull byte[] byArray, @NotNull byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static byte[] load(@NotNull File file) throws IOException {
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File too large: " + l);
        }
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] byArray = new byte[(int)l];
            IOUtil.readFully(inputStream, byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @NotNull
    public static byte[] load(@NotNull String string) throws IOException {
        return FileTool.load(new File(string));
    }

    public static void store(@NotNull File file, @NotNull byte[] byArray) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            outputStream.write(byArray);
        }
    }

    public static void store(@NotNull File file, @NotNull byte[] byArray, int n, int n2) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid negative offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid negative length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Requested bytes will not fit into array!");
        }
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            outputStream.write(byArray, n, n2);
        }
    }

    public static void store(@NotNull String string, @NotNull byte[] byArray) throws IOException {
        FileTool.store(new File(string), byArray);
    }

    public static void store(@NotNull String string, @NotNull byte[] byArray, int n, int n2) throws IOException {
        FileTool.store(new File(string), byArray, n, n2);
    }

    public static void append(@NotNull File file, @NotNull byte[] byArray) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            outputStream.write(byArray);
        }
    }

    public static void append(@NotNull File file, @NotNull byte[] byArray, int n, int n2) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid negative offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid negative length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Requested bytes will not fit into array!");
        }
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            outputStream.write(byArray, n, n2);
        }
    }

    public static void append(@NotNull String string, @NotNull byte[] byArray) throws IOException {
        FileTool.append(new File(string), byArray);
    }

    public static void append(@NotNull String string, @NotNull byte[] byArray, int n, int n2) throws IOException {
        FileTool.append(new File(string), byArray, n, n2);
    }

    public static boolean deleteTree(@NotNull File file) {
        FileTool.cleanup(file);
        return file.delete();
    }

    public static boolean cleanup(@NotNull File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (FileTool.deleteTree(file2)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static File multiExpand(@NotNull File file, @NotNull String string) {
        return FileTool.multiExpand(file, File.separatorChar, string);
    }

    public static File multiExpand(@NotNull File file, char c, @NotNull String string) {
        String string2 = Character.toString(c);
        if (string.startsWith(string2)) {
            throw new IllegalArgumentException("Cannot expand with absolute subPath: " + string);
        }
        return FileTool.expand(file, string.split(Pattern.quote(string2)));
    }

    public static File expand(@NotNull File file, String ... stringArray) {
        File file2 = file;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        block8: for (int i = 0; i < n; ++i) {
            String string;
            switch (string = stringArray2[i]) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    file2 = file2.getParentFile();
                    continue block8;
                }
                default: {
                    file2 = new File(file2, string);
                }
            }
        }
        return file2;
    }

    @NotNull
    public static List<File> performGlobbing(@NotNull File file) throws IOException {
        String string = file.toString();
        if (GlobMatcher.whenUsingGlobbing(string, true) == null) {
            if (file.exists()) {
                return Collections.singletonList(file);
            }
            return Collections.emptyList();
        }
        if (Utility.areWeOnWindows()) {
            string = string.replace('\\', '/');
        }
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + string);
        List<String> list = Arrays.asList(string.split(Pattern.quote("/")));
        int n = 1;
        while (GlobMatcher.whenUsingGlobbing(Types.join((char)'/', list.subList(0, n)), true) == null) {
            ++n;
        }
        final HashSet hashSet = new HashSet();
        Path path = Paths.get(Types.join((char)'/', list.subList(0, n - 1)), new String[0]);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (pathMatcher.matches(path)) {
                    hashSet.add(path);
                }
                return super.visitFile(path, basicFileAttributes);
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                if (iOException != null) {
                    throw iOException;
                }
                if (pathMatcher.matches(path)) {
                    hashSet.add(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return Types.map(hashSet, Path::toFile);
    }
}

