/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.generics.SynchronizedCollection;
import de.caff.util.EventQueueExceptionListener;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

class EventQueueExceptionWrapper
extends EventQueue {
    private final Collection<EventQueueExceptionListener> listeners = new SynchronizedCollection(new LinkedList());
    private final AtomicBoolean recursionGuard = new AtomicBoolean(false);

    public EventQueueExceptionWrapper() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
    }

    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        block3: {
            try {
                super.dispatchEvent(aWTEvent);
            }
            catch (Throwable throwable) {
                if (this.recursionGuard.getAndSet(true)) break block3;
                for (EventQueueExceptionListener eventQueueExceptionListener : this.listeners) {
                    eventQueueExceptionListener.exceptionOccured(aWTEvent, throwable);
                }
                this.recursionGuard.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventQueueExceptionListener(EventQueueExceptionListener eventQueueExceptionListener) {
        Collection<EventQueueExceptionListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(eventQueueExceptionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventQueueExceptionListener(EventQueueExceptionListener eventQueueExceptionListener) {
        Collection<EventQueueExceptionListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(eventQueueExceptionListener);
        }
    }
}

