/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.util.BitFlag;
import de.caff.util.BitMask;
import de.caff.util.BitMask16;
import de.caff.util.BitMask32;
import de.caff.util.BitMask64;
import de.caff.util.BitMaskUtil;
import de.caff.util.BitSetBitMask;
import de.caff.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class EnumBitMask<E extends Enum<E>> {
    private static final int EXCLUDE_MASK32;
    @NotNull
    private final BitMask bitMask;
    public static final EnumBitMask<?> NONE16;
    public static final EnumBitMask<?> NONE32;
    public static final EnumBitMask<?> NONE64;
    private static final Map<Short, EnumBitMask<?>> CACHE16;
    private static final Map<Integer, EnumBitMask<?>> CACHE32;

    public EnumBitMask(@NotNull BitMask bitMask) {
        this.bitMask = bitMask;
    }

    @NotNull
    public BitMask getBitMask() {
        return this.bitMask;
    }

    public boolean isSet(@NotNull E e) {
        return ((BitFlag)e).isSetIn(this.bitMask);
    }

    public boolean isSetAny(@NotNull EnumBitMask<E> enumBitMask) {
        return !enumBitMask.getBitMask().and(this.getBitMask()).isEmpty();
    }

    public boolean isSetAll(@NotNull EnumBitMask<E> enumBitMask) {
        BitMask bitMask = enumBitMask.getBitMask().and(this.getBitMask());
        return BitMaskUtil.areEqual(bitMask, this.bitMask);
    }

    @SafeVarargs
    public final boolean isSetAny(E ... EArray) {
        for (E e : EArray) {
            if (!this.isSet(e)) continue;
            return true;
        }
        return false;
    }

    public boolean isSetAny(@NotNull Collection<E> collection) {
        for (Enum enum_ : collection) {
            if (!this.isSet(enum_)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isSetAll(E ... EArray) {
        for (E e : EArray) {
            if (this.isSet(e)) continue;
            return false;
        }
        return true;
    }

    public boolean isSetAll(@NotNull Collection<E> collection) {
        for (Enum enum_ : collection) {
            if (this.isSet(enum_)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public EnumBitMask<E> or(@NotNull EnumBitMask<E> enumBitMask) {
        BitMask bitMask = this.bitMask.or(enumBitMask.getBitMask());
        return bitMask.equals(this.bitMask) ? this : new EnumBitMask<E>(bitMask);
    }

    @NotNull
    public EnumBitMask<E> and(@NotNull EnumBitMask<E> enumBitMask) {
        BitMask bitMask = this.bitMask.and(enumBitMask.getBitMask());
        return bitMask.equals(this.bitMask) ? this : new EnumBitMask<E>(bitMask);
    }

    @NotNull
    public EnumBitMask<E> set(@NotNull E e) {
        if (this.isSet(e)) {
            return this;
        }
        return new EnumBitMask<E>(((BitFlag)e).setIn(this.bitMask));
    }

    public EnumBitMask<E> setTo(@NotNull E e, boolean bl) {
        return bl ? this.set(e) : this.clear(e);
    }

    @SafeVarargs
    @NotNull
    public final EnumBitMask<E> setAll(E ... EArray) {
        BitMask bitMask = this.bitMask;
        for (E e : EArray) {
            bitMask = ((BitFlag)e).setIn(bitMask);
        }
        return bitMask.equals(this.bitMask) ? this : new EnumBitMask<E>(bitMask);
    }

    @NotNull
    public EnumBitMask<E> clear(@NotNull E e) {
        if (!this.isSet(e)) {
            return this;
        }
        return new EnumBitMask<E>(((BitFlag)e).clearIn(this.bitMask));
    }

    public EnumBitMask<E> clear(@NotNull EnumBitMask<E> enumBitMask) {
        BitMask bitMask = this.getBitMask().andNot(enumBitMask.getBitMask());
        return bitMask.equals(this.bitMask) ? this : new EnumBitMask<E>(bitMask);
    }

    @SafeVarargs
    @NotNull
    public final EnumBitMask<E> clearAll(E ... EArray) {
        BitMask bitMask = this.bitMask;
        for (E e : EArray) {
            bitMask = ((BitFlag)e).clearIn(bitMask);
        }
        return bitMask.equals(this.bitMask) ? this : new EnumBitMask<E>(bitMask);
    }

    @NotNull
    public EnumBitMask<E> flip(@NotNull E e) {
        return this.isSet(e) ? new EnumBitMask<E>(((BitFlag)e).clearIn(this.bitMask)) : new EnumBitMask<E>(((BitFlag)e).setIn(this.bitMask));
    }

    @SafeVarargs
    @NotNull
    public final EnumBitMask<E> flipAll(E ... EArray) {
        BitMask bitMask = this.bitMask;
        for (E e : EArray) {
            bitMask = ((BitFlag)e).isSetIn(bitMask) ? ((BitFlag)e).clearIn(bitMask) : ((BitFlag)e).setIn(bitMask);
        }
        return new EnumBitMask<E>(bitMask);
    }

    public int getCardinality() {
        return this.bitMask.getCardinality();
    }

    @SafeVarargs
    @NotNull
    public final List<E> getAllSet(E ... EArray) {
        ArrayList<E> arrayList = new ArrayList<E>(EArray.length);
        for (E e : EArray) {
            if (!this.isSet(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public void forEachSet(@NotNull Iterable<E> iterable, @NotNull Consumer<? super E> consumer) {
        for (Enum enum_ : iterable) {
            if (!this.isSet(enum_)) continue;
            consumer.accept(enum_);
        }
    }

    public void forEachUnset(@NotNull Iterable<E> iterable, @NotNull Consumer<? super E> consumer) {
        for (Enum enum_ : iterable) {
            if (this.isSet(enum_)) continue;
            consumer.accept(enum_);
        }
    }

    @NotNull
    public List<E> flags(@NotNull Class<E> clazz) {
        return this.getAllSet((Enum[])clazz.getEnumConstants());
    }

    @NotNull
    public List<E> getAllSet(@NotNull Iterable<E> iterable) {
        LinkedList<Enum> linkedList = new LinkedList<Enum>();
        for (Enum enum_ : iterable) {
            if (!this.isSet(enum_)) continue;
            linkedList.add(enum_);
        }
        return linkedList;
    }

    @SafeVarargs
    @NotNull
    public final List<E> getAllCleared(E ... EArray) {
        ArrayList<E> arrayList = new ArrayList<E>(EArray.length);
        for (E e : EArray) {
            if (this.isSet(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    @NotNull
    public List<E> getAllCleared(@NotNull Iterable<E> iterable) {
        LinkedList<Enum> linkedList = new LinkedList<Enum>();
        for (Enum enum_ : iterable) {
            if (this.isSet(enum_)) continue;
            linkedList.add(enum_);
        }
        return linkedList;
    }

    public int getHighestFlagSet() {
        return this.bitMask.getHighestBitSet();
    }

    public int getLowestFlagSet() {
        return this.bitMask.getLowestBitSet();
    }

    public boolean isEmpty() {
        return this.bitMask.isEmpty();
    }

    @NotNull
    public EnumBitMask<E> cleared() {
        if (this.isEmpty()) {
            return this;
        }
        return new EnumBitMask<E>(this.bitMask.cleared());
    }

    @NotNull
    public <F extends Enum<F>> EnumBitMask<F> cast(@NotNull Class<F> clazz) {
        return this;
    }

    @NotNull
    public EnumBitMask<E> unique16() {
        return EnumBitMask.getCachedEnumBitMask16(this);
    }

    @NotNull
    public EnumBitMask<E> unique32() {
        return EnumBitMask.getCachedEnumBitMask32(this);
    }

    @NotNull
    public EnumBitMask<E> mapFromSet(@NotNull Iterable<E> iterable, @NotNull Predicate<? super E> predicate) {
        EnumBitMask<Enum> enumBitMask = this.cleared();
        for (Enum enum_ : iterable) {
            if (!this.isSet(enum_) || !predicate.test(enum_)) continue;
            enumBitMask = enumBitMask.set(enum_);
        }
        return enumBitMask;
    }

    @NotNull
    public EnumBitMask<E> mapFromUnset(@NotNull Iterable<E> iterable, @NotNull Predicate<? super E> predicate) {
        EnumBitMask<Enum> enumBitMask = this.cleared();
        for (Enum enum_ : iterable) {
            if (this.isSet(enum_) || !predicate.test(enum_)) continue;
            enumBitMask = enumBitMask.set(enum_);
        }
        return enumBitMask;
    }

    @NotNull
    public EnumBitMask<E> map(@NotNull Iterable<E> iterable, @NotNull BiPredicate<? super E, Boolean> biPredicate) {
        EnumBitMask<Enum> enumBitMask = this.cleared();
        for (Enum enum_ : iterable) {
            if (!biPredicate.test(enum_, this.isSet(enum_))) continue;
            enumBitMask = enumBitMask.set(enum_);
        }
        return enumBitMask;
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> toMask(@NotNull F f) {
        return new EnumBitMask(((BitFlag)((Object)f)).setIn(BitSetBitMask.ZERO));
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> toMask16(@NotNull F f) {
        return new EnumBitMask(((BitFlag)((Object)f)).setIn(BitMask16.ZERO)).unique16();
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> toMask32(@NotNull F f) {
        return new EnumBitMask(((BitFlag)((Object)f)).setIn(BitMask32.ZERO)).unique32();
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> toMask64(@NotNull F f) {
        return new EnumBitMask(((BitFlag)((Object)f)).setIn(BitMask64.ZERO));
    }

    @NotNull
    public static <F extends Enum<F>> Set<F> toFlags(@NotNull EnumBitMask<F> enumBitMask, @NotNull Class<F> clazz) {
        EnumSet<F> enumSet = EnumSet.noneOf(clazz);
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (!enumBitMask.isSet(enum_)) continue;
            enumSet.add(enum_);
        }
        return enumSet;
    }

    @NotNull
    private static <F extends Enum<F>> EnumBitMask<F> combine(@NotNull BitMask bitMask, F[] FArray) {
        EnumBitMask<F> enumBitMask = new EnumBitMask<F>(bitMask);
        for (F f : FArray) {
            enumBitMask = enumBitMask.set(f);
        }
        return enumBitMask;
    }

    @NotNull
    private static <F extends Enum<F>> EnumBitMask<F> combine(@NotNull BitMask bitMask, @NotNull Iterable<F> iterable) {
        EnumBitMask<Enum> enumBitMask = new EnumBitMask<Enum>(bitMask);
        for (Enum enum_ : iterable) {
            enumBitMask = enumBitMask.set(enum_);
        }
        return enumBitMask;
    }

    @SafeVarargs
    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine16(F ... FArray) {
        return EnumBitMask.combine((BitMask)BitMask16.ZERO, FArray);
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine16(@NotNull Collection<F> collection) {
        return EnumBitMask.combine((BitMask)BitMask16.ZERO, collection);
    }

    @SafeVarargs
    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine32(F ... FArray) {
        return EnumBitMask.combine((BitMask)BitMask32.ZERO, FArray);
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine32(@NotNull Collection<F> collection) {
        return EnumBitMask.combine((BitMask)BitMask32.ZERO, collection);
    }

    @SafeVarargs
    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine64(F ... FArray) {
        return EnumBitMask.combine((BitMask)BitMask64.ZERO, FArray);
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine64(@NotNull Collection<F> collection) {
        return EnumBitMask.combine((BitMask)BitMask64.ZERO, collection);
    }

    @SafeVarargs
    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine(F ... FArray) {
        return EnumBitMask.combine((BitMask)BitSetBitMask.ZERO, FArray);
    }

    @NotNull
    public static <F extends Enum<F>> EnumBitMask<F> combine(@NotNull Iterable<F> iterable) {
        return EnumBitMask.combine((BitMask)BitSetBitMask.ZERO, iterable);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EnumBitMask enumBitMask = (EnumBitMask)object;
        return this.bitMask.equals(enumBitMask.bitMask);
    }

    public int hashCode() {
        return this.bitMask.hashCode();
    }

    public String toString() {
        return this.bitMask.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends Enum<T>> EnumBitMask<T> get16(int n, @NotNull Class<T> clazz) {
        Short s = (short)n;
        Map<Short, EnumBitMask<?>> map = CACHE16;
        synchronized (map) {
            EnumBitMask<Object> enumBitMask = CACHE16.get(s);
            if (enumBitMask == null) {
                enumBitMask = new EnumBitMask(new BitMask16(n));
                CACHE16.put(s, enumBitMask);
            }
            return enumBitMask.cast(clazz);
        }
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<T>> EnumBitMask<T> get16(T ... TArray) {
        EnumBitMask enumBitMask = EnumBitMask.combine16(TArray);
        return EnumBitMask.getCachedEnumBitMask16(enumBitMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static <T extends Enum<T>> EnumBitMask<T> getCachedEnumBitMask16(@NotNull EnumBitMask<T> enumBitMask) {
        Short s = (short)enumBitMask.getBitMask().low32();
        Map<Short, EnumBitMask<?>> map = CACHE16;
        synchronized (map) {
            EnumBitMask<?> enumBitMask2 = CACHE16.get(s);
            if (enumBitMask2 == null) {
                CACHE16.put(s, enumBitMask);
                return enumBitMask;
            }
            return enumBitMask2;
        }
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<T>> EnumBitMask<T> get16(@NotNull EnumBitMask<T> enumBitMask, T ... TArray) {
        for (T t : TArray) {
            enumBitMask = enumBitMask.set(t);
        }
        return EnumBitMask.getCachedEnumBitMask16(enumBitMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends Enum<T>> EnumBitMask<T> get32(@NotNull Integer n, @NotNull Class<T> clazz) {
        Map<Integer, EnumBitMask<?>> map = CACHE32;
        synchronized (map) {
            EnumBitMask<Object> enumBitMask = CACHE32.get(n);
            if (enumBitMask == null) {
                enumBitMask = new EnumBitMask(new BitMask32(n));
                if ((n & EXCLUDE_MASK32) == 0) {
                    CACHE32.put(n, enumBitMask);
                }
            }
            return enumBitMask.cast(clazz);
        }
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<T>> EnumBitMask<T> get32(T ... TArray) {
        EnumBitMask enumBitMask = EnumBitMask.combine32(TArray);
        return EnumBitMask.getCachedEnumBitMask32(enumBitMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static <T extends Enum<T>> EnumBitMask<T> getCachedEnumBitMask32(@NotNull EnumBitMask<T> enumBitMask) {
        Integer n = enumBitMask.getBitMask().low32();
        Map<Integer, EnumBitMask<?>> map = CACHE32;
        synchronized (map) {
            EnumBitMask<?> enumBitMask2 = CACHE32.get(n);
            if (enumBitMask2 == null) {
                if ((n & EXCLUDE_MASK32) == 0) {
                    CACHE32.put(n, enumBitMask);
                }
                return enumBitMask;
            }
            return enumBitMask2;
        }
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<T>> EnumBitMask<T> get32(@NotNull EnumBitMask<T> enumBitMask, T ... TArray) {
        for (T t : TArray) {
            enumBitMask = enumBitMask.set(t);
        }
        return EnumBitMask.getCachedEnumBitMask32(enumBitMask);
    }

    static {
        int n;
        int n2;
        EXCLUDE_MASK32 = -1 << Utility.getIntParameter("ebm.mask32.shift", 16);
        NONE16 = new EnumBitMask(BitMask16.ZERO);
        NONE32 = new EnumBitMask(BitMask32.ZERO);
        NONE64 = new EnumBitMask(BitMask64.ZERO);
        CACHE16 = new HashMap();
        CACHE16.put((short)0, NONE16);
        CACHE16.put((short)-1, new EnumBitMask(new BitMask16(-1)));
        for (n2 = 1; n2 < 16; ++n2) {
            n = (1 << n2) - 1;
            CACHE16.put((short)n, new EnumBitMask(new BitMask16(n)));
        }
        CACHE32 = new HashMap();
        CACHE32.put(0, NONE32);
        CACHE32.put(-1, new EnumBitMask(new BitMask32(-1)));
        for (n2 = 1; n2 < 32; ++n2) {
            n = (1 << n2) - 1;
            CACHE32.put(n, new EnumBitMask(new BitMask32(n)));
        }
    }

    private static enum Potemkin implements BitFlag
    {


        @Override
        public boolean isSetIn(@NotNull BitMask bitMask) {
            return false;
        }

        @Override
        @NotNull
        public BitMask setIn(@NotNull BitMask bitMask) {
            return bitMask;
        }

        @Override
        @NotNull
        public BitMask clearIn(@NotNull BitMask bitMask) {
            return bitMask;
        }
    }
}

