/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private final OutputStream wrapped;
    private long count = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        this.wrapped = outputStream;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(int n) throws IOException {
        this.wrapped.write(n);
        ++this.count;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void write(@NotNull byte[] byArray) throws IOException {
        this.wrapped.write(byArray);
        this.count += (long)byArray.length;
    }

    @Override
    public void write(@NotNull byte[] byArray, int n, int n2) throws IOException {
        this.wrapped.write(byArray, n, n2);
        this.count += (long)n2;
    }
}

