/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    @NotNull
    private final InputStream wrapped;
    private long position;
    private long mark = -1L;

    public CountingInputStream(@NotNull InputStream inputStream) {
        this(inputStream, 0L);
    }

    public CountingInputStream(@NotNull InputStream inputStream, long l) {
        this.wrapped = inputStream;
        this.position = l;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public int read() throws IOException {
        int n = this.wrapped.read();
        if (n >= 0) {
            ++this.position;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] byArray) throws IOException {
        int n = this.wrapped.read(byArray);
        if (n > 0) {
            this.position += (long)n;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.wrapped.read(byArray, n, n2);
        if (n3 > 0) {
            this.position += (long)n3;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.wrapped.skip(l);
        if (l2 > 0L) {
            this.position += l2;
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.wrapped.mark(n);
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapped.reset();
        this.position = this.mark;
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }
}

