/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.util.debug.Debug;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ColorDecoder {
    private static final Pattern COMMA_SEPARATOR = Pattern.compile(Pattern.quote(","));
    private static final Map<String, Color> nameToColorMappingX11 = new HashMap<String, Color>();
    private static final Map<String, Color> nameToColorMappingHTML = new HashMap<String, Color>();
    public static final Domain DOMAIN_X11;
    public static final Domain DOMAIN_HTML;
    public static final Iterable<Domain> DOMAINS_HTML_FIRST;
    public static final Iterable<Domain> DOMAINS_X11_FIRST;

    @Nullable
    public static Color decode(@NotNull String string) {
        return ColorDecoder.decode(string, false);
    }

    @Nullable
    public static Color decode(@NotNull String string, boolean bl) {
        return ColorDecoder.decode(string, bl ? DOMAINS_HTML_FIRST : DOMAINS_X11_FIRST);
    }

    private static int decodeColorComponent(@NotNull String string) throws NumberFormatException {
        int n = Integer.decode(string.trim());
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    @Nullable
    public static Color decode(@NotNull String string, Domain domain) {
        return ColorDecoder.decode(string, new Domain[]{domain});
    }

    @Nullable
    public static Color decode(@NotNull String string, Domain ... domainArray) {
        return ColorDecoder.decode(string, Types.asList((Object[])domainArray));
    }

    @Nullable
    public static Color decode(@NotNull String string, @NotNull Iterable<? extends Domain> iterable) {
        if (!(string = string.trim().toLowerCase()).isEmpty()) {
            char c = string.charAt(0);
            if (Character.isDigit(c)) {
                return Color.decode(string);
            }
            if (c == '#') {
                Object n2;
                String string2 = string.substring(1);
                if (string2.length() == 3) {
                    string2 = String.valueOf(string2.charAt(0)) + string2.charAt(0) + string2.charAt(1) + string2.charAt(1) + string2.charAt(2) + string2.charAt(2);
                }
                int n = 255;
                if (string2.length() == 8) {
                    n2 = string2.substring(0, 2);
                    string2 = string2.substring(2);
                    try {
                        n = Integer.valueOf((String)n2, 16);
                    }
                    catch (NumberFormatException n3) {
                        Debug.error("Cannot determine alpha value from %0", n2);
                    }
                }
                if (string2.length() == 6) {
                    n2 = Color.decode("0x" + string2);
                    return n == 255 ? n2 : new Color(((Color)n2).getRed(), ((Color)n2).getGreen(), ((Color)n2).getBlue(), n);
                }
                Debug.error("Hashed color description '%0' is not decodable: expected 6 (3) hex digits for normal colors, and 8 digits for colors with aloha value!", string);
            } else if (string.startsWith("rgb(")) {
                if (string.endsWith(")")) {
                    String[] stringArray = COMMA_SEPARATOR.split(string.substring(4, string.length() - 1));
                    if (stringArray.length == 3) {
                        try {
                            int numberFormatException = ColorDecoder.decodeColorComponent(stringArray[0]);
                            int n4 = ColorDecoder.decodeColorComponent(stringArray[1]);
                            int n5 = ColorDecoder.decodeColorComponent(stringArray[2]);
                            return new Color(numberFormatException, n4, n5);
                        }
                        catch (NumberFormatException n) {
                            Debug.error("rgb(r,g,b) decoding failed with exception %0", n);
                        }
                    } else {
                        Debug.error("rgb(r,g,b) color definition contains " + stringArray.length + " components and not 3!");
                    }
                } else {
                    Debug.error("Color definition starts with 'rgb(', but does not end with ')': '" + string + "'");
                }
            } else if (string.startsWith("rgba(")) {
                if (string.endsWith(")")) {
                    String[] stringArray = COMMA_SEPARATOR.split(string.substring(5, string.length() - 1));
                    if (stringArray.length == 4) {
                        try {
                            int numberFormatException = ColorDecoder.decodeColorComponent(stringArray[0]);
                            int color = ColorDecoder.decodeColorComponent(stringArray[1]);
                            int n = ColorDecoder.decodeColorComponent(stringArray[2]);
                            int n2 = ColorDecoder.decodeColorComponent(stringArray[3]);
                            return new Color(numberFormatException, color, n, n2);
                        }
                        catch (NumberFormatException domain) {
                            Debug.error("rgba(r,g,b,a) decoding failed with exception %0", domain);
                        }
                    } else {
                        Debug.error("rgba(r,g,b,a) color definition contains " + stringArray.length + " components and not 4!");
                    }
                } else {
                    Debug.error("Color definition starts with 'rgba(', but does not end with ')': '" + string + "'");
                }
            } else {
                for (Domain domain : iterable) {
                    Color color = domain.mapName(string);
                    if (color == null) continue;
                    return color;
                }
                Debug.error("Color name '%0' is not known in the given domain(s)!", string);
            }
        } else {
            Debug.error("Cannot match empty color description!");
        }
        return null;
    }

    static {
        nameToColorMappingX11.put("aliceblue", new Color(240, 248, 255));
        nameToColorMappingX11.put("antiquewhite", new Color(250, 235, 215));
        nameToColorMappingX11.put("antiquewhite1", new Color(255, 239, 219));
        nameToColorMappingX11.put("antiquewhite2", new Color(238, 223, 204));
        nameToColorMappingX11.put("antiquewhite3", new Color(205, 192, 176));
        nameToColorMappingX11.put("antiquewhite4", new Color(139, 131, 120));
        nameToColorMappingX11.put("aquamarine", new Color(127, 255, 212));
        nameToColorMappingX11.put("aquamarine1", new Color(127, 255, 212));
        nameToColorMappingX11.put("aquamarine2", new Color(118, 238, 198));
        nameToColorMappingX11.put("aquamarine3", new Color(102, 205, 170));
        nameToColorMappingX11.put("aquamarine4", new Color(69, 139, 116));
        nameToColorMappingX11.put("azure", new Color(240, 255, 255));
        nameToColorMappingX11.put("azure1", new Color(240, 255, 255));
        nameToColorMappingX11.put("azure2", new Color(224, 238, 238));
        nameToColorMappingX11.put("azure3", new Color(193, 205, 205));
        nameToColorMappingX11.put("azure4", new Color(131, 139, 139));
        nameToColorMappingX11.put("beige", new Color(245, 245, 220));
        nameToColorMappingX11.put("bisque", new Color(255, 228, 196));
        nameToColorMappingX11.put("bisque1", new Color(255, 228, 196));
        nameToColorMappingX11.put("bisque2", new Color(238, 213, 183));
        nameToColorMappingX11.put("bisque3", new Color(205, 183, 158));
        nameToColorMappingX11.put("bisque4", new Color(139, 125, 107));
        nameToColorMappingX11.put("blanchedalmond", new Color(255, 235, 205));
        nameToColorMappingX11.put("blue", new Color(0, 0, 255));
        nameToColorMappingX11.put("blue1", new Color(0, 0, 255));
        nameToColorMappingX11.put("blue2", new Color(0, 0, 238));
        nameToColorMappingX11.put("blue3", new Color(0, 0, 205));
        nameToColorMappingX11.put("blue4", new Color(0, 0, 139));
        nameToColorMappingX11.put("blueviolet", new Color(138, 43, 226));
        nameToColorMappingX11.put("brown", new Color(165, 42, 42));
        nameToColorMappingX11.put("brown1", new Color(255, 64, 64));
        nameToColorMappingX11.put("brown2", new Color(238, 59, 59));
        nameToColorMappingX11.put("brown3", new Color(205, 51, 51));
        nameToColorMappingX11.put("brown4", new Color(139, 35, 35));
        nameToColorMappingX11.put("burlywood", new Color(222, 184, 135));
        nameToColorMappingX11.put("burlywood1", new Color(255, 211, 155));
        nameToColorMappingX11.put("burlywood2", new Color(238, 197, 145));
        nameToColorMappingX11.put("burlywood3", new Color(205, 170, 125));
        nameToColorMappingX11.put("burlywood4", new Color(139, 115, 85));
        nameToColorMappingX11.put("cadetblue", new Color(95, 158, 160));
        nameToColorMappingX11.put("cadetblue1", new Color(152, 245, 255));
        nameToColorMappingX11.put("cadetblue2", new Color(142, 229, 238));
        nameToColorMappingX11.put("cadetblue3", new Color(122, 197, 205));
        nameToColorMappingX11.put("cadetblue4", new Color(83, 134, 139));
        nameToColorMappingX11.put("chartreuse", new Color(127, 255, 0));
        nameToColorMappingX11.put("chartreuse1", new Color(127, 255, 0));
        nameToColorMappingX11.put("chartreuse2", new Color(118, 238, 0));
        nameToColorMappingX11.put("chartreuse3", new Color(102, 205, 0));
        nameToColorMappingX11.put("chartreuse4", new Color(69, 139, 0));
        nameToColorMappingX11.put("chocolate", new Color(210, 105, 30));
        nameToColorMappingX11.put("chocolate1", new Color(255, 127, 36));
        nameToColorMappingX11.put("chocolate2", new Color(238, 118, 33));
        nameToColorMappingX11.put("chocolate3", new Color(205, 102, 29));
        nameToColorMappingX11.put("chocolate4", new Color(139, 69, 19));
        nameToColorMappingX11.put("coral", new Color(255, 127, 80));
        nameToColorMappingX11.put("coral1", new Color(255, 114, 86));
        nameToColorMappingX11.put("coral2", new Color(238, 106, 80));
        nameToColorMappingX11.put("coral3", new Color(205, 91, 69));
        nameToColorMappingX11.put("coral4", new Color(139, 62, 47));
        nameToColorMappingX11.put("cornflowerblue", new Color(100, 149, 237));
        nameToColorMappingX11.put("cornsilk", new Color(255, 248, 220));
        nameToColorMappingX11.put("cornsilk1", new Color(255, 248, 220));
        nameToColorMappingX11.put("cornsilk2", new Color(238, 232, 205));
        nameToColorMappingX11.put("cornsilk3", new Color(205, 200, 177));
        nameToColorMappingX11.put("cornsilk4", new Color(139, 136, 120));
        nameToColorMappingX11.put("cyan", new Color(0, 255, 255));
        nameToColorMappingX11.put("cyan1", new Color(0, 255, 255));
        nameToColorMappingX11.put("cyan2", new Color(0, 238, 238));
        nameToColorMappingX11.put("cyan3", new Color(0, 205, 205));
        nameToColorMappingX11.put("cyan4", new Color(0, 139, 139));
        nameToColorMappingX11.put("darkblue", new Color(0, 0, 139));
        nameToColorMappingX11.put("darkcyan", new Color(0, 139, 139));
        nameToColorMappingX11.put("darkgoldenrod", new Color(184, 134, 11));
        nameToColorMappingX11.put("darkgoldenrod1", new Color(255, 185, 15));
        nameToColorMappingX11.put("darkgoldenrod2", new Color(238, 173, 14));
        nameToColorMappingX11.put("darkgoldenrod3", new Color(205, 149, 12));
        nameToColorMappingX11.put("darkgoldenrod4", new Color(139, 101, 8));
        nameToColorMappingX11.put("darkgreen", new Color(0, 100, 0));
        nameToColorMappingX11.put("darkkhaki", new Color(189, 183, 107));
        nameToColorMappingX11.put("darkmagenta", new Color(139, 0, 139));
        nameToColorMappingX11.put("darkolivegreen", new Color(85, 107, 47));
        nameToColorMappingX11.put("darkolivegreen1", new Color(202, 255, 112));
        nameToColorMappingX11.put("darkolivegreen2", new Color(188, 238, 104));
        nameToColorMappingX11.put("darkolivegreen3", new Color(162, 205, 90));
        nameToColorMappingX11.put("darkolivegreen4", new Color(110, 139, 61));
        nameToColorMappingX11.put("darkorange", new Color(255, 140, 0));
        nameToColorMappingX11.put("darkorange1", new Color(255, 127, 0));
        nameToColorMappingX11.put("darkorange2", new Color(238, 118, 0));
        nameToColorMappingX11.put("darkorange3", new Color(205, 102, 0));
        nameToColorMappingX11.put("darkorange4", new Color(139, 69, 0));
        nameToColorMappingX11.put("darkorchid", new Color(153, 50, 204));
        nameToColorMappingX11.put("darkorchid1", new Color(191, 62, 255));
        nameToColorMappingX11.put("darkorchid2", new Color(178, 58, 238));
        nameToColorMappingX11.put("darkorchid3", new Color(154, 50, 205));
        nameToColorMappingX11.put("darkorchid4", new Color(104, 34, 139));
        nameToColorMappingX11.put("darkred", new Color(139, 0, 0));
        nameToColorMappingX11.put("darksalmon", new Color(233, 150, 122));
        nameToColorMappingX11.put("darkseagreen", new Color(143, 188, 143));
        nameToColorMappingX11.put("darkseagreen1", new Color(193, 255, 193));
        nameToColorMappingX11.put("darkseagreen2", new Color(180, 238, 180));
        nameToColorMappingX11.put("darkseagreen3", new Color(155, 205, 155));
        nameToColorMappingX11.put("darkseagreen4", new Color(105, 139, 105));
        nameToColorMappingX11.put("darkslateblue", new Color(72, 61, 139));
        nameToColorMappingX11.put("darkslategray", new Color(47, 79, 79));
        nameToColorMappingX11.put("darkslategray1", new Color(151, 255, 255));
        nameToColorMappingX11.put("darkslategray2", new Color(141, 238, 238));
        nameToColorMappingX11.put("darkslategray3", new Color(121, 205, 205));
        nameToColorMappingX11.put("darkslategray4", new Color(82, 139, 139));
        nameToColorMappingX11.put("darkslategrey", new Color(47, 79, 79));
        nameToColorMappingX11.put("darkturquoise", new Color(0, 206, 209));
        nameToColorMappingX11.put("darkviolet", new Color(148, 0, 211));
        nameToColorMappingX11.put("deeppink", new Color(255, 20, 147));
        nameToColorMappingX11.put("deeppink1", new Color(255, 20, 147));
        nameToColorMappingX11.put("deeppink2", new Color(238, 18, 137));
        nameToColorMappingX11.put("deeppink3", new Color(205, 16, 118));
        nameToColorMappingX11.put("deeppink4", new Color(139, 10, 80));
        nameToColorMappingX11.put("deepskyblue", new Color(0, 191, 255));
        nameToColorMappingX11.put("deepskyblue1", new Color(0, 191, 255));
        nameToColorMappingX11.put("deepskyblue2", new Color(0, 178, 238));
        nameToColorMappingX11.put("deepskyblue3", new Color(0, 154, 205));
        nameToColorMappingX11.put("deepskyblue4", new Color(0, 104, 139));
        nameToColorMappingX11.put("dimgray", new Color(105, 105, 105));
        nameToColorMappingX11.put("dimgrey", new Color(105, 105, 105));
        nameToColorMappingX11.put("dodgerblue", new Color(30, 144, 255));
        nameToColorMappingX11.put("dodgerblue1", new Color(30, 144, 255));
        nameToColorMappingX11.put("dodgerblue2", new Color(28, 134, 238));
        nameToColorMappingX11.put("dodgerblue3", new Color(24, 116, 205));
        nameToColorMappingX11.put("dodgerblue4", new Color(16, 78, 139));
        nameToColorMappingX11.put("firebrick", new Color(178, 34, 34));
        nameToColorMappingX11.put("firebrick1", new Color(255, 48, 48));
        nameToColorMappingX11.put("firebrick2", new Color(238, 44, 44));
        nameToColorMappingX11.put("firebrick3", new Color(205, 38, 38));
        nameToColorMappingX11.put("firebrick4", new Color(139, 26, 26));
        nameToColorMappingX11.put("floralwhite", new Color(255, 250, 240));
        nameToColorMappingX11.put("forestgreen", new Color(34, 139, 34));
        nameToColorMappingX11.put("gainsboro", new Color(220, 220, 220));
        nameToColorMappingX11.put("ghostwhite", new Color(248, 248, 255));
        nameToColorMappingX11.put("gold", new Color(255, 215, 0));
        nameToColorMappingX11.put("gold1", new Color(255, 215, 0));
        nameToColorMappingX11.put("gold2", new Color(238, 201, 0));
        nameToColorMappingX11.put("gold3", new Color(205, 173, 0));
        nameToColorMappingX11.put("gold4", new Color(139, 117, 0));
        nameToColorMappingX11.put("goldenrod", new Color(218, 165, 32));
        nameToColorMappingX11.put("goldenrod1", new Color(255, 193, 37));
        nameToColorMappingX11.put("goldenrod2", new Color(238, 180, 34));
        nameToColorMappingX11.put("goldenrod3", new Color(205, 155, 29));
        nameToColorMappingX11.put("goldenrod4", new Color(139, 105, 20));
        nameToColorMappingX11.put("gray", new Color(190, 190, 190));
        nameToColorMappingX11.put("gray0", new Color(0, 0, 0));
        nameToColorMappingX11.put("gray1", new Color(3, 3, 3));
        nameToColorMappingX11.put("gray10", new Color(26, 26, 26));
        nameToColorMappingX11.put("gray100", new Color(255, 255, 255));
        nameToColorMappingX11.put("gray11", new Color(28, 28, 28));
        nameToColorMappingX11.put("gray12", new Color(31, 31, 31));
        nameToColorMappingX11.put("gray13", new Color(33, 33, 33));
        nameToColorMappingX11.put("gray14", new Color(36, 36, 36));
        nameToColorMappingX11.put("gray15", new Color(38, 38, 38));
        nameToColorMappingX11.put("gray16", new Color(41, 41, 41));
        nameToColorMappingX11.put("gray17", new Color(43, 43, 43));
        nameToColorMappingX11.put("gray18", new Color(46, 46, 46));
        nameToColorMappingX11.put("gray19", new Color(48, 48, 48));
        nameToColorMappingX11.put("gray2", new Color(5, 5, 5));
        nameToColorMappingX11.put("gray20", new Color(51, 51, 51));
        nameToColorMappingX11.put("gray21", new Color(54, 54, 54));
        nameToColorMappingX11.put("gray22", new Color(56, 56, 56));
        nameToColorMappingX11.put("gray23", new Color(59, 59, 59));
        nameToColorMappingX11.put("gray24", new Color(61, 61, 61));
        nameToColorMappingX11.put("gray25", new Color(64, 64, 64));
        nameToColorMappingX11.put("gray26", new Color(66, 66, 66));
        nameToColorMappingX11.put("gray27", new Color(69, 69, 69));
        nameToColorMappingX11.put("gray28", new Color(71, 71, 71));
        nameToColorMappingX11.put("gray29", new Color(74, 74, 74));
        nameToColorMappingX11.put("gray3", new Color(8, 8, 8));
        nameToColorMappingX11.put("gray30", new Color(77, 77, 77));
        nameToColorMappingX11.put("gray31", new Color(79, 79, 79));
        nameToColorMappingX11.put("gray32", new Color(82, 82, 82));
        nameToColorMappingX11.put("gray33", new Color(84, 84, 84));
        nameToColorMappingX11.put("gray34", new Color(87, 87, 87));
        nameToColorMappingX11.put("gray35", new Color(89, 89, 89));
        nameToColorMappingX11.put("gray36", new Color(92, 92, 92));
        nameToColorMappingX11.put("gray37", new Color(94, 94, 94));
        nameToColorMappingX11.put("gray38", new Color(97, 97, 97));
        nameToColorMappingX11.put("gray39", new Color(99, 99, 99));
        nameToColorMappingX11.put("gray4", new Color(10, 10, 10));
        nameToColorMappingX11.put("gray40", new Color(102, 102, 102));
        nameToColorMappingX11.put("gray41", new Color(105, 105, 105));
        nameToColorMappingX11.put("gray42", new Color(107, 107, 107));
        nameToColorMappingX11.put("gray43", new Color(110, 110, 110));
        nameToColorMappingX11.put("gray44", new Color(112, 112, 112));
        nameToColorMappingX11.put("gray45", new Color(115, 115, 115));
        nameToColorMappingX11.put("gray46", new Color(117, 117, 117));
        nameToColorMappingX11.put("gray47", new Color(120, 120, 120));
        nameToColorMappingX11.put("gray48", new Color(122, 122, 122));
        nameToColorMappingX11.put("gray49", new Color(125, 125, 125));
        nameToColorMappingX11.put("gray5", new Color(13, 13, 13));
        nameToColorMappingX11.put("gray50", new Color(127, 127, 127));
        nameToColorMappingX11.put("gray51", new Color(130, 130, 130));
        nameToColorMappingX11.put("gray52", new Color(133, 133, 133));
        nameToColorMappingX11.put("gray53", new Color(135, 135, 135));
        nameToColorMappingX11.put("gray54", new Color(138, 138, 138));
        nameToColorMappingX11.put("gray55", new Color(140, 140, 140));
        nameToColorMappingX11.put("gray56", new Color(143, 143, 143));
        nameToColorMappingX11.put("gray57", new Color(145, 145, 145));
        nameToColorMappingX11.put("gray58", new Color(148, 148, 148));
        nameToColorMappingX11.put("gray59", new Color(150, 150, 150));
        nameToColorMappingX11.put("gray6", new Color(15, 15, 15));
        nameToColorMappingX11.put("gray60", new Color(153, 153, 153));
        nameToColorMappingX11.put("gray61", new Color(156, 156, 156));
        nameToColorMappingX11.put("gray62", new Color(158, 158, 158));
        nameToColorMappingX11.put("gray63", new Color(161, 161, 161));
        nameToColorMappingX11.put("gray64", new Color(163, 163, 163));
        nameToColorMappingX11.put("gray65", new Color(166, 166, 166));
        nameToColorMappingX11.put("gray66", new Color(168, 168, 168));
        nameToColorMappingX11.put("gray67", new Color(171, 171, 171));
        nameToColorMappingX11.put("gray68", new Color(173, 173, 173));
        nameToColorMappingX11.put("gray69", new Color(176, 176, 176));
        nameToColorMappingX11.put("gray7", new Color(18, 18, 18));
        nameToColorMappingX11.put("gray70", new Color(179, 179, 179));
        nameToColorMappingX11.put("gray71", new Color(181, 181, 181));
        nameToColorMappingX11.put("gray72", new Color(184, 184, 184));
        nameToColorMappingX11.put("gray73", new Color(186, 186, 186));
        nameToColorMappingX11.put("gray74", new Color(189, 189, 189));
        nameToColorMappingX11.put("gray75", new Color(191, 191, 191));
        nameToColorMappingX11.put("gray76", new Color(194, 194, 194));
        nameToColorMappingX11.put("gray77", new Color(196, 196, 196));
        nameToColorMappingX11.put("gray78", new Color(199, 199, 199));
        nameToColorMappingX11.put("gray79", new Color(201, 201, 201));
        nameToColorMappingX11.put("gray8", new Color(20, 20, 20));
        nameToColorMappingX11.put("gray80", new Color(204, 204, 204));
        nameToColorMappingX11.put("gray81", new Color(207, 207, 207));
        nameToColorMappingX11.put("gray82", new Color(209, 209, 209));
        nameToColorMappingX11.put("gray83", new Color(212, 212, 212));
        nameToColorMappingX11.put("gray84", new Color(214, 214, 214));
        nameToColorMappingX11.put("gray85", new Color(217, 217, 217));
        nameToColorMappingX11.put("gray86", new Color(219, 219, 219));
        nameToColorMappingX11.put("gray87", new Color(222, 222, 222));
        nameToColorMappingX11.put("gray88", new Color(224, 224, 224));
        nameToColorMappingX11.put("gray89", new Color(227, 227, 227));
        nameToColorMappingX11.put("gray9", new Color(23, 23, 23));
        nameToColorMappingX11.put("gray90", new Color(229, 229, 229));
        nameToColorMappingX11.put("gray91", new Color(232, 232, 232));
        nameToColorMappingX11.put("gray92", new Color(235, 235, 235));
        nameToColorMappingX11.put("gray93", new Color(237, 237, 237));
        nameToColorMappingX11.put("gray94", new Color(240, 240, 240));
        nameToColorMappingX11.put("gray95", new Color(242, 242, 242));
        nameToColorMappingX11.put("gray96", new Color(245, 245, 245));
        nameToColorMappingX11.put("gray97", new Color(247, 247, 247));
        nameToColorMappingX11.put("gray98", new Color(250, 250, 250));
        nameToColorMappingX11.put("gray99", new Color(252, 252, 252));
        nameToColorMappingX11.put("green", new Color(0, 255, 0));
        nameToColorMappingX11.put("green1", new Color(0, 255, 0));
        nameToColorMappingX11.put("green2", new Color(0, 238, 0));
        nameToColorMappingX11.put("green3", new Color(0, 205, 0));
        nameToColorMappingX11.put("green4", new Color(0, 139, 0));
        nameToColorMappingX11.put("greenyellow", new Color(173, 255, 47));
        nameToColorMappingX11.put("grey", new Color(190, 190, 190));
        nameToColorMappingX11.put("grey0", new Color(0, 0, 0));
        nameToColorMappingX11.put("grey1", new Color(3, 3, 3));
        nameToColorMappingX11.put("grey10", new Color(26, 26, 26));
        nameToColorMappingX11.put("grey100", new Color(255, 255, 255));
        nameToColorMappingX11.put("grey11", new Color(28, 28, 28));
        nameToColorMappingX11.put("grey12", new Color(31, 31, 31));
        nameToColorMappingX11.put("grey13", new Color(33, 33, 33));
        nameToColorMappingX11.put("grey14", new Color(36, 36, 36));
        nameToColorMappingX11.put("grey15", new Color(38, 38, 38));
        nameToColorMappingX11.put("grey16", new Color(41, 41, 41));
        nameToColorMappingX11.put("grey17", new Color(43, 43, 43));
        nameToColorMappingX11.put("grey18", new Color(46, 46, 46));
        nameToColorMappingX11.put("grey19", new Color(48, 48, 48));
        nameToColorMappingX11.put("grey2", new Color(5, 5, 5));
        nameToColorMappingX11.put("grey20", new Color(51, 51, 51));
        nameToColorMappingX11.put("grey21", new Color(54, 54, 54));
        nameToColorMappingX11.put("grey22", new Color(56, 56, 56));
        nameToColorMappingX11.put("grey23", new Color(59, 59, 59));
        nameToColorMappingX11.put("grey24", new Color(61, 61, 61));
        nameToColorMappingX11.put("grey25", new Color(64, 64, 64));
        nameToColorMappingX11.put("grey26", new Color(66, 66, 66));
        nameToColorMappingX11.put("grey27", new Color(69, 69, 69));
        nameToColorMappingX11.put("grey28", new Color(71, 71, 71));
        nameToColorMappingX11.put("grey29", new Color(74, 74, 74));
        nameToColorMappingX11.put("grey3", new Color(8, 8, 8));
        nameToColorMappingX11.put("grey30", new Color(77, 77, 77));
        nameToColorMappingX11.put("grey31", new Color(79, 79, 79));
        nameToColorMappingX11.put("grey32", new Color(82, 82, 82));
        nameToColorMappingX11.put("grey33", new Color(84, 84, 84));
        nameToColorMappingX11.put("grey34", new Color(87, 87, 87));
        nameToColorMappingX11.put("grey35", new Color(89, 89, 89));
        nameToColorMappingX11.put("grey36", new Color(92, 92, 92));
        nameToColorMappingX11.put("grey37", new Color(94, 94, 94));
        nameToColorMappingX11.put("grey38", new Color(97, 97, 97));
        nameToColorMappingX11.put("grey39", new Color(99, 99, 99));
        nameToColorMappingX11.put("grey4", new Color(10, 10, 10));
        nameToColorMappingX11.put("grey40", new Color(102, 102, 102));
        nameToColorMappingX11.put("grey41", new Color(105, 105, 105));
        nameToColorMappingX11.put("grey42", new Color(107, 107, 107));
        nameToColorMappingX11.put("grey43", new Color(110, 110, 110));
        nameToColorMappingX11.put("grey44", new Color(112, 112, 112));
        nameToColorMappingX11.put("grey45", new Color(115, 115, 115));
        nameToColorMappingX11.put("grey46", new Color(117, 117, 117));
        nameToColorMappingX11.put("grey47", new Color(120, 120, 120));
        nameToColorMappingX11.put("grey48", new Color(122, 122, 122));
        nameToColorMappingX11.put("grey49", new Color(125, 125, 125));
        nameToColorMappingX11.put("grey5", new Color(13, 13, 13));
        nameToColorMappingX11.put("grey50", new Color(127, 127, 127));
        nameToColorMappingX11.put("grey51", new Color(130, 130, 130));
        nameToColorMappingX11.put("grey52", new Color(133, 133, 133));
        nameToColorMappingX11.put("grey53", new Color(135, 135, 135));
        nameToColorMappingX11.put("grey54", new Color(138, 138, 138));
        nameToColorMappingX11.put("grey55", new Color(140, 140, 140));
        nameToColorMappingX11.put("grey56", new Color(143, 143, 143));
        nameToColorMappingX11.put("grey57", new Color(145, 145, 145));
        nameToColorMappingX11.put("grey58", new Color(148, 148, 148));
        nameToColorMappingX11.put("grey59", new Color(150, 150, 150));
        nameToColorMappingX11.put("grey6", new Color(15, 15, 15));
        nameToColorMappingX11.put("grey60", new Color(153, 153, 153));
        nameToColorMappingX11.put("grey61", new Color(156, 156, 156));
        nameToColorMappingX11.put("grey62", new Color(158, 158, 158));
        nameToColorMappingX11.put("grey63", new Color(161, 161, 161));
        nameToColorMappingX11.put("grey64", new Color(163, 163, 163));
        nameToColorMappingX11.put("grey65", new Color(166, 166, 166));
        nameToColorMappingX11.put("grey66", new Color(168, 168, 168));
        nameToColorMappingX11.put("grey67", new Color(171, 171, 171));
        nameToColorMappingX11.put("grey68", new Color(173, 173, 173));
        nameToColorMappingX11.put("grey69", new Color(176, 176, 176));
        nameToColorMappingX11.put("grey7", new Color(18, 18, 18));
        nameToColorMappingX11.put("grey70", new Color(179, 179, 179));
        nameToColorMappingX11.put("grey71", new Color(181, 181, 181));
        nameToColorMappingX11.put("grey72", new Color(184, 184, 184));
        nameToColorMappingX11.put("grey73", new Color(186, 186, 186));
        nameToColorMappingX11.put("grey74", new Color(189, 189, 189));
        nameToColorMappingX11.put("grey75", new Color(191, 191, 191));
        nameToColorMappingX11.put("grey76", new Color(194, 194, 194));
        nameToColorMappingX11.put("grey77", new Color(196, 196, 196));
        nameToColorMappingX11.put("grey78", new Color(199, 199, 199));
        nameToColorMappingX11.put("grey79", new Color(201, 201, 201));
        nameToColorMappingX11.put("grey8", new Color(20, 20, 20));
        nameToColorMappingX11.put("grey80", new Color(204, 204, 204));
        nameToColorMappingX11.put("grey81", new Color(207, 207, 207));
        nameToColorMappingX11.put("grey82", new Color(209, 209, 209));
        nameToColorMappingX11.put("grey83", new Color(212, 212, 212));
        nameToColorMappingX11.put("grey84", new Color(214, 214, 214));
        nameToColorMappingX11.put("grey85", new Color(217, 217, 217));
        nameToColorMappingX11.put("grey86", new Color(219, 219, 219));
        nameToColorMappingX11.put("grey87", new Color(222, 222, 222));
        nameToColorMappingX11.put("grey88", new Color(224, 224, 224));
        nameToColorMappingX11.put("grey89", new Color(227, 227, 227));
        nameToColorMappingX11.put("grey9", new Color(23, 23, 23));
        nameToColorMappingX11.put("grey90", new Color(229, 229, 229));
        nameToColorMappingX11.put("grey91", new Color(232, 232, 232));
        nameToColorMappingX11.put("grey92", new Color(235, 235, 235));
        nameToColorMappingX11.put("grey93", new Color(237, 237, 237));
        nameToColorMappingX11.put("grey94", new Color(240, 240, 240));
        nameToColorMappingX11.put("grey95", new Color(242, 242, 242));
        nameToColorMappingX11.put("grey96", new Color(245, 245, 245));
        nameToColorMappingX11.put("grey97", new Color(247, 247, 247));
        nameToColorMappingX11.put("grey98", new Color(250, 250, 250));
        nameToColorMappingX11.put("grey99", new Color(252, 252, 252));
        nameToColorMappingX11.put("honeydew", new Color(240, 255, 240));
        nameToColorMappingX11.put("honeydew1", new Color(240, 255, 240));
        nameToColorMappingX11.put("honeydew2", new Color(224, 238, 224));
        nameToColorMappingX11.put("honeydew3", new Color(193, 205, 193));
        nameToColorMappingX11.put("honeydew4", new Color(131, 139, 131));
        nameToColorMappingX11.put("hotpink", new Color(255, 105, 180));
        nameToColorMappingX11.put("hotpink1", new Color(255, 110, 180));
        nameToColorMappingX11.put("hotpink2", new Color(238, 106, 167));
        nameToColorMappingX11.put("hotpink3", new Color(205, 96, 144));
        nameToColorMappingX11.put("hotpink4", new Color(139, 58, 98));
        nameToColorMappingX11.put("indianred", new Color(205, 92, 92));
        nameToColorMappingX11.put("indianred1", new Color(255, 106, 106));
        nameToColorMappingX11.put("indianred2", new Color(238, 99, 99));
        nameToColorMappingX11.put("indianred3", new Color(205, 85, 85));
        nameToColorMappingX11.put("indianred4", new Color(139, 58, 58));
        nameToColorMappingX11.put("ivory", new Color(255, 255, 240));
        nameToColorMappingX11.put("ivory1", new Color(255, 255, 240));
        nameToColorMappingX11.put("ivory2", new Color(238, 238, 224));
        nameToColorMappingX11.put("ivory3", new Color(205, 205, 193));
        nameToColorMappingX11.put("ivory4", new Color(139, 139, 131));
        nameToColorMappingX11.put("khaki", new Color(240, 230, 140));
        nameToColorMappingX11.put("khaki1", new Color(255, 246, 143));
        nameToColorMappingX11.put("khaki2", new Color(238, 230, 133));
        nameToColorMappingX11.put("khaki3", new Color(205, 198, 115));
        nameToColorMappingX11.put("khaki4", new Color(139, 134, 78));
        nameToColorMappingX11.put("lavender", new Color(230, 230, 250));
        nameToColorMappingX11.put("lavenderblush", new Color(255, 240, 245));
        nameToColorMappingX11.put("lavenderblush1", new Color(255, 240, 245));
        nameToColorMappingX11.put("lavenderblush2", new Color(238, 224, 229));
        nameToColorMappingX11.put("lavenderblush3", new Color(205, 193, 197));
        nameToColorMappingX11.put("lavenderblush4", new Color(139, 131, 134));
        nameToColorMappingX11.put("lawngreen", new Color(124, 252, 0));
        nameToColorMappingX11.put("lemonchiffon", new Color(255, 250, 205));
        nameToColorMappingX11.put("lemonchiffon1", new Color(255, 250, 205));
        nameToColorMappingX11.put("lemonchiffon2", new Color(238, 233, 191));
        nameToColorMappingX11.put("lemonchiffon3", new Color(205, 201, 165));
        nameToColorMappingX11.put("lemonchiffon4", new Color(139, 137, 112));
        nameToColorMappingX11.put("lightblue", new Color(173, 216, 230));
        nameToColorMappingX11.put("lightblue1", new Color(191, 239, 255));
        nameToColorMappingX11.put("lightblue2", new Color(178, 223, 238));
        nameToColorMappingX11.put("lightblue3", new Color(154, 192, 205));
        nameToColorMappingX11.put("lightblue4", new Color(104, 131, 139));
        nameToColorMappingX11.put("lightcoral", new Color(240, 128, 128));
        nameToColorMappingX11.put("lightcyan", new Color(224, 255, 255));
        nameToColorMappingX11.put("lightcyan1", new Color(224, 255, 255));
        nameToColorMappingX11.put("lightcyan2", new Color(209, 238, 238));
        nameToColorMappingX11.put("lightcyan3", new Color(180, 205, 205));
        nameToColorMappingX11.put("lightcyan4", new Color(122, 139, 139));
        nameToColorMappingX11.put("lightgoldenrod", new Color(238, 221, 130));
        nameToColorMappingX11.put("lightgoldenrod1", new Color(255, 236, 139));
        nameToColorMappingX11.put("lightgoldenrod2", new Color(238, 220, 130));
        nameToColorMappingX11.put("lightgoldenrod3", new Color(205, 190, 112));
        nameToColorMappingX11.put("lightgoldenrod4", new Color(139, 129, 76));
        nameToColorMappingX11.put("lightgoldenrodyellow", new Color(250, 250, 210));
        nameToColorMappingX11.put("lightgray", new Color(211, 211, 211));
        nameToColorMappingX11.put("lightgreen", new Color(144, 238, 144));
        nameToColorMappingX11.put("lightgrey", new Color(211, 211, 211));
        nameToColorMappingX11.put("lightpink", new Color(255, 182, 193));
        nameToColorMappingX11.put("lightpink1", new Color(255, 174, 185));
        nameToColorMappingX11.put("lightpink2", new Color(238, 162, 173));
        nameToColorMappingX11.put("lightpink3", new Color(205, 140, 149));
        nameToColorMappingX11.put("lightpink4", new Color(139, 95, 101));
        nameToColorMappingX11.put("lightsalmon", new Color(255, 160, 122));
        nameToColorMappingX11.put("lightsalmon1", new Color(255, 160, 122));
        nameToColorMappingX11.put("lightsalmon2", new Color(238, 149, 114));
        nameToColorMappingX11.put("lightsalmon3", new Color(205, 129, 98));
        nameToColorMappingX11.put("lightsalmon4", new Color(139, 87, 66));
        nameToColorMappingX11.put("lightseagreen", new Color(32, 178, 170));
        nameToColorMappingX11.put("lightskyblue", new Color(135, 206, 250));
        nameToColorMappingX11.put("lightskyblue1", new Color(176, 226, 255));
        nameToColorMappingX11.put("lightskyblue2", new Color(164, 211, 238));
        nameToColorMappingX11.put("lightskyblue3", new Color(141, 182, 205));
        nameToColorMappingX11.put("lightskyblue4", new Color(96, 123, 139));
        nameToColorMappingX11.put("lightslateblue", new Color(132, 112, 255));
        nameToColorMappingX11.put("lightslategray", new Color(119, 136, 153));
        nameToColorMappingX11.put("lightslategrey", new Color(119, 136, 153));
        nameToColorMappingX11.put("lightsteelblue", new Color(176, 196, 222));
        nameToColorMappingX11.put("lightsteelblue1", new Color(202, 225, 255));
        nameToColorMappingX11.put("lightsteelblue2", new Color(188, 210, 238));
        nameToColorMappingX11.put("lightsteelblue3", new Color(162, 181, 205));
        nameToColorMappingX11.put("lightsteelblue4", new Color(110, 123, 139));
        nameToColorMappingX11.put("lightyellow", new Color(255, 255, 224));
        nameToColorMappingX11.put("lightyellow1", new Color(255, 255, 224));
        nameToColorMappingX11.put("lightyellow2", new Color(238, 238, 209));
        nameToColorMappingX11.put("lightyellow3", new Color(205, 205, 180));
        nameToColorMappingX11.put("lightyellow4", new Color(139, 139, 122));
        nameToColorMappingX11.put("lime", new Color(0, 255, 0));
        nameToColorMappingX11.put("limegreen", new Color(50, 205, 50));
        nameToColorMappingX11.put("linen", new Color(250, 240, 230));
        nameToColorMappingX11.put("magenta", new Color(255, 0, 255));
        nameToColorMappingX11.put("magenta1", new Color(255, 0, 255));
        nameToColorMappingX11.put("magenta2", new Color(238, 0, 238));
        nameToColorMappingX11.put("magenta3", new Color(205, 0, 205));
        nameToColorMappingX11.put("magenta4", new Color(139, 0, 139));
        nameToColorMappingX11.put("maroon", new Color(176, 48, 96));
        nameToColorMappingX11.put("maroon1", new Color(255, 52, 179));
        nameToColorMappingX11.put("maroon2", new Color(238, 48, 167));
        nameToColorMappingX11.put("maroon3", new Color(205, 41, 144));
        nameToColorMappingX11.put("maroon4", new Color(139, 28, 98));
        nameToColorMappingX11.put("mediumaquamarine", new Color(102, 205, 170));
        nameToColorMappingX11.put("mediumblue", new Color(0, 0, 205));
        nameToColorMappingX11.put("mediumorchid", new Color(186, 85, 211));
        nameToColorMappingX11.put("mediumorchid1", new Color(224, 102, 255));
        nameToColorMappingX11.put("mediumorchid2", new Color(209, 95, 238));
        nameToColorMappingX11.put("mediumorchid3", new Color(180, 82, 205));
        nameToColorMappingX11.put("mediumorchid4", new Color(122, 55, 139));
        nameToColorMappingX11.put("mediumpurple", new Color(147, 112, 219));
        nameToColorMappingX11.put("mediumpurple1", new Color(171, 130, 255));
        nameToColorMappingX11.put("mediumpurple2", new Color(159, 121, 238));
        nameToColorMappingX11.put("mediumpurple3", new Color(137, 104, 205));
        nameToColorMappingX11.put("mediumpurple4", new Color(93, 71, 139));
        nameToColorMappingX11.put("mediumseagreen", new Color(60, 179, 113));
        nameToColorMappingX11.put("mediumslateblue", new Color(123, 104, 238));
        nameToColorMappingX11.put("mediumspringgreen", new Color(0, 250, 154));
        nameToColorMappingX11.put("mediumturquoise", new Color(72, 209, 204));
        nameToColorMappingX11.put("mediumvioletred", new Color(199, 21, 133));
        nameToColorMappingX11.put("midnightblue", new Color(25, 25, 112));
        nameToColorMappingX11.put("mintcream", new Color(245, 255, 250));
        nameToColorMappingX11.put("mistyrose", new Color(255, 228, 225));
        nameToColorMappingX11.put("mistyrose1", new Color(255, 228, 225));
        nameToColorMappingX11.put("mistyrose2", new Color(238, 213, 210));
        nameToColorMappingX11.put("mistyrose3", new Color(205, 183, 181));
        nameToColorMappingX11.put("mistyrose4", new Color(139, 125, 123));
        nameToColorMappingX11.put("moccasin", new Color(255, 228, 181));
        nameToColorMappingX11.put("navajowhite", new Color(255, 222, 173));
        nameToColorMappingX11.put("navajowhite1", new Color(255, 222, 173));
        nameToColorMappingX11.put("navajowhite2", new Color(238, 207, 161));
        nameToColorMappingX11.put("navajowhite3", new Color(205, 179, 139));
        nameToColorMappingX11.put("navajowhite4", new Color(139, 121, 94));
        nameToColorMappingX11.put("navy", new Color(0, 0, 128));
        nameToColorMappingX11.put("navyblue", new Color(0, 0, 128));
        nameToColorMappingX11.put("oldlace", new Color(253, 245, 230));
        nameToColorMappingX11.put("olivedrab", new Color(107, 142, 35));
        nameToColorMappingX11.put("olivedrab1", new Color(192, 255, 62));
        nameToColorMappingX11.put("olivedrab2", new Color(179, 238, 58));
        nameToColorMappingX11.put("olivedrab3", new Color(154, 205, 50));
        nameToColorMappingX11.put("olivedrab4", new Color(105, 139, 34));
        nameToColorMappingX11.put("orange", new Color(255, 165, 0));
        nameToColorMappingX11.put("orange1", new Color(255, 165, 0));
        nameToColorMappingX11.put("orange2", new Color(238, 154, 0));
        nameToColorMappingX11.put("orange3", new Color(205, 133, 0));
        nameToColorMappingX11.put("orange4", new Color(139, 90, 0));
        nameToColorMappingX11.put("orangered", new Color(255, 69, 0));
        nameToColorMappingX11.put("orangered1", new Color(255, 69, 0));
        nameToColorMappingX11.put("orangered2", new Color(238, 64, 0));
        nameToColorMappingX11.put("orangered3", new Color(205, 55, 0));
        nameToColorMappingX11.put("orangered4", new Color(139, 37, 0));
        nameToColorMappingX11.put("orchid", new Color(218, 112, 214));
        nameToColorMappingX11.put("orchid1", new Color(255, 131, 250));
        nameToColorMappingX11.put("orchid2", new Color(238, 122, 233));
        nameToColorMappingX11.put("orchid3", new Color(205, 105, 201));
        nameToColorMappingX11.put("orchid4", new Color(139, 71, 137));
        nameToColorMappingX11.put("palegoldenrod", new Color(238, 232, 170));
        nameToColorMappingX11.put("palegreen", new Color(152, 251, 152));
        nameToColorMappingX11.put("palegreen1", new Color(154, 255, 154));
        nameToColorMappingX11.put("palegreen2", new Color(144, 238, 144));
        nameToColorMappingX11.put("palegreen3", new Color(124, 205, 124));
        nameToColorMappingX11.put("palegreen4", new Color(84, 139, 84));
        nameToColorMappingX11.put("paleturquoise", new Color(175, 238, 238));
        nameToColorMappingX11.put("paleturquoise1", new Color(187, 255, 255));
        nameToColorMappingX11.put("paleturquoise2", new Color(174, 238, 238));
        nameToColorMappingX11.put("paleturquoise3", new Color(150, 205, 205));
        nameToColorMappingX11.put("paleturquoise4", new Color(102, 139, 139));
        nameToColorMappingX11.put("palevioletred", new Color(219, 112, 147));
        nameToColorMappingX11.put("palevioletred1", new Color(255, 130, 171));
        nameToColorMappingX11.put("palevioletred2", new Color(238, 121, 159));
        nameToColorMappingX11.put("palevioletred3", new Color(205, 104, 137));
        nameToColorMappingX11.put("palevioletred4", new Color(139, 71, 93));
        nameToColorMappingX11.put("papayawhip", new Color(255, 239, 213));
        nameToColorMappingX11.put("peachpuff", new Color(255, 218, 185));
        nameToColorMappingX11.put("peachpuff1", new Color(255, 218, 185));
        nameToColorMappingX11.put("peachpuff2", new Color(238, 203, 173));
        nameToColorMappingX11.put("peachpuff3", new Color(205, 175, 149));
        nameToColorMappingX11.put("peachpuff4", new Color(139, 119, 101));
        nameToColorMappingX11.put("peru", new Color(205, 133, 63));
        nameToColorMappingX11.put("pink", new Color(255, 192, 203));
        nameToColorMappingX11.put("pink1", new Color(255, 181, 197));
        nameToColorMappingX11.put("pink2", new Color(238, 169, 184));
        nameToColorMappingX11.put("pink3", new Color(205, 145, 158));
        nameToColorMappingX11.put("pink4", new Color(139, 99, 108));
        nameToColorMappingX11.put("plum", new Color(221, 160, 221));
        nameToColorMappingX11.put("plum1", new Color(255, 187, 255));
        nameToColorMappingX11.put("plum2", new Color(238, 174, 238));
        nameToColorMappingX11.put("plum3", new Color(205, 150, 205));
        nameToColorMappingX11.put("plum4", new Color(139, 102, 139));
        nameToColorMappingX11.put("powderblue", new Color(176, 224, 230));
        nameToColorMappingX11.put("purple", new Color(160, 32, 240));
        nameToColorMappingX11.put("purple1", new Color(155, 48, 255));
        nameToColorMappingX11.put("purple2", new Color(145, 44, 238));
        nameToColorMappingX11.put("purple3", new Color(125, 38, 205));
        nameToColorMappingX11.put("purple4", new Color(85, 26, 139));
        nameToColorMappingX11.put("red", new Color(255, 0, 0));
        nameToColorMappingX11.put("red1", new Color(255, 0, 0));
        nameToColorMappingX11.put("red2", new Color(238, 0, 0));
        nameToColorMappingX11.put("red3", new Color(205, 0, 0));
        nameToColorMappingX11.put("red4", new Color(139, 0, 0));
        nameToColorMappingX11.put("rosybrown", new Color(188, 143, 143));
        nameToColorMappingX11.put("rosybrown1", new Color(255, 193, 193));
        nameToColorMappingX11.put("rosybrown2", new Color(238, 180, 180));
        nameToColorMappingX11.put("rosybrown3", new Color(205, 155, 155));
        nameToColorMappingX11.put("rosybrown4", new Color(139, 105, 105));
        nameToColorMappingX11.put("royalblue", new Color(65, 105, 225));
        nameToColorMappingX11.put("royalblue1", new Color(72, 118, 255));
        nameToColorMappingX11.put("royalblue2", new Color(67, 110, 238));
        nameToColorMappingX11.put("royalblue3", new Color(58, 95, 205));
        nameToColorMappingX11.put("royalblue4", new Color(39, 64, 139));
        nameToColorMappingX11.put("saddlebrown", new Color(139, 69, 19));
        nameToColorMappingX11.put("salmon", new Color(250, 128, 114));
        nameToColorMappingX11.put("salmon1", new Color(255, 140, 105));
        nameToColorMappingX11.put("salmon2", new Color(238, 130, 98));
        nameToColorMappingX11.put("salmon3", new Color(205, 112, 84));
        nameToColorMappingX11.put("salmon4", new Color(139, 76, 57));
        nameToColorMappingX11.put("sandybrown", new Color(244, 164, 96));
        nameToColorMappingX11.put("seagreen", new Color(46, 139, 87));
        nameToColorMappingX11.put("seagreen1", new Color(84, 255, 159));
        nameToColorMappingX11.put("seagreen2", new Color(78, 238, 148));
        nameToColorMappingX11.put("seagreen3", new Color(67, 205, 128));
        nameToColorMappingX11.put("seagreen4", new Color(46, 139, 87));
        nameToColorMappingX11.put("seashell", new Color(255, 245, 238));
        nameToColorMappingX11.put("seashell1", new Color(255, 245, 238));
        nameToColorMappingX11.put("seashell2", new Color(238, 229, 222));
        nameToColorMappingX11.put("seashell3", new Color(205, 197, 191));
        nameToColorMappingX11.put("seashell4", new Color(139, 134, 130));
        nameToColorMappingX11.put("sienna", new Color(160, 82, 45));
        nameToColorMappingX11.put("sienna1", new Color(255, 130, 71));
        nameToColorMappingX11.put("sienna2", new Color(238, 121, 66));
        nameToColorMappingX11.put("sienna3", new Color(205, 104, 57));
        nameToColorMappingX11.put("sienna4", new Color(139, 71, 38));
        nameToColorMappingX11.put("skyblue", new Color(135, 206, 235));
        nameToColorMappingX11.put("skyblue1", new Color(135, 206, 255));
        nameToColorMappingX11.put("skyblue2", new Color(126, 192, 238));
        nameToColorMappingX11.put("skyblue3", new Color(108, 166, 205));
        nameToColorMappingX11.put("skyblue4", new Color(74, 112, 139));
        nameToColorMappingX11.put("slateblue", new Color(106, 90, 205));
        nameToColorMappingX11.put("slateblue1", new Color(131, 111, 255));
        nameToColorMappingX11.put("slateblue2", new Color(122, 103, 238));
        nameToColorMappingX11.put("slateblue3", new Color(105, 89, 205));
        nameToColorMappingX11.put("slateblue4", new Color(71, 60, 139));
        nameToColorMappingX11.put("slategray", new Color(112, 128, 144));
        nameToColorMappingX11.put("slategray1", new Color(198, 226, 255));
        nameToColorMappingX11.put("slategray2", new Color(185, 211, 238));
        nameToColorMappingX11.put("slategray3", new Color(159, 182, 205));
        nameToColorMappingX11.put("slategray4", new Color(108, 123, 139));
        nameToColorMappingX11.put("slategrey", new Color(112, 128, 144));
        nameToColorMappingX11.put("snow", new Color(255, 250, 250));
        nameToColorMappingX11.put("snow1", new Color(255, 250, 250));
        nameToColorMappingX11.put("snow2", new Color(238, 233, 233));
        nameToColorMappingX11.put("snow3", new Color(205, 201, 201));
        nameToColorMappingX11.put("snow4", new Color(139, 137, 137));
        nameToColorMappingX11.put("springgreen", new Color(0, 255, 127));
        nameToColorMappingX11.put("springgreen1", new Color(0, 255, 127));
        nameToColorMappingX11.put("springgreen2", new Color(0, 238, 118));
        nameToColorMappingX11.put("springgreen3", new Color(0, 205, 102));
        nameToColorMappingX11.put("springgreen4", new Color(0, 139, 69));
        nameToColorMappingX11.put("steelblue", new Color(70, 130, 180));
        nameToColorMappingX11.put("steelblue1", new Color(99, 184, 255));
        nameToColorMappingX11.put("steelblue2", new Color(92, 172, 238));
        nameToColorMappingX11.put("steelblue3", new Color(79, 148, 205));
        nameToColorMappingX11.put("steelblue4", new Color(54, 100, 139));
        nameToColorMappingX11.put("tan", new Color(210, 180, 140));
        nameToColorMappingX11.put("tan1", new Color(255, 165, 79));
        nameToColorMappingX11.put("tan2", new Color(238, 154, 73));
        nameToColorMappingX11.put("tan3", new Color(205, 133, 63));
        nameToColorMappingX11.put("tan4", new Color(139, 90, 43));
        nameToColorMappingX11.put("thistle", new Color(216, 191, 216));
        nameToColorMappingX11.put("thistle1", new Color(255, 225, 255));
        nameToColorMappingX11.put("thistle2", new Color(238, 210, 238));
        nameToColorMappingX11.put("thistle3", new Color(205, 181, 205));
        nameToColorMappingX11.put("thistle4", new Color(139, 123, 139));
        nameToColorMappingX11.put("tomato", new Color(255, 99, 71));
        nameToColorMappingX11.put("tomato1", new Color(255, 99, 71));
        nameToColorMappingX11.put("tomato2", new Color(238, 92, 66));
        nameToColorMappingX11.put("tomato3", new Color(205, 79, 57));
        nameToColorMappingX11.put("tomato4", new Color(139, 54, 38));
        nameToColorMappingX11.put("turquoise", new Color(64, 224, 208));
        nameToColorMappingX11.put("turquoise1", new Color(0, 245, 255));
        nameToColorMappingX11.put("turquoise2", new Color(0, 229, 238));
        nameToColorMappingX11.put("turquoise3", new Color(0, 197, 205));
        nameToColorMappingX11.put("turquoise4", new Color(0, 134, 139));
        nameToColorMappingX11.put("violet", new Color(238, 130, 238));
        nameToColorMappingX11.put("violetred", new Color(208, 32, 144));
        nameToColorMappingX11.put("violetred1", new Color(255, 62, 150));
        nameToColorMappingX11.put("violetred2", new Color(238, 58, 140));
        nameToColorMappingX11.put("violetred3", new Color(205, 50, 120));
        nameToColorMappingX11.put("violetred4", new Color(139, 34, 82));
        nameToColorMappingX11.put("wheat", new Color(245, 222, 179));
        nameToColorMappingX11.put("wheat1", new Color(255, 231, 186));
        nameToColorMappingX11.put("wheat2", new Color(238, 216, 174));
        nameToColorMappingX11.put("wheat3", new Color(205, 186, 150));
        nameToColorMappingX11.put("wheat4", new Color(139, 126, 102));
        nameToColorMappingX11.put("white", new Color(255, 255, 255));
        nameToColorMappingX11.put("whitesmoke", new Color(245, 245, 245));
        nameToColorMappingX11.put("yellow", new Color(255, 255, 0));
        nameToColorMappingX11.put("yellow1", new Color(255, 255, 0));
        nameToColorMappingX11.put("yellow2", new Color(238, 238, 0));
        nameToColorMappingX11.put("yellow3", new Color(205, 205, 0));
        nameToColorMappingX11.put("yellow4", new Color(139, 139, 0));
        nameToColorMappingX11.put("yellowgreen", new Color(154, 205, 50));
        nameToColorMappingHTML.put("black", new Color(0, 0, 0));
        nameToColorMappingHTML.put("navy", new Color(0, 0, 128));
        nameToColorMappingHTML.put("blue", new Color(0, 0, 255));
        nameToColorMappingHTML.put("green", new Color(0, 128, 0));
        nameToColorMappingHTML.put("teal", new Color(0, 128, 128));
        nameToColorMappingHTML.put("lime", new Color(0, 255, 0));
        nameToColorMappingHTML.put("aqua", new Color(0, 255, 255));
        nameToColorMappingHTML.put("maroon", new Color(128, 0, 0));
        nameToColorMappingHTML.put("purple", new Color(128, 0, 128));
        nameToColorMappingHTML.put("olive", new Color(128, 128, 0));
        nameToColorMappingHTML.put("gray", new Color(128, 128, 128));
        nameToColorMappingHTML.put("silver", new Color(208, 208, 208));
        nameToColorMappingHTML.put("red", new Color(255, 0, 0));
        nameToColorMappingHTML.put("fuchsia", new Color(255, 0, 255));
        nameToColorMappingHTML.put("yellow", new Color(255, 255, 0));
        nameToColorMappingHTML.put("white", new Color(255, 255, 255));
        DOMAIN_X11 = new Domain("X11", nameToColorMappingX11);
        DOMAIN_HTML = new Domain("HTML 4.01", nameToColorMappingHTML);
        DOMAINS_HTML_FIRST = Types.asList((Object[])new Domain[]{DOMAIN_HTML, DOMAIN_X11});
        DOMAINS_X11_FIRST = Types.asList((Object[])new Domain[]{DOMAIN_X11, DOMAIN_HTML});
    }

    public static final class Domain {
        private final String domain;
        private final Map<String, Color> mapping;

        public Domain(@NotNull String string, @NotNull Map<String, Color> map) {
            this.domain = string;
            this.mapping = map;
        }

        @NotNull
        public String getDomain() {
            return this.domain;
        }

        @Nullable
        Color mapName(String string) {
            return this.mapping.get(string);
        }

        @NotNull
        public String toString() {
            return this.domain;
        }
    }
}

