/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Empty;
import de.caff.util.ByteCollector;
import java.util.Arrays;

public class ByteRingBuffer
implements ByteCollector {
    static final int INITIAL_LIMIT = 0x100000;
    private final int limit;
    private byte[] ringBuffer;
    private int bufferOffset;
    private int bytesCached;
    private long totalNumberOfBytes;

    public ByteRingBuffer(int n) {
        this(n, 0x100000);
    }

    ByteRingBuffer(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("limit has to be positive, but is " + n);
        }
        this.ringBuffer = n < n2 ? new byte[n] : new byte[n2];
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    public synchronized int size() {
        return this.bytesCached;
    }

    @Override
    public synchronized void append(int n) {
        byte by = (byte)n;
        if (this.bufferOffset < this.ringBuffer.length) {
            this.ringBuffer[this.bufferOffset++] = by;
            if (this.bytesCached < this.limit) {
                ++this.bytesCached;
            }
            ++this.totalNumberOfBytes;
        } else if (this.ringBuffer.length == this.limit) {
            this.ringBuffer[0] = by;
            this.bufferOffset = 1;
            ++this.totalNumberOfBytes;
        } else {
            this.append(by);
        }
    }

    @Override
    public synchronized void append(@NotNull byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 - byArray.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.appendInternally(byArray, n, n2);
    }

    private void appendInternally(@NotNull byte[] byArray, int n, int n2) {
        if (n2 > this.ringBuffer.length - this.bufferOffset) {
            if (this.ringBuffer.length < this.limit) {
                int n3 = this.ringBuffer.length > 0x3FFFFFFF ? this.limit : Math.min(this.limit, 2 * this.ringBuffer.length);
                this.ringBuffer = Arrays.copyOf(this.ringBuffer, n3);
                this.appendInternally(byArray, n, n2);
                return;
            }
            if (n2 > this.limit) {
                this.clear();
                int n4 = n2 - this.limit;
                this.appendInternally(byArray, n + n4, this.limit);
                return;
            }
            assert (this.ringBuffer.length == this.limit);
            int n5 = this.limit - this.bufferOffset;
            if (n5 > 0) {
                System.arraycopy(byArray, n, this.ringBuffer, this.bufferOffset, n5);
                n += n5;
                n2 -= n5;
                this.totalNumberOfBytes += (long)n5;
            }
            this.bufferOffset = 0;
            this.bytesCached = this.limit;
        }
        System.arraycopy(byArray, n, this.ringBuffer, this.bufferOffset, n2);
        this.bufferOffset += n2;
        if (this.bytesCached < this.limit) {
            this.bytesCached += Math.min(n2, this.limit - this.bytesCached);
        }
        this.totalNumberOfBytes += (long)n2;
    }

    @NotNull
    public synchronized byte[] toByteArray() {
        if (this.bytesCached == 0) {
            return Empty.BYTE_ARRAY;
        }
        byte[] byArray = new byte[this.bytesCached];
        if (this.bufferOffset < this.bytesCached) {
            int n = this.bytesCached - this.bufferOffset;
            System.arraycopy(this.ringBuffer, this.limit - n, byArray, 0, n);
            System.arraycopy(this.ringBuffer, 0, byArray, n, this.bufferOffset);
        } else {
            System.arraycopy(this.ringBuffer, this.bufferOffset - this.bytesCached, byArray, 0, this.bytesCached);
        }
        return byArray;
    }

    @NotNull
    public synchronized ByteIndexable view() {
        if (this.bytesCached == 0) {
            return ByteIndexable.EMPTY;
        }
        if (this.bufferOffset >= this.bytesCached) {
            return ByteIndexable.viewArray((byte[])this.ringBuffer, (int)(this.bufferOffset - this.bytesCached), (int)this.bytesCached);
        }
        final int n = this.bytesCached;
        final int n2 = this.bufferOffset;
        final int n3 = this.ringBuffer.length - n2;
        return new ByteIndexable.Base(){

            public byte get(int n4) {
                if (n4 < n3) {
                    return ByteRingBuffer.this.ringBuffer[n2 + n4];
                }
                return ByteRingBuffer.this.ringBuffer[n4 - n3];
            }

            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public synchronized ByteIndexable toByteIndexable() {
        return this.view().frozen();
    }

    @Override
    public synchronized void clear() {
        this.bufferOffset = 0;
        this.bytesCached = 0;
    }

    @Override
    public synchronized long getNumberOfCollectedBytes() {
        return this.totalNumberOfBytes;
    }
}

