/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public enum ByteOrderMark {
    Utf8(StandardCharsets.UTF_8, 239, 187, 191),
    Utf16BE(StandardCharsets.UTF_16BE, 254, 255),
    Utf16LE(StandardCharsets.UTF_16LE, 255, 254),
    Utf32BE(Charset.forName("UTF-32BE"), 0, 0, 254, 255),
    Utf32LE(Charset.forName("UTF-32LE"), 255, 254, 0, 0);

    private static final int MAX_BOM_LENGTH;
    @NotNull
    private final Charset charset;
    @NotNull
    private final byte[] mark;

    private ByteOrderMark(Charset charset, int ... nArray) {
        this.charset = charset;
        this.mark = Types.toByteArray((int[])nArray);
    }

    @NotNull
    public Charset getCharset() {
        return this.charset;
    }

    public void write(@NotNull OutputStream outputStream) throws IOException {
        outputStream.write(this.mark);
    }

    @Nullable
    public static ByteOrderMark check(@NotNull InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("Can only check BOM for markable streams!");
        }
        byte[] byArray = new byte[MAX_BOM_LENGTH];
        for (ByteOrderMark byteOrderMark : ByteOrderMark.values()) {
            inputStream.mark(byteOrderMark.mark.length);
            int n = inputStream.read(byArray, 0, byteOrderMark.mark.length);
            if (n == byteOrderMark.mark.length && ByteOrderMark.equals(byArray, byteOrderMark.mark, byteOrderMark.mark.length)) {
                return byteOrderMark;
            }
            inputStream.reset();
        }
        return null;
    }

    private static boolean equals(@NotNull byte[] byArray, @NotNull byte[] byArray2, int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static {
        int n = 0;
        for (ByteOrderMark byteOrderMark : ByteOrderMark.values()) {
            if (byteOrderMark.mark.length <= n) continue;
            n = byteOrderMark.mark.length;
        }
        MAX_BOM_LENGTH = n;
    }
}

