/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    @NotNull
    private final ByteBuffer buffer;

    public ByteBufferInputStream(@NotNull ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(this.buffer.remaining(), n2);
        this.buffer.get(byArray, n, n2);
        return n3 > 0 ? n3 : (n2 == 0 ? 0 : -1);
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        int n = (int)Math.min((long)this.buffer.remaining(), l);
        this.buffer.position(this.buffer.position() + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public synchronized void mark(int n) {
        this.buffer.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

